/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.dflib.csv;

import com.nhl.dflib.Index;
import com.nhl.dflib.csv.SamplingCsvLoaderWorker;
import com.nhl.dflib.csv.loader.ColumnBuilder;
import com.nhl.dflib.csv.loader.CsvCell;
import java.util.Iterator;
import java.util.Random;
import java.util.function.Predicate;
import org.apache.commons.csv.CSVRecord;

class FilteringSamplingCsvLoaderWorker
extends SamplingCsvLoaderWorker {
    private CsvCell<?>[] csvRow;
    private Predicate<CsvCell<?>[]> csvRowFilter;

    public FilteringSamplingCsvLoaderWorker(Index columnIndex, ColumnBuilder<?>[] columns, CsvCell<?>[] csvRow, Predicate<CsvCell<?>[]> csvRowFilter, int rowSampleSize, Random rowsSampleRandom) {
        super(columnIndex, columns, rowSampleSize, rowsSampleRandom);
        this.csvRow = csvRow;
        this.csvRowFilter = csvRowFilter;
    }

    @Override
    protected void consumeCSV(Iterator<CSVRecord> it) {
        int width = this.columnIndex.size();
        int i = 0;
        while (it.hasNext()) {
            CSVRecord row = it.next();
            int csvWidth = this.csvRow.length;
            for (int j = 0; j < csvWidth; ++j) {
                this.csvRow[j].set(row);
            }
            if (!this.csvRowFilter.test(this.csvRow)) continue;
            this.sampleBufferedRow(i++, width);
        }
    }

    protected void sampleBufferedRow(int rowNumber, int width) {
        if (rowNumber < this.rowSampleSize) {
            this.addBufferedRow(width);
            this.sampledRows.addInt(rowNumber);
        } else {
            int pos = this.rowsSampleRandom.nextInt(rowNumber + 1);
            if (pos < this.rowSampleSize) {
                this.replaceBufferedRow(pos, width);
                this.sampledRows.setInt(pos, rowNumber);
            }
        }
    }

    protected void addBufferedRow(int width) {
        for (int i = 0; i < width; ++i) {
            this.columnAccumulators[i].add(this.csvRow);
        }
    }

    protected void replaceBufferedRow(int pos, int width) {
        for (int i = 0; i < width; ++i) {
            this.columnAccumulators[i].set(pos, this.csvRow);
        }
    }
}

