/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.dflib.csv;

import com.nhl.dflib.DataFrame;
import com.nhl.dflib.Index;
import com.nhl.dflib.IntSeries;
import com.nhl.dflib.Series;
import com.nhl.dflib.accumulator.IntAccumulator;
import com.nhl.dflib.csv.CsvLoaderWorker;
import com.nhl.dflib.csv.loader.ColumnBuilder;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.csv.CSVRecord;

class SamplingCsvLoaderWorker
implements CsvLoaderWorker {
    protected ColumnBuilder<?>[] columnAccumulators;
    protected Index columnIndex;
    protected int rowSampleSize;
    protected Random rowsSampleRandom;
    protected IntAccumulator sampledRows;

    SamplingCsvLoaderWorker(Index columnIndex, ColumnBuilder<?>[] columnAccumulators, int rowSampleSize, Random rowsSampleRandom) {
        this.columnIndex = columnIndex;
        this.columnAccumulators = columnAccumulators;
        this.rowSampleSize = rowSampleSize;
        this.rowsSampleRandom = rowsSampleRandom;
        this.sampledRows = new IntAccumulator();
    }

    @Override
    public DataFrame load(Iterator<CSVRecord> it) {
        this.consumeCSV(it);
        return this.toDataFrame();
    }

    protected DataFrame toDataFrame() {
        return this.sortSampled(this.toUnsortedDataFrame());
    }

    protected DataFrame toUnsortedDataFrame() {
        int width = this.columnIndex.size();
        Series[] columns = new Series[width];
        for (int i = 0; i < width; ++i) {
            columns[i] = this.columnAccumulators[i].toColumn();
        }
        return DataFrame.newFrame((Index)this.columnIndex).columns(columns);
    }

    protected DataFrame sortSampled(DataFrame sampledUnsorted) {
        IntSeries sortIndex = this.sampledRows.toSeries().sortIndexInt();
        return sampledUnsorted.selectRows(sortIndex);
    }

    protected void consumeCSV(Iterator<CSVRecord> it) {
        int width = this.columnIndex.size();
        int i = 0;
        while (it.hasNext()) {
            CSVRecord row = it.next();
            this.sampleRow(i++, width, row);
        }
    }

    protected void sampleRow(int rowNumber, int width, CSVRecord row) {
        if (rowNumber < this.rowSampleSize) {
            this.addRow(width, row);
            this.sampledRows.addInt(rowNumber);
        } else {
            int pos = this.rowsSampleRandom.nextInt(rowNumber + 1);
            if (pos < this.rowSampleSize) {
                this.replaceRow(pos, width, row);
                this.sampledRows.setInt(pos, rowNumber);
            }
        }
    }

    protected void addRow(int width, CSVRecord record) {
        for (int i = 0; i < width; ++i) {
            this.columnAccumulators[i].add(record);
        }
    }

    protected void replaceRow(int pos, int width, CSVRecord record) {
        for (int i = 0; i < width; ++i) {
            this.columnAccumulators[i].set(pos, record);
        }
    }
}

