/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.dflib.csv.loader;

import com.nhl.dflib.Series;
import com.nhl.dflib.accumulator.Accumulator;
import com.nhl.dflib.accumulator.ValueConverter;
import com.nhl.dflib.csv.loader.CsvCell;
import org.apache.commons.csv.CSVRecord;

public class ColumnBuilder<T> {
    private ValueConverter<String, T> converter;
    private Accumulator<T> accumulator;
    private int csvColumnPosition;

    public ColumnBuilder(ValueConverter<String, T> converter, Accumulator<T> accumulator, int csvColumnPosition) {
        this.converter = converter;
        this.accumulator = accumulator;
        this.csvColumnPosition = csvColumnPosition;
    }

    public void add(CSVRecord record) {
        this.converter.convertAndStore((Object)record.get(this.csvColumnPosition), this.accumulator);
    }

    public void add(CsvCell<?>[] values) {
        CsvCell<?> vhColumn = values[this.csvColumnPosition];
        vhColumn.store(this.accumulator);
    }

    public void set(int pos, CSVRecord record) {
        this.converter.convertAndStore(pos, (Object)record.get(this.csvColumnPosition), this.accumulator);
    }

    public void set(int pos, CsvCell<?>[] values) {
        CsvCell<?> vhColumn = values[this.csvColumnPosition];
        vhColumn.store(pos, this.accumulator);
    }

    public Series<T> toColumn() {
        return this.accumulator.toSeries();
    }
}

