/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.dflib.csv.loader;

import com.nhl.dflib.BooleanValueMapper;
import com.nhl.dflib.DoubleValueMapper;
import com.nhl.dflib.Index;
import com.nhl.dflib.IntValueMapper;
import com.nhl.dflib.LongValueMapper;
import com.nhl.dflib.ValueMapper;
import com.nhl.dflib.accumulator.Accumulator;
import com.nhl.dflib.accumulator.BooleanAccumulator;
import com.nhl.dflib.accumulator.BooleanConverter;
import com.nhl.dflib.accumulator.BooleanHolder;
import com.nhl.dflib.accumulator.DoubleAccumulator;
import com.nhl.dflib.accumulator.DoubleConverter;
import com.nhl.dflib.accumulator.DoubleHolder;
import com.nhl.dflib.accumulator.IntAccumulator;
import com.nhl.dflib.accumulator.IntConverter;
import com.nhl.dflib.accumulator.IntHolder;
import com.nhl.dflib.accumulator.LongAccumulator;
import com.nhl.dflib.accumulator.LongConverter;
import com.nhl.dflib.accumulator.LongHolder;
import com.nhl.dflib.accumulator.ObjectAccumulator;
import com.nhl.dflib.accumulator.ObjectConverter;
import com.nhl.dflib.accumulator.ObjectHolder;
import com.nhl.dflib.accumulator.ValueConverter;
import com.nhl.dflib.accumulator.ValueHolder;
import com.nhl.dflib.csv.loader.ColumnBuilder;
import com.nhl.dflib.csv.loader.CsvCell;
import java.util.List;

public class ColumnConfig {
    private int columnPosition = -1;
    private String columnName;
    private ColumnType type;
    private ObjectConverter<String, ?> objectConverter;
    private IntConverter<String> intConverter;
    private LongConverter<String> longConverter;
    private DoubleConverter<String> doubleConverter;
    private BooleanConverter<String> booleanConverter;

    private ColumnConfig() {
    }

    public static ColumnConfig[] normalize(Index columns, List<ColumnConfig> configs) {
        int w = columns.size();
        ColumnConfig[] normalized = new ColumnConfig[w];
        for (ColumnConfig config : configs) {
            int pos = config.columnPosition >= 0 ? config.columnPosition : columns.position(config.columnName);
            normalized[pos] = config;
        }
        for (int i = 0; i < w; ++i) {
            if (normalized[i] != null) continue;
            normalized[i] = ColumnConfig.objectColumn(i, v -> v);
        }
        return normalized;
    }

    public static ColumnConfig objectColumn(int pos, ValueMapper<String, ?> mapper) {
        ColumnConfig config = new ColumnConfig();
        config.type = ColumnType.object;
        config.columnPosition = pos;
        config.objectConverter = new ObjectConverter(mapper);
        return config;
    }

    public static ColumnConfig objectColumn(String name, ValueMapper<String, ?> mapper) {
        ColumnConfig config = new ColumnConfig();
        config.type = ColumnType.object;
        config.columnName = name;
        config.objectConverter = new ObjectConverter(mapper);
        return config;
    }

    public static ColumnConfig intColumn(int pos) {
        return ColumnConfig.intColumn(pos, (IntValueMapper<String>)IntValueMapper.fromString());
    }

    public static ColumnConfig intColumn(String name) {
        return ColumnConfig.intColumn(name, (IntValueMapper<String>)IntValueMapper.fromString());
    }

    public static ColumnConfig intColumn(int pos, IntValueMapper<String> mapper) {
        ColumnConfig config = new ColumnConfig();
        config.type = ColumnType.intPrimitive;
        config.columnPosition = pos;
        config.intConverter = new IntConverter(mapper);
        return config;
    }

    public static ColumnConfig intColumn(String name, IntValueMapper<String> mapper) {
        ColumnConfig config = new ColumnConfig();
        config.type = ColumnType.intPrimitive;
        config.columnName = name;
        config.intConverter = new IntConverter(mapper);
        return config;
    }

    public static ColumnConfig longColumn(int pos) {
        return ColumnConfig.longColumn(pos, (LongValueMapper<String>)LongValueMapper.fromString());
    }

    public static ColumnConfig longColumn(String name) {
        return ColumnConfig.longColumn(name, (LongValueMapper<String>)LongValueMapper.fromString());
    }

    public static ColumnConfig longColumn(int pos, LongValueMapper<String> mapper) {
        ColumnConfig config = new ColumnConfig();
        config.type = ColumnType.longPrimitive;
        config.columnPosition = pos;
        config.longConverter = new LongConverter(mapper);
        return config;
    }

    public static ColumnConfig longColumn(String name, LongValueMapper<String> mapper) {
        ColumnConfig config = new ColumnConfig();
        config.type = ColumnType.longPrimitive;
        config.columnName = name;
        config.longConverter = new LongConverter(mapper);
        return config;
    }

    public static ColumnConfig doubleColumn(int pos) {
        return ColumnConfig.doubleColumn(pos, (DoubleValueMapper<String>)DoubleValueMapper.fromString());
    }

    public static ColumnConfig doubleColumn(String name) {
        return ColumnConfig.doubleColumn(name, (DoubleValueMapper<String>)DoubleValueMapper.fromString());
    }

    public static ColumnConfig doubleColumn(int pos, DoubleValueMapper<String> mapper) {
        ColumnConfig config = new ColumnConfig();
        config.type = ColumnType.doublePrimitive;
        config.columnPosition = pos;
        config.doubleConverter = new DoubleConverter(mapper);
        return config;
    }

    public static ColumnConfig doubleColumn(String name, DoubleValueMapper<String> mapper) {
        ColumnConfig config = new ColumnConfig();
        config.type = ColumnType.doublePrimitive;
        config.columnName = name;
        config.doubleConverter = new DoubleConverter(mapper);
        return config;
    }

    public static ColumnConfig booleanColumn(int pos) {
        ColumnConfig config = new ColumnConfig();
        config.type = ColumnType.booleanPrimitive;
        config.columnPosition = pos;
        config.booleanConverter = new BooleanConverter(BooleanValueMapper.fromString());
        return config;
    }

    public static ColumnConfig booleanColumn(String name) {
        ColumnConfig config = new ColumnConfig();
        config.type = ColumnType.booleanPrimitive;
        config.columnName = name;
        config.booleanConverter = new BooleanConverter(BooleanValueMapper.fromString());
        return config;
    }

    public ColumnBuilder<?> createAccumulatorColumn(int columnPosition) {
        switch (this.type) {
            case intPrimitive: {
                return new ColumnBuilder(this.intConverter, new IntAccumulator(), columnPosition);
            }
            case longPrimitive: {
                return new ColumnBuilder(this.longConverter, new LongAccumulator(), columnPosition);
            }
            case doublePrimitive: {
                return new ColumnBuilder(this.doubleConverter, new DoubleAccumulator(), columnPosition);
            }
            case booleanPrimitive: {
                return new ColumnBuilder(this.booleanConverter, new BooleanAccumulator(), columnPosition);
            }
        }
        return new ColumnBuilder((ValueConverter<String, ?>)this.objectConverter, (Accumulator<?>)new ObjectAccumulator(), columnPosition);
    }

    public CsvCell<?> createValueHolderColumn(int columnPosition) {
        switch (this.type) {
            case intPrimitive: {
                return new CsvCell(this.intConverter, new IntHolder(), columnPosition);
            }
            case longPrimitive: {
                return new CsvCell(this.longConverter, new LongHolder(), columnPosition);
            }
            case doublePrimitive: {
                return new CsvCell(this.doubleConverter, new DoubleHolder(), columnPosition);
            }
            case booleanPrimitive: {
                return new CsvCell(this.booleanConverter, new BooleanHolder(), columnPosition);
            }
        }
        return new CsvCell((ValueConverter<String, ?>)this.objectConverter, (ValueHolder<?>)new ObjectHolder(), columnPosition);
    }

    static enum ColumnType {
        intPrimitive,
        longPrimitive,
        doublePrimitive,
        booleanPrimitive,
        object;

    }
}

