/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.dflib.csv.loader;

import com.nhl.dflib.Index;
import com.nhl.dflib.ValuePredicate;
import com.nhl.dflib.csv.loader.CsvCell;
import java.util.function.Predicate;

public class RowFilterConfig<V> {
    private int columnPosition = -1;
    private String columnName;
    private ValuePredicate<V> condition;

    private RowFilterConfig() {
    }

    public static <V> RowFilterConfig<V> create(int pos, ValuePredicate<V> condition) {
        RowFilterConfig<V> c = new RowFilterConfig<V>();
        c.columnPosition = pos;
        c.condition = condition;
        return c;
    }

    public static <V> RowFilterConfig<V> create(String name, ValuePredicate<V> condition) {
        RowFilterConfig<V> c = new RowFilterConfig<V>();
        c.columnName = name;
        c.condition = condition;
        return c;
    }

    public Predicate<CsvCell<?>[]> toPredicate(Index columns) {
        int pos = this.columnPosition >= 0 ? this.columnPosition : columns.position(this.columnName);
        return vhcs -> this.condition.test(vhcs[pos].get());
    }
}

