/*
 * Decompiled with CFR 0.152.
 */
package com.nightonke.jellytogglebutton.EaseTypes;

import android.graphics.PointF;

public abstract class CubicBezier {
    private PointF start;
    private PointF end;
    private PointF a = new PointF();
    private PointF b = new PointF();
    private PointF c = new PointF();

    public void init(float startX, float startY, float endX, float endY) {
        this.setStart(new PointF(startX, startY));
        this.setEnd(new PointF(endX, endY));
    }

    public void init(double startX, double startY, double endX, double endY) {
        this.init((float)startX, (float)startY, (float)endX, (float)endY);
    }

    public float getOffset(float offset) {
        return this.getBezierCoordinateY(this.getXForTime(offset));
    }

    private float getBezierCoordinateY(float time) {
        this.c.y = 3.0f * this.start.y;
        this.b.y = 3.0f * (this.end.y - this.start.y) - this.c.y;
        this.a.y = 1.0f - this.c.y - this.b.y;
        return time * (this.c.y + time * (this.b.y + time * this.a.y));
    }

    private float getXForTime(float time) {
        float z;
        float x = time;
        for (int i = 1; i < 14 && !((double)Math.abs(z = this.getBezierCoordinateX(x) - time) < 0.001); ++i) {
            x -= z / this.getXDerivate(x);
        }
        return x;
    }

    private float getXDerivate(float t) {
        return this.c.x + t * (2.0f * this.b.x + 3.0f * this.a.x * t);
    }

    private float getBezierCoordinateX(float time) {
        this.c.x = 3.0f * this.start.x;
        this.b.x = 3.0f * (this.end.x - this.start.x) - this.c.x;
        this.a.x = 1.0f - this.c.x - this.b.x;
        return time * (this.c.x + time * (this.b.x + time * this.a.x));
    }

    public PointF getStart() {
        return this.start;
    }

    public void setStart(PointF start) {
        this.start = start;
    }

    public PointF getEnd() {
        return this.end;
    }

    public void setEnd(PointF end) {
        this.end = end;
    }
}

