/*
 * Decompiled with CFR 0.152.
 */
package com.nightonke.jellytogglebutton;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.content.ContextCompat;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.CompoundButton;
import com.nightonke.jellytogglebutton.ColorChangeTypes.ColorChangeType;
import com.nightonke.jellytogglebutton.EaseTypes.EaseType;
import com.nightonke.jellytogglebutton.JellyTypes.Jelly;
import com.nightonke.jellytogglebutton.JellyTypes.JellyStyle;
import com.nightonke.jellytogglebutton.PointWithHorizontalPoints;
import com.nightonke.jellytogglebutton.PointWithVerticalPoints;
import com.nightonke.jellytogglebutton.R;
import com.nightonke.jellytogglebutton.State;
import com.nightonke.jellytogglebutton.Utils;

public class JellyToggleButton
extends CompoundButton {
    private static final int DEFAULT_LEFT_BACKGROUND_COLOR = Color.parseColor((String)"#1E59AF");
    private static final int DEFAULT_RIGHT_BACKGROUND_COLOR = Color.parseColor((String)"#1E59AF");
    private static final int DEFAULT_LEFT_THUMB_COLOR = Color.parseColor((String)"#FFFFFF");
    private static final int DEFAULT_RIGHT_THUMB_COLOR = Color.parseColor((String)"#FFFFFF");
    private static final int DEFAULT_LEFT_TEXT_COLOR = Color.parseColor((String)"#4085EE");
    private static final int DEFAULT_RIGHT_TEXT_COLOR = Color.parseColor((String)"#4085EE");
    private static final Typeface DEFAULT_LEFT_TEXT_TYPEFACE = Typeface.DEFAULT;
    private static final Typeface DEFAULT_RIGHT_TEXT_TYPEFACE = Typeface.DEFAULT;
    private static final String DEFAULT_LEFT_TEXT = null;
    private static final String DEFAULT_RIGHT_TEXT = null;
    private static final int DEFAULT_LEFT_TEXT_SIZE = 15;
    private static final int DEFAULT_RIGHT_TEXT_SIZE = 15;
    private static final float DEFAULT_TEXT_MARGIN_LEFT_DP = 2.0f;
    private static final float DEFAULT_TEXT_MARGIN_RIGHT_DP = 2.0f;
    private static final float DEFAULT_TEXT_MARGIN_TOP_DP = 2.0f;
    private static final float DEFAULT_TEXT_MARGIN_BOTTOM_DP = 2.0f;
    private static final float DEFAULT_TEXT_MARGIN_CENTER_DP = 3.0f;
    private static final float MIN_TEXT_MARGIN_CENTER_DP = 3.0f;
    private static final float MAX_TEXT_MARGIN_TOP_DP = 5.0f;
    private static final float MAX_TEXT_MARGIN_BOTTOM_DP = 5.0f;
    private static final float DEFAULT_THUMB_RADIUS_DP = 15.0f;
    private static final float DEFAULT_BACKGROUND_MEASURE_VALUE = 1.8f;
    private static final float DEFAULT_BACKGROUND_RADIUS_DP = 10.0f;
    private static final float MIN_THUMB_RADIUS_DP = 15.0f;
    private static final float MIN_BACKGROUND_MEASURE_VALUE = 1.8f;
    private static final float MIN_BACKGROUND_RADIUS_DP = 10.0f;
    private static final int DEFAULT_DURATION = 1000;
    private static final float DEFAULT_TOUCH_MOVE_RATIO_VALUE = 5.0f;
    private static final float DEFAULT_BEZIER_CONTROL_VALUE = 0.55191505f;
    private static final float DEFAULT_STRETCH_DISTANCE_RATIO_VALUE = 1.0f;
    private static final float DEFAULT_BEZIER_SCALE_RATIO_VALUE = 0.45f;
    private static final ColorChangeType DEFAULT_COLOR_CHANGE_TYPE = ColorChangeType.RGB;
    private static final Jelly DEFAULT_JELLY = Jelly.LAZY_TREMBLE_TAIL_FATTY;
    private static final EaseType DEFAULT_EASE_TYPE = EaseType.Linear;
    private static final boolean DEFAULT_MOVE_TO_SAME_STATE_CALL_LISTENER = false;
    private static final boolean DEFAULT_DRAGGABLE = true;
    private int mLeftBackgroundColor = DEFAULT_LEFT_BACKGROUND_COLOR;
    private int mRightBackgroundColor = DEFAULT_RIGHT_BACKGROUND_COLOR;
    private int mLeftThumbColor = DEFAULT_LEFT_THUMB_COLOR;
    private int mRightThumbColor = DEFAULT_RIGHT_THUMB_COLOR;
    private int mLeftTextColor = DEFAULT_LEFT_TEXT_COLOR;
    private int mRightTextColor = DEFAULT_RIGHT_TEXT_COLOR;
    private Typeface mLeftTextTypeface = DEFAULT_LEFT_TEXT_TYPEFACE;
    private Typeface mRightTextTypeface = DEFAULT_RIGHT_TEXT_TYPEFACE;
    private int mLeftTextSize = 15;
    private int mRightTextSize = 15;
    private String mLeftText = DEFAULT_LEFT_TEXT;
    private String mRightText = DEFAULT_RIGHT_TEXT;
    private float mTextMarginLeft;
    private float mTextMarginRight;
    private float mTextMarginTop;
    private float mTextMarginBottom;
    private float mTextMarginCenter;
    private float mThumbRadius;
    private float mBackgroundMeasureRatio = 1.8f;
    private float mBackgroundRadius;
    private int mDuration = 1000;
    private float mTouchMoveRatioValue = 5.0f;
    private float mBezierControlValue = 0.55191505f;
    private float mStretchDistanceRatioValue = 1.0f;
    private float mBezierScaleRatioValue = 0.45f;
    private ColorChangeType mColorChangeType = DEFAULT_COLOR_CHANGE_TYPE;
    private Jelly mJelly = DEFAULT_JELLY;
    private Jelly mRandomJelly = null;
    private EaseType mEaseType = DEFAULT_EASE_TYPE;
    private OnStateChangeListener mOnStateChangeListener;
    private boolean mMoveToSameStateCallListener = false;
    private boolean mDraggable = true;
    private JellyStyle mCustomJelly = null;
    private Paint mPaint;
    private TextPaint mLeftTextPaint;
    private TextPaint mRightTextPaint;
    private Path mThumbPath;
    private Layout mLeftTextLayout;
    private Layout mRightTextLayout;
    private float mTextWidth;
    private float mTextHeight;
    private float mThumbMinRadius;
    private float mThumbMaxRadius;
    private float mThumbLeft;
    private float mThumbRight;
    private float mProcess;
    private ValueAnimator mProcessAnimator;
    private State lastState = null;
    private State mState;
    private float mStartX;
    private float mStartY;
    private float mLastX;
    private int mTouchSlop;
    private int mClickTimeout;
    private PointWithHorizontalPoints mThumbP1;
    private PointWithHorizontalPoints mThumbP3;
    private PointWithVerticalPoints mThumbP2;
    private PointWithVerticalPoints mThumbP4;
    private RectF mBackgroundRectF;
    private RectF mOnTextRectF;
    private RectF mOffTextRectF;
    private int mLastRandomValue = -1;
    private boolean mStopRestoreChecked = false;

    public JellyToggleButton(Context context) {
        super(context);
        this.init(null);
    }

    public JellyToggleButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public JellyToggleButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray ta;
        this.mTouchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
        this.mClickTimeout = ViewConfiguration.getPressedStateDuration() + ViewConfiguration.getTapTimeout();
        this.mPaint = new Paint(1);
        this.mLeftTextPaint = this.getPaint();
        this.mRightTextPaint = this.getPaint();
        this.mThumbPath = new Path();
        this.mThumbP1 = new PointWithHorizontalPoints();
        this.mThumbP2 = new PointWithVerticalPoints();
        this.mThumbP3 = new PointWithHorizontalPoints();
        this.mThumbP4 = new PointWithVerticalPoints();
        this.mBackgroundRectF = new RectF();
        this.mOnTextRectF = new RectF();
        this.mOffTextRectF = new RectF();
        this.setAnimator(0.0f, true);
        Resources res = this.getResources();
        float density = res.getDisplayMetrics().density;
        this.mTextMarginLeft = 2.0f * density;
        this.mTextMarginRight = 2.0f * density;
        this.mTextMarginTop = 2.0f * density;
        this.mTextMarginBottom = 2.0f * density;
        this.mTextMarginCenter = 3.0f * density;
        this.mThumbRadius = 15.0f * density;
        this.mBackgroundRadius = 10.0f * density;
        TypedArray typedArray = ta = attrs == null ? null : this.getContext().obtainStyledAttributes(attrs, R.styleable.JellyToggleButton);
        if (ta != null) {
            this.mLeftBackgroundColor = ta.getColor(R.styleable.JellyToggleButton_jtbLeftBackgroundColor, this.mLeftBackgroundColor);
            this.mRightBackgroundColor = ta.getColor(R.styleable.JellyToggleButton_jtbRightBackgroundColor, this.mRightBackgroundColor);
            this.mLeftThumbColor = ta.getColor(R.styleable.JellyToggleButton_jtbLeftThumbColor, this.mLeftThumbColor);
            this.mRightThumbColor = ta.getColor(R.styleable.JellyToggleButton_jtbRightThumbColor, this.mRightThumbColor);
            this.mLeftTextColor = ta.getColor(R.styleable.JellyToggleButton_jtbLeftTextColor, this.mLeftTextColor);
            this.mRightTextColor = ta.getColor(R.styleable.JellyToggleButton_jtbRightTextColor, this.mRightTextColor);
            String leftTypefaceString = ta.getString(R.styleable.JellyToggleButton_jtbLeftTextTypeface);
            try {
                this.mLeftTextTypeface = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)leftTypefaceString);
            }
            catch (RuntimeException r) {
                this.mLeftTextTypeface = Typeface.DEFAULT;
            }
            this.mLeftTextPaint.setTypeface(this.mLeftTextTypeface);
            String rightTypefaceString = ta.getString(R.styleable.JellyToggleButton_jtbRightTextTypeface);
            try {
                this.mRightTextTypeface = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)rightTypefaceString);
            }
            catch (RuntimeException r) {
                this.mRightTextTypeface = Typeface.DEFAULT;
            }
            this.mRightTextPaint.setTypeface(this.mRightTextTypeface);
            this.mLeftTextSize = ta.getDimensionPixelSize(R.styleable.JellyToggleButton_jtbLeftTextSize, 15);
            this.mLeftTextPaint.setTextSize((float)this.mLeftTextSize);
            this.mRightTextSize = ta.getDimensionPixelSize(R.styleable.JellyToggleButton_jtbRightTextSize, 15);
            this.mRightTextPaint.setTextSize((float)this.mRightTextSize);
            this.mLeftText = ta.getString(R.styleable.JellyToggleButton_jtbLeftText);
            this.mRightText = ta.getString(R.styleable.JellyToggleButton_jtbRightText);
            this.mTextMarginLeft = ta.getDimension(R.styleable.JellyToggleButton_jtbTextMarginLeft, this.mTextMarginLeft);
            this.mTextMarginRight = ta.getDimension(R.styleable.JellyToggleButton_jtbTextMarginRight, this.mTextMarginRight);
            this.mTextMarginTop = ta.getDimension(R.styleable.JellyToggleButton_jtbTextMarginTop, this.mTextMarginTop);
            this.mTextMarginBottom = ta.getDimension(R.styleable.JellyToggleButton_jtbTextMarginBottom, this.mTextMarginBottom);
            this.mTextMarginCenter = ta.getDimension(R.styleable.JellyToggleButton_jtbTextMarginCenter, this.mTextMarginCenter);
            this.mThumbRadius = ta.getDimension(R.styleable.JellyToggleButton_jtbThumbRadius, this.mThumbRadius);
            this.mBackgroundMeasureRatio = ta.getFloat(R.styleable.JellyToggleButton_jtbBackgroundMeasureRatioValue, this.mBackgroundMeasureRatio);
            this.mBackgroundRadius = ta.getDimension(R.styleable.JellyToggleButton_jtbBackgroundRadius, 10.0f * density);
            this.mDuration = ta.getInteger(R.styleable.JellyToggleButton_jtbDuration, 1000);
            this.mTouchMoveRatioValue = ta.getFloat(R.styleable.JellyToggleButton_jtbTouchMoveRatioValue, 5.0f);
            this.mBezierControlValue = ta.getFloat(R.styleable.JellyToggleButton_jtbBezierControlValue, this.mBezierControlValue);
            this.mStretchDistanceRatioValue = ta.getFloat(R.styleable.JellyToggleButton_jtbStretchDistanceRatioValue, this.mStretchDistanceRatioValue);
            this.mBezierScaleRatioValue = ta.getFloat(R.styleable.JellyToggleButton_jtbBezierScaleRatioValue, 0.45f);
            this.mMoveToSameStateCallListener = ta.getBoolean(R.styleable.JellyToggleButton_jtbMoveToSameStateCallListener, false);
            this.mDraggable = ta.getBoolean(R.styleable.JellyToggleButton_jtbDraggable, true);
            int colorChangeTypeInteger = ta.getInteger(R.styleable.JellyToggleButton_jtbColorChangeType, -1);
            this.mColorChangeType = colorChangeTypeInteger != -1 ? ColorChangeType.values()[colorChangeTypeInteger] : DEFAULT_COLOR_CHANGE_TYPE;
            int jellyInteger = ta.getInteger(R.styleable.JellyToggleButton_jtbJelly, -1);
            this.mJelly = jellyInteger != -1 ? Jelly.values()[jellyInteger] : DEFAULT_JELLY;
            int easeTypeInteger = ta.getInteger(R.styleable.JellyToggleButton_jtbEaseType, -1);
            this.mEaseType = easeTypeInteger != -1 ? EaseType.values()[easeTypeInteger] : DEFAULT_EASE_TYPE;
            ta.recycle();
        }
        if (this.mLeftText == null) {
            this.mLeftText = DEFAULT_LEFT_TEXT;
        }
        if (this.mRightText == null) {
            this.mRightText = DEFAULT_RIGHT_TEXT;
        }
        this.mLeftTextPaint.setTextSize((float)this.mLeftTextSize);
        this.mRightTextPaint.setTextSize((float)this.mRightTextSize);
        this.setFocusable(true);
        this.setClickable(true);
        if (this.isChecked()) {
            this.setProcess(1.0f, false);
            this.mState = State.RIGHT;
        } else {
            this.setProcess(0.0f, false);
            this.mState = State.LEFT;
        }
    }

    private Layout makeLayout(CharSequence text, TextPaint textPaint) {
        return new StaticLayout(text, textPaint, (int)Math.ceil(Layout.getDesiredWidth((CharSequence)text, (TextPaint)textPaint)), Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mLeftTextLayout == null && this.mLeftText != null && this.mLeftTextPaint != null) {
            this.mLeftTextLayout = this.makeLayout(this.mLeftText, this.mLeftTextPaint);
        }
        if (this.mRightTextLayout == null && this.mRightText != null && this.mRightTextPaint != null) {
            this.mRightTextLayout = this.makeLayout(this.mRightText, this.mRightTextPaint);
        }
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
        this.setup();
    }

    private int measureWidth(int widthMeasureSpec) {
        int measuredWidth;
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int minWidth = (int)(this.mThumbRadius * 2.0f * this.mBackgroundMeasureRatio);
        float leftWidth = this.mLeftTextLayout != null ? (float)this.mLeftTextLayout.getWidth() : 0.0f;
        float rightWidth = this.mRightTextLayout != null ? (float)this.mRightTextLayout.getWidth() : 0.0f;
        float leftHeight = this.mLeftTextLayout != null ? (float)this.mLeftTextLayout.getHeight() : 0.0f;
        float rightHeight = this.mRightTextLayout != null ? (float)this.mRightTextLayout.getHeight() : 0.0f;
        this.mTextWidth = Math.max(leftWidth, rightWidth);
        this.mTextHeight = Math.max(leftHeight, rightHeight);
        float leftMaxThumbToText = Math.max(this.mTextMarginCenter, this.mTextMarginLeft);
        float rightMaxThumbToText = Math.max(this.mTextMarginCenter, this.mTextMarginRight);
        float centerMaxLength = Math.max(this.mTextMarginCenter, Math.max(leftMaxThumbToText, rightMaxThumbToText));
        minWidth = Math.max(minWidth, (int)(leftMaxThumbToText + this.mTextWidth + centerMaxLength + this.mTextWidth + rightMaxThumbToText));
        minWidth = Math.max(minWidth, minWidth + this.getPaddingLeft() + this.getPaddingRight());
        minWidth = Math.max(minWidth, this.getSuggestedMinimumWidth());
        if (widthMode == 0x40000000) {
            measuredWidth = Math.max(minWidth, widthSize);
        } else {
            measuredWidth = minWidth;
            if (widthMode == Integer.MIN_VALUE) {
                measuredWidth = Math.min(measuredWidth, widthSize);
            }
        }
        if (leftWidth != 0.0f || rightWidth != 0.0f) {
            this.mThumbMinRadius = Math.max(this.mTextWidth / 2.0f + this.mTextMarginLeft, this.mTextWidth / 2.0f + this.mTextMarginRight);
            this.mThumbMaxRadius = this.mTextWidth / 2.0f + Math.max(leftMaxThumbToText, rightMaxThumbToText);
            if (this.mThumbRadius < this.mThumbMinRadius) {
                this.mThumbRadius = this.mThumbMinRadius;
            }
            if (this.mThumbRadius > this.mThumbMaxRadius) {
                this.mThumbRadius = this.mThumbMaxRadius;
            }
            this.mThumbRadius = Math.max(this.mThumbRadius, 15.0f * this.getResources().getDisplayMetrics().density);
        }
        return measuredWidth;
    }

    private int measureHeight(int heightMeasureSpec) {
        int measuredHeight;
        float offHeight;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        float onHeight = this.mLeftTextLayout != null ? (float)this.mLeftTextLayout.getHeight() : 0.0f;
        float f = offHeight = this.mRightTextLayout != null ? (float)this.mRightTextLayout.getHeight() : 0.0f;
        if (onHeight != 0.0f || offHeight != 0.0f) {
            this.mTextHeight = Math.max(onHeight, offHeight) + this.mTextMarginTop + this.mTextMarginBottom;
        }
        int minHeight = (int)(this.mThumbRadius * 2.0f) + this.getPaddingTop() + this.getPaddingBottom();
        if (heightMode == 0x40000000) {
            measuredHeight = Math.max(minHeight, heightSize);
        } else {
            measuredHeight = minHeight;
            if (heightMode == Integer.MIN_VALUE) {
                measuredHeight = Math.min(measuredHeight, heightSize);
            }
        }
        return measuredHeight;
    }

    private void setup() {
        float backgroundLeft = this.mThumbRadius + (float)this.getPaddingLeft() - (this.mTextWidth / 2.0f + this.mTextMarginLeft);
        float backgroundRight = (float)(this.getMeasuredWidth() - this.getPaddingRight()) - (this.mThumbRadius - (this.mTextMarginRight + this.mTextWidth / 2.0f));
        if (this.mTextWidth == 0.0f) {
            backgroundLeft = (float)this.getPaddingLeft() + this.mThumbRadius / 2.0f;
            backgroundRight = (float)(this.getMeasuredWidth() - this.getPaddingRight()) - this.mThumbRadius / 2.0f;
        }
        this.mBackgroundRectF.set(backgroundLeft, (float)(this.getMeasuredHeight() / 2) - this.mBackgroundRadius, backgroundRight, (float)(this.getMeasuredHeight() / 2) + this.mBackgroundRadius);
        if (this.mLeftTextLayout != null) {
            float marginOnX = this.mBackgroundRectF.left + this.mTextMarginLeft + (this.mTextWidth - (float)this.mLeftTextLayout.getWidth()) / 2.0f;
            float marginOnY = this.mBackgroundRectF.top + (this.mBackgroundRectF.height() - (float)this.mLeftTextLayout.getHeight()) / 2.0f;
            this.mOnTextRectF.set(marginOnX, marginOnY, marginOnX + (float)this.mLeftTextLayout.getWidth(), marginOnY + (float)this.mLeftTextLayout.getHeight());
        }
        if (this.mRightTextLayout != null) {
            float marginOffX = this.mBackgroundRectF.right - this.mTextMarginRight - this.mTextWidth + (this.mTextWidth - (float)this.mRightTextLayout.getWidth()) / 2.0f;
            float marginOffY = this.mBackgroundRectF.top + (this.mBackgroundRectF.height() - (float)this.mRightTextLayout.getHeight()) / 2.0f;
            this.mOffTextRectF.set(marginOffX, marginOffY, marginOffX + (float)this.mRightTextLayout.getWidth(), marginOffY + (float)this.mRightTextLayout.getHeight());
        }
        float thumbTop = this.getPaddingTop();
        this.mThumbLeft = (this.mOnTextRectF.left + this.mOnTextRectF.right) / 2.0f - this.mThumbRadius;
        if (this.mLeftTextLayout == null || this.mOnTextRectF.width() == 0.0f) {
            this.mThumbLeft = this.getPaddingLeft();
        }
        this.mThumbRight = (this.mOffTextRectF.left + this.mOffTextRectF.right) / 2.0f + this.mThumbRadius;
        if (this.mRightTextLayout == null || this.mOffTextRectF.width() == 0.0f) {
            this.mThumbRight = this.getMeasuredWidth() - this.getPaddingRight();
        }
        this.mThumbP1.setY(thumbTop + 2.0f * this.mThumbRadius);
        this.mThumbP2.setX(this.mThumbLeft + 2.0f * this.mThumbRadius);
        this.mThumbP3.setY(thumbTop);
        this.mThumbP4.setX(this.mThumbLeft);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mLeftBackgroundColor == this.mRightBackgroundColor) {
            this.mPaint.setColor(this.mLeftBackgroundColor);
        } else {
            this.mPaint.setColor(Utils.calculateMidColor(this.mLeftBackgroundColor, this.mRightBackgroundColor, this.mProcess, this.mColorChangeType));
        }
        canvas.drawRoundRect(this.mBackgroundRectF, this.mBackgroundRadius, this.mBackgroundRadius, this.mPaint);
        this.setStartProcessPoints();
        if (this.mCustomJelly != null) {
            this.mCustomJelly.changeShape(this.mThumbP1, this.mThumbP2, this.mThumbP3, this.mThumbP4, this.mStretchDistanceRatioValue * this.mThumbRadius, this.mBezierControlValue, this.mBezierScaleRatioValue, this.mThumbRadius, this.mProcess, this.mState);
            this.mCustomJelly.changeOffset(this.mThumbP1, this.mThumbP2, this.mThumbP3, this.mThumbP4, this.getNoExtractTotalLength(), this.mCustomJelly.extractLength(this.mStretchDistanceRatioValue * this.mThumbRadius, this.mBezierControlValue, this.mBezierScaleRatioValue, this.mThumbRadius), this.mProcess, this.mState, this.mEaseType);
        } else if (Jelly.RANDOM.equals((Object)this.mJelly) && this.mRandomJelly != null) {
            this.mRandomJelly.changeShape(this.mThumbP1, this.mThumbP2, this.mThumbP3, this.mThumbP4, this.mStretchDistanceRatioValue * this.mThumbRadius, this.mBezierControlValue, this.mBezierScaleRatioValue, this.mThumbRadius, this.mProcess, this.mState);
            this.mRandomJelly.changeOffset(this.mThumbP1, this.mThumbP2, this.mThumbP3, this.mThumbP4, this.getNoExtractTotalLength(), this.mRandomJelly.extractLength(this.mStretchDistanceRatioValue * this.mThumbRadius, this.mBezierControlValue, this.mBezierScaleRatioValue, this.mThumbRadius), this.mProcess, this.mState, this.mEaseType);
        } else {
            this.mJelly.changeShape(this.mThumbP1, this.mThumbP2, this.mThumbP3, this.mThumbP4, this.mStretchDistanceRatioValue * this.mThumbRadius, this.mBezierControlValue, this.mBezierScaleRatioValue, this.mThumbRadius, this.mProcess, this.mState);
            this.mJelly.changeOffset(this.mThumbP1, this.mThumbP2, this.mThumbP3, this.mThumbP4, this.getNoExtractTotalLength(), this.mJelly.extractLength(this.mStretchDistanceRatioValue * this.mThumbRadius, this.mBezierControlValue, this.mBezierScaleRatioValue, this.mThumbRadius), this.mProcess, this.mState, this.mEaseType);
        }
        this.mThumbPath.reset();
        this.mThumbPath.moveTo(this.mThumbP1.x, this.mThumbP1.y);
        this.mThumbPath.cubicTo(this.mThumbP1.right.x, this.mThumbP1.right.y, this.mThumbP2.bottom.x, this.mThumbP2.bottom.y, this.mThumbP2.x, this.mThumbP2.y);
        this.mThumbPath.cubicTo(this.mThumbP2.top.x, this.mThumbP2.top.y, this.mThumbP3.right.x, this.mThumbP3.right.y, this.mThumbP3.x, this.mThumbP3.y);
        this.mThumbPath.cubicTo(this.mThumbP3.left.x, this.mThumbP3.left.y, this.mThumbP4.top.x, this.mThumbP4.top.y, this.mThumbP4.x, this.mThumbP4.y);
        this.mThumbPath.cubicTo(this.mThumbP4.bottom.x, this.mThumbP4.bottom.y, this.mThumbP1.left.x, this.mThumbP1.left.y, this.mThumbP1.x, this.mThumbP1.y);
        if (this.mLeftThumbColor == this.mRightThumbColor) {
            this.mPaint.setColor(this.mLeftThumbColor);
        } else {
            this.mPaint.setColor(Utils.calculateMidColor(this.mLeftThumbColor, this.mRightThumbColor, this.mProcess, this.mColorChangeType));
        }
        canvas.drawPath(this.mThumbPath, this.mPaint);
        if (this.mLeftTextLayout != null && this.mOnTextRectF != null) {
            this.mLeftTextLayout.getPaint().setColor(this.mLeftTextColor);
            canvas.save();
            canvas.translate(this.mOnTextRectF.left, this.mOnTextRectF.top);
            this.mLeftTextLayout.draw(canvas);
            canvas.restore();
        }
        if (this.mRightTextLayout != null && this.mOffTextRectF != null) {
            this.mRightTextLayout.getPaint().setColor(this.mRightTextColor);
            canvas.save();
            canvas.translate(this.mOffTextRectF.left, this.mOffTextRectF.top);
            this.mRightTextLayout.draw(canvas);
            canvas.restore();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled() || !this.isClickable()) {
            return false;
        }
        int action = event.getAction();
        float deltaX = event.getX() - this.mStartX;
        float deltaY = event.getY() - this.mStartY;
        switch (action) {
            case 0: {
                this.catchView();
                this.mStartX = event.getX();
                this.mStartY = event.getY();
                this.mLastX = this.mStartX;
                this.setPressed(true);
                break;
            }
            case 2: {
                if (!this.mDraggable) {
                    return true;
                }
                float x = event.getX();
                this.setProcess(this.getProcess() + (x - this.mLastX) / (this.getNoExtractTotalLength() * this.mTouchMoveRatioValue), true);
                this.mLastX = x;
                break;
            }
            case 1: 
            case 3: {
                this.setPressed(false);
                boolean nextStatus = this.getStatusBasedOnPos();
                float time = event.getEventTime() - event.getDownTime();
                if (deltaX < (float)this.mTouchSlop && deltaY < (float)this.mTouchSlop && time < (float)this.mClickTimeout) {
                    this.performClick();
                    break;
                }
                if (nextStatus != this.isChecked()) {
                    this.playSoundEffect(0);
                    this.animateToState(nextStatus, true, true);
                    break;
                }
                this.animateToState(nextStatus, this.mMoveToSameStateCallListener, true);
                break;
            }
        }
        return true;
    }

    private void setStartProcessPoints() {
        float thumbTop = this.getPaddingTop();
        float thumbLeft = this.getPaddingLeft();
        this.mThumbP1.setY(thumbTop + 2.0f * this.mThumbRadius);
        this.mThumbP1.x = thumbLeft + this.mThumbRadius;
        this.mThumbP1.left.x = this.mThumbP1.x - this.mThumbRadius * this.mBezierControlValue;
        this.mThumbP1.right.x = this.mThumbP1.x + this.mThumbRadius * this.mBezierControlValue;
        this.mThumbP2.setX(thumbLeft + 2.0f * this.mThumbRadius);
        this.mThumbP2.y = thumbTop + this.mThumbRadius;
        this.mThumbP2.top.y = this.mThumbP2.y - this.mThumbRadius * this.mBezierControlValue;
        this.mThumbP2.bottom.y = this.mThumbP2.y + this.mThumbRadius * this.mBezierControlValue;
        this.mThumbP3.setY(thumbTop);
        this.mThumbP3.x = thumbLeft + this.mThumbRadius;
        this.mThumbP3.left.x = this.mThumbP3.x - this.mThumbRadius * this.mBezierControlValue;
        this.mThumbP3.right.x = this.mThumbP3.x + this.mThumbRadius * this.mBezierControlValue;
        this.mThumbP4.setX(thumbLeft + 0.0f);
        this.mThumbP4.y = thumbTop + this.mThumbRadius;
        this.mThumbP4.top.y = this.mThumbP4.y - this.mThumbRadius * this.mBezierControlValue;
        this.mThumbP4.bottom.y = this.mThumbP4.y + this.mThumbRadius * this.mBezierControlValue;
    }

    private float getNoExtractTotalLength() {
        if (this.mCustomJelly != null) {
            return this.mThumbRight - this.mThumbLeft - 2.0f * this.mThumbRadius - this.mCustomJelly.extractLength(this.mStretchDistanceRatioValue * this.mThumbRadius, this.mBezierControlValue, this.mBezierScaleRatioValue, this.mThumbRadius);
        }
        if (Jelly.RANDOM.equals((Object)this.mJelly) && this.mRandomJelly != null) {
            return this.mThumbRight - this.mThumbLeft - 2.0f * this.mThumbRadius - this.mRandomJelly.extractLength(this.mStretchDistanceRatioValue * this.mThumbRadius, this.mBezierControlValue, this.mBezierScaleRatioValue, this.mThumbRadius);
        }
        return this.mThumbRight - this.mThumbLeft - 2.0f * this.mThumbRadius - this.mJelly.extractLength(this.mStretchDistanceRatioValue * this.mThumbRadius, this.mBezierControlValue, this.mBezierScaleRatioValue, this.mThumbRadius);
    }

    private boolean getStatusBasedOnPos() {
        return this.getProcess() > 0.5f;
    }

    private final float getProcess() {
        return this.mProcess;
    }

    private void setProcess(float process, boolean callListener) {
        float tp = process;
        if (tp >= 1.0f) {
            tp = 1.0f;
            this.mState = State.RIGHT;
        } else if (tp <= 0.0f) {
            tp = 0.0f;
            this.mState = State.LEFT;
        } else if (this.mState.equals((Object)State.RIGHT)) {
            this.mState = State.RIGHT_TO_LEFT;
        } else if (this.mState.equals((Object)State.LEFT)) {
            this.mState = State.LEFT_TO_RIGHT;
        }
        this.mProcess = tp;
        if (this.mState.equals((Object)State.LEFT)) {
            super.setChecked(false);
            if (this.mJelly.equals((Object)Jelly.RANDOM)) {
                this.randomChangeJelly();
            }
        }
        if (this.mState.equals((Object)State.RIGHT)) {
            super.setChecked(true);
            if (this.mJelly.equals((Object)Jelly.RANDOM)) {
                this.randomChangeJelly();
            }
        }
        if (callListener && this.mOnStateChangeListener != null) {
            if (this.mState.equals((Object)State.LEFT) || this.mState.equals((Object)State.RIGHT)) {
                if (!this.mState.equals((Object)this.lastState)) {
                    this.mOnStateChangeListener.onStateChange(this.mProcess, this.mState, this);
                }
            } else {
                this.mOnStateChangeListener.onStateChange(this.mProcess, this.mState, this);
            }
        }
        this.lastState = this.mState;
        this.invalidate();
    }

    private void randomChangeJelly() {
        int r = (int)(Math.random() * 17.0);
        while (r == this.mLastRandomValue) {
            r = (int)(Math.random() * 17.0);
        }
        this.mLastRandomValue = r;
        this.mRandomJelly = Jelly.values()[r];
    }

    public boolean performClick() {
        return super.performClick();
    }

    private void animateToState(boolean checked, boolean callListener, boolean resetToTarget) {
        if (this.mProcessAnimator == null) {
            return;
        }
        if (this.mProcessAnimator.isRunning()) {
            return;
        }
        if (checked) {
            this.setAnimator(1.0f, callListener);
        } else {
            this.setAnimator(0.0f, callListener);
        }
        int duration = this.mDuration;
        if (resetToTarget) {
            duration = checked ? (int)((float)duration * (1.0f - this.mProcess)) : (int)((float)duration * (this.mProcess - 0.0f));
        }
        this.mProcessAnimator.setDuration((long)duration);
        this.mProcessAnimator.start();
    }

    private void catchView() {
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(true);
        }
    }

    public boolean isChecked() {
        return super.isChecked();
    }

    public void setChecked(boolean checked) {
        if (this.mStopRestoreChecked) {
            return;
        }
        this.setChecked(checked, true);
    }

    public void setChecked(boolean checked, boolean callListener) {
        float f = this.mProcess = checked ? 0.0f : 1.0f;
        if (callListener) {
            this.lastState = checked ? State.LEFT : State.RIGHT;
        }
        this.animateToState(checked, callListener, false);
        super.setChecked(checked);
    }

    public void setCheckedImmediately(boolean checked) {
        this.setCheckedImmediately(checked, true);
    }

    public void setCheckedImmediately(boolean checked, boolean callListener) {
        super.setChecked(checked);
        if (this.mProcessAnimator != null && this.mProcessAnimator.isRunning()) {
            this.mProcessAnimator.cancel();
        }
        if (callListener) {
            this.lastState = null;
        }
        this.setProcess(checked ? 1.0f : 0.0f, callListener);
    }

    private void setAnimator(float target, final boolean callListener) {
        this.mProcessAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mProcess, target});
        this.mProcessAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                JellyToggleButton.this.setProcess(((Float)animation.getAnimatedValue()).floatValue(), callListener);
            }
        });
        this.mProcessAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (JellyToggleButton.this.mProcess == 0.0f) {
                    JellyToggleButton.super.setChecked(false);
                }
                if (JellyToggleButton.this.mProcess == 1.0f) {
                    JellyToggleButton.super.setChecked(true);
                }
                super.onAnimationEnd(animation);
            }
        });
        this.mProcessAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
    }

    public void toggle() {
        this.toggle(true);
    }

    public void toggle(boolean callListener) {
        this.setChecked(!this.isChecked(), callListener);
    }

    public void toggleImmediately() {
        this.toggleImmediately(true);
    }

    public void toggleImmediately(boolean callListener) {
        this.setCheckedImmediately(!this.isChecked(), callListener);
    }

    public int getLeftBackgroundColor() {
        return this.mLeftBackgroundColor;
    }

    public void setLeftBackgroundColor(int color) {
        this.mLeftBackgroundColor = color;
        this.invalidate();
    }

    public void setLeftBackgroundColor(String color) {
        this.setLeftBackgroundColor(Color.parseColor((String)color));
    }

    public void setLeftBackgroundColorRes(int res) {
        this.setLeftBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)res));
    }

    public int getRightBackgroundColor() {
        return this.mRightBackgroundColor;
    }

    public void setRightBackgroundColor(int color) {
        this.mRightBackgroundColor = color;
        this.invalidate();
    }

    public void setRightBackgroundColor(String color) {
        this.setRightBackgroundColor(Color.parseColor((String)color));
    }

    public void setRightBackgroundColorRes(int res) {
        this.setRightBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)res));
    }

    public void setBackgroundColor(int color) {
        this.setLeftBackgroundColor(color);
        this.setRightBackgroundColor(color);
    }

    public void setBackgroundColor(String color) {
        this.setBackgroundColor(Color.parseColor((String)color));
    }

    public void setBackgroundColorRes(int res) {
        this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)res));
    }

    public int getLeftThumbColor() {
        return this.mLeftThumbColor;
    }

    public void setLeftThumbColor(int color) {
        this.mLeftThumbColor = color;
        this.invalidate();
    }

    public void setLeftThumbColor(String color) {
        this.setLeftThumbColor(Color.parseColor((String)color));
    }

    public void setLeftThumbColorRes(int res) {
        this.setLeftThumbColor(ContextCompat.getColor((Context)this.getContext(), (int)res));
    }

    public int getRightThumbColor() {
        return this.mRightThumbColor;
    }

    public void setRightThumbColor(int color) {
        this.mRightThumbColor = color;
        this.invalidate();
    }

    public void setRightThumbColor(String color) {
        this.setRightThumbColor(Color.parseColor((String)color));
    }

    public void setRightThumbColorRes(int res) {
        this.setRightThumbColor(ContextCompat.getColor((Context)this.getContext(), (int)res));
    }

    public void setThumbColor(int color) {
        this.setLeftThumbColor(color);
        this.setRightThumbColor(color);
    }

    public void setThumbColor(String color) {
        this.setThumbColor(Color.parseColor((String)color));
    }

    public void setThumbColorRes(int res) {
        this.setThumbColor(ContextCompat.getColor((Context)this.getContext(), (int)res));
    }

    public int getLeftTextColor() {
        return this.mLeftTextColor;
    }

    public void setLeftTextColor(int color) {
        this.mLeftTextColor = color;
        this.invalidate();
    }

    public void setLeftTextColor(String color) {
        this.setLeftTextColor(Color.parseColor((String)color));
    }

    public void setLeftTextColorRes(int res) {
        this.setLeftTextColor(ContextCompat.getColor((Context)this.getContext(), (int)res));
    }

    public int getRightTextColor() {
        return this.mRightTextColor;
    }

    public void setRightTextColor(int color) {
        this.mRightTextColor = color;
        this.invalidate();
    }

    public void setRightTextColor(String color) {
        this.setRightTextColor(Color.parseColor((String)color));
    }

    public void setRightTextColorRes(int res) {
        this.setRightTextColor(ContextCompat.getColor((Context)this.getContext(), (int)res));
    }

    public void setTextColor(int color) {
        this.setLeftTextColor(color);
        this.setRightTextColor(color);
    }

    public void setTextColor(String color) {
        this.setTextColor(Color.parseColor((String)color));
    }

    public void setTextColorRes(int res) {
        this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)res));
    }

    public Typeface getLeftTextTypeface() {
        return this.mLeftTextTypeface;
    }

    public void setLeftTextTypeface(Typeface typeface) {
        this.mLeftTextTypeface = typeface;
        this.mLeftTextPaint.setTypeface(typeface);
        this.mLeftTextLayout = null;
        this.requestLayout();
    }

    public void setLeftTextTypeface(String typefaceString) {
        try {
            this.mLeftTextTypeface = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)typefaceString);
        }
        catch (RuntimeException r) {
            this.mLeftTextTypeface = Typeface.DEFAULT;
        }
        this.mLeftTextPaint.setTypeface(this.mLeftTextTypeface);
        this.mLeftTextLayout = null;
        this.requestLayout();
    }

    public Typeface getRightTextTypeface() {
        return this.mRightTextTypeface;
    }

    public void setRightTextTypeface(Typeface typeface) {
        this.mRightTextTypeface = typeface;
        this.mRightTextPaint.setTypeface(typeface);
        this.mRightTextLayout = null;
        this.requestLayout();
    }

    public void setRightTextTypeface(String typefaceString) {
        try {
            this.mRightTextTypeface = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)typefaceString);
        }
        catch (RuntimeException r) {
            this.mRightTextTypeface = Typeface.DEFAULT;
        }
        this.mRightTextPaint.setTypeface(this.mRightTextTypeface);
        this.mRightTextLayout = null;
        this.requestLayout();
    }

    public void setTextTypeface(Typeface typeface) {
        this.setLeftTextTypeface(typeface);
        this.setRightTextTypeface(typeface);
    }

    public void setTextTypeface(String typefaceString) {
        this.setLeftTextTypeface(typefaceString);
        this.setRightTextTypeface(typefaceString);
    }

    public int getLeftTextSize() {
        return this.mLeftTextSize;
    }

    public void setLeftTextSize(int textSize) {
        this.mLeftTextSize = textSize;
        if (this.mLeftTextPaint != null) {
            this.mLeftTextPaint.setTextSize((float)this.mLeftTextSize);
        }
        this.mLeftTextLayout = null;
        this.mRightTextLayout = null;
        this.requestLayout();
    }

    public void setLeftTextSizeRes(int res) {
        this.setLeftTextSize(this.getContext().getResources().getDimensionPixelSize(res));
    }

    public int getRightTextSize() {
        return this.mRightTextSize;
    }

    public void setRightTextSize(int textSize) {
        this.mRightTextSize = textSize;
        if (this.mRightTextPaint != null) {
            this.mRightTextPaint.setTextSize((float)this.mRightTextSize);
        }
        this.mLeftTextLayout = null;
        this.mRightTextLayout = null;
        this.requestLayout();
    }

    public void setRightTextSizeRes(int res) {
        this.setRightTextSize(this.getContext().getResources().getDimensionPixelSize(res));
    }

    public void setTextSize(int textSize) {
        this.setLeftTextSize(textSize);
        this.setRightTextSize(textSize);
    }

    public void setTextSizeRes(int res) {
        this.setTextSize(this.getContext().getResources().getDimensionPixelSize(res));
    }

    public String getLeftText() {
        return this.mLeftText;
    }

    public void setLeftText(String text) {
        this.mLeftText = text;
        this.mLeftTextLayout = null;
        this.requestLayout();
    }

    public void setLeftTextRes(int res) {
        this.setLeftText(this.getContext().getResources().getString(res));
    }

    public String getRightText() {
        return this.mRightText;
    }

    public void setRightText(String text) {
        this.mRightText = text;
        this.mRightTextLayout = null;
        this.requestLayout();
    }

    public void setRightTextRes(int res) {
        this.setRightText(this.getContext().getResources().getString(res));
    }

    public void setText(String leftText, String rightText) {
        this.setLeftText(leftText);
        this.setRightText(rightText);
    }

    public void setTextRes(int leftRes, int rightRes) {
        this.setLeftText(this.getContext().getResources().getString(leftRes));
        this.setRightText(this.getContext().getResources().getString(rightRes));
    }

    public float getTextMarginLeft() {
        return this.mTextMarginLeft;
    }

    public void setTextMarginLeft(float margin) {
        this.mTextMarginLeft = margin;
        this.requestLayout();
    }

    public void setTextMarginLeftRes(int res) {
        this.setTextMarginLeft(this.getContext().getResources().getDimension(res));
    }

    public float getTextMarginRight() {
        return this.mTextMarginRight;
    }

    public void setTextMarginRight(float margin) {
        this.mTextMarginRight = margin;
        this.requestLayout();
    }

    public void setTextMarginRightRes(int res) {
        this.setTextMarginRight(this.getContext().getResources().getDimension(res));
    }

    public float getTextMarginTop() {
        return this.mTextMarginTop;
    }

    public void setTextMarginTop(float margin) {
        this.mTextMarginTop = Math.min(margin, 5.0f * this.getResources().getDisplayMetrics().density);
        this.requestLayout();
    }

    public void setTextMarginTopRes(int res) {
        this.setTextMarginTop(this.getContext().getResources().getDimension(res));
    }

    public float getTextMarginBottom() {
        return this.mTextMarginBottom;
    }

    public void setTextMarginBottom(float margin) {
        this.mTextMarginBottom = Math.min(margin, 5.0f * this.getResources().getDisplayMetrics().density);
        this.requestLayout();
    }

    public void setTextMarginBottomRes(int res) {
        this.setTextMarginBottom(this.getContext().getResources().getDimension(res));
    }

    public float getTextMarginCenter() {
        return this.mTextMarginCenter;
    }

    public void setTextMarginCenter(float margin) {
        this.mTextMarginCenter = Math.max(margin, 3.0f * this.getResources().getDisplayMetrics().density);
        this.requestLayout();
    }

    public void setTextMarginCenterRes(int res) {
        this.setTextMarginCenter(this.getContext().getResources().getDimension(res));
    }

    public float getThumbRadius() {
        return this.mThumbRadius;
    }

    public void setThumbRadius(float radius) {
        this.mThumbRadius = Math.max(radius, 15.0f * this.getResources().getDisplayMetrics().density);
        this.requestLayout();
    }

    public void setThumbRadiusRes(int res) {
        this.setThumbRadius(this.getContext().getResources().getDimension(res));
    }

    public float getBackgroundMeasureRatio() {
        return this.mBackgroundMeasureRatio;
    }

    public void setBackgroundMeasureRatio(float ratio) {
        this.mBackgroundMeasureRatio = ratio;
        this.mBackgroundMeasureRatio = Math.max(ratio, 1.8f);
        this.requestLayout();
    }

    public void setBackgroundMeasureRatioRes(int res) {
        TypedValue outValue = new TypedValue();
        this.getResources().getValue(res, outValue, true);
        this.setBackgroundMeasureRatio(outValue.getFloat());
    }

    public float getBackgroundRadius() {
        return this.mBackgroundRadius;
    }

    public boolean isDraggable() {
        return this.mDraggable;
    }

    public void setDraggable(boolean draggable) {
        this.mDraggable = draggable;
    }

    public void setBackgroundRadius(float radius) {
        this.mBackgroundRadius = radius;
        this.mBackgroundRadius = Math.max(radius, 10.0f * this.getResources().getDisplayMetrics().density);
        this.requestLayout();
    }

    public void setBackgroundRadiusRes(int res) {
        TypedValue outValue = new TypedValue();
        this.getResources().getValue(res, outValue, true);
        this.setBackgroundRadius(outValue.getFloat());
    }

    public int getDuration() {
        return this.mDuration;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
        this.mProcessAnimator.setDuration((long)duration);
    }

    public void setDurationRes(int res) {
        this.setDuration(this.getResources().getInteger(res));
    }

    public float getTouchMoveRatioValue() {
        return this.mTouchMoveRatioValue;
    }

    public void setTouchMoveRatioValue(float ratio) {
        this.mTouchMoveRatioValue = ratio;
    }

    public void setTouchMoveRatioValueRes(int res) {
        TypedValue outValue = new TypedValue();
        this.getResources().getValue(res, outValue, true);
        this.setTouchMoveRatioValue(outValue.getFloat());
    }

    public float getBezierControlValue() {
        return this.mBezierControlValue;
    }

    public void setBezierControlValue(float value) {
        this.mBezierControlValue = value;
        this.requestLayout();
    }

    public void setBezierControlValueRes(int res) {
        TypedValue outValue = new TypedValue();
        this.getResources().getValue(res, outValue, true);
        this.setBezierControlValue(outValue.getFloat());
    }

    public float getStretchDistanceRatioValue() {
        return this.mStretchDistanceRatioValue;
    }

    public void setStretchDistanceRatioValue(float value) {
        this.mStretchDistanceRatioValue = value;
    }

    public float getBezierScaleRatioValue() {
        return this.mBezierScaleRatioValue;
    }

    public void setBezierScaleRatioValue(float value) {
        this.mBezierScaleRatioValue = value;
    }

    public void setBezierScaleRatioValueRes(int res) {
        TypedValue outValue = new TypedValue();
        this.getResources().getValue(res, outValue, true);
        this.setBezierScaleRatioValue(outValue.getFloat());
    }

    public ColorChangeType getColorChangeType() {
        return this.mColorChangeType;
    }

    public void setColorChangeType(ColorChangeType colorChangeType) {
        this.mColorChangeType = colorChangeType;
    }

    public Jelly getJelly() {
        return this.mJelly;
    }

    public void setJelly(Jelly jelly) {
        this.mJelly = jelly;
    }

    public EaseType getEaseType() {
        return this.mEaseType;
    }

    public void setEaseType(EaseType easeType) {
        this.mEaseType = easeType;
    }

    public OnStateChangeListener getOnStateChangeListener() {
        return this.mOnStateChangeListener;
    }

    public void setOnStateChangeListener(OnStateChangeListener onStateChangeListener) {
        this.mOnStateChangeListener = onStateChangeListener;
    }

    public JellyStyle getCustomJelly() {
        return this.mCustomJelly;
    }

    public void setCustomJelly(JellyStyle customJelly) {
        this.mCustomJelly = customJelly;
    }

    public void removeCustomJelly() {
        this.mCustomJelly = null;
    }

    public boolean getMoveToSameStateCallListener() {
        return this.mMoveToSameStateCallListener;
    }

    public void setMoveToSameStateCallListener(boolean callListener) {
        this.mMoveToSameStateCallListener = callListener;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.leftText = this.mLeftText;
        ss.rightText = this.mRightText;
        ss.isChecked = this.isChecked();
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        this.setText(ss.leftText, ss.rightText);
        this.setCheckedImmediately(ss.isChecked, false);
        this.mStopRestoreChecked = true;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mStopRestoreChecked = false;
    }

    static class SavedState
    extends View.BaseSavedState {
        String leftText;
        String rightText;
        boolean isChecked = false;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.leftText = in.readString();
            this.rightText = in.readString();
            this.isChecked = in.readByte() != 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.leftText);
            out.writeString(this.rightText);
            out.writeByte((byte)(this.isChecked ? 1 : 0));
        }
    }

    public static interface OnStateChangeListener {
        public void onStateChange(float var1, State var2, JellyToggleButton var3);
    }
}

