/*
 * Decompiled with CFR 0.152.
 */
package com.nightonke.jellytogglebutton.JellyTypes;

import com.nightonke.jellytogglebutton.EaseTypes.EaseType;
import com.nightonke.jellytogglebutton.JellyTypes.JellyStyle;
import com.nightonke.jellytogglebutton.PointWithHorizontalPoints;
import com.nightonke.jellytogglebutton.PointWithVerticalPoints;
import com.nightonke.jellytogglebutton.State;
import com.nightonke.jellytogglebutton.Utils;

public class LazyStiffFatty
extends JellyStyle {
    private static final float T0 = 0.0f;
    private static final float T1 = 0.251f;
    private static final float T2 = 0.502f;
    private static final float T3 = 0.75f;
    private static final float T4 = 1.0f;

    @Override
    public void changeShape(PointWithHorizontalPoints p1, PointWithVerticalPoints p2, PointWithHorizontalPoints p3, PointWithVerticalPoints p4, float stretchDistance, float bezierControlValue, float bezierScaleRatioValue, float thumbRadius, float process, State state) {
        if (state.equals((Object)State.LEFT_TO_RIGHT)) {
            if (0.0f <= process && process <= 0.251f) {
                p2.moveX(stretchDistance * (process - 0.0f) / 0.251f);
            } else if (0.251f < process && process <= 0.502f) {
                this.changeShape(p1, p2, p3, p4, stretchDistance, bezierControlValue, bezierScaleRatioValue, thumbRadius, 0.251f, state);
                p1.moveX(stretchDistance / 2.0f * (process - 0.251f) / 0.251f);
                p3.moveX(stretchDistance / 2.0f * (process - 0.251f) / 0.251f);
                p2.scaleY(bezierScaleRatioValue * bezierControlValue * thumbRadius * (process - 0.251f) / 0.251f);
                p4.scaleY(bezierScaleRatioValue * bezierControlValue * thumbRadius * (process - 0.251f) / 0.251f);
            } else if (0.502f < process && process <= 0.75f) {
                this.changeShape(p1, p2, p3, p4, stretchDistance, bezierControlValue, bezierScaleRatioValue, thumbRadius, 0.502f, state);
                p1.moveX(stretchDistance / 2.0f * (process - 0.502f) / 0.24800003f);
                p3.moveX(stretchDistance / 2.0f * (process - 0.502f) / 0.24800003f);
                p2.scaleY(-bezierScaleRatioValue * bezierControlValue * thumbRadius * (process - 0.502f) / 0.24800003f);
                p4.scaleY(-bezierScaleRatioValue * bezierControlValue * thumbRadius * (process - 0.502f) / 0.24800003f);
                p4.moveX(stretchDistance * 1.0f / 4.0f * (process - 0.502f) / 0.24800003f);
            } else if (0.75f < process && process <= 1.0f) {
                this.changeShape(p1, p2, p3, p4, stretchDistance, bezierControlValue, bezierScaleRatioValue, thumbRadius, 0.75f, state);
                p4.moveX(stretchDistance * 3.0f / 4.0f * (process - 0.75f) / 0.25f);
            }
        } else if (state.equals((Object)State.RIGHT_TO_LEFT)) {
            float rProcess = 1.0f - process;
            if (0.0f <= rProcess && rProcess <= 0.251f) {
                p4.moveX(-stretchDistance * (rProcess - 0.0f) / 0.251f);
            } else if (0.251f < rProcess && rProcess <= 0.502f) {
                this.changeShape(p1, p2, p3, p4, stretchDistance, bezierControlValue, bezierScaleRatioValue, thumbRadius, 0.749f, state);
                p1.moveX(-stretchDistance / 2.0f * (rProcess - 0.251f) / 0.251f);
                p3.moveX(-stretchDistance / 2.0f * (rProcess - 0.251f) / 0.251f);
                p2.scaleY(bezierScaleRatioValue * bezierControlValue * thumbRadius * (rProcess - 0.251f) / 0.251f);
                p4.scaleY(bezierScaleRatioValue * bezierControlValue * thumbRadius * (rProcess - 0.251f) / 0.251f);
            } else if (0.502f < rProcess && rProcess <= 0.75f) {
                this.changeShape(p1, p2, p3, p4, stretchDistance, bezierControlValue, bezierScaleRatioValue, thumbRadius, 0.49800003f, state);
                p1.moveX(-stretchDistance / 2.0f * (rProcess - 0.502f) / 0.24800003f);
                p3.moveX(-stretchDistance / 2.0f * (rProcess - 0.502f) / 0.24800003f);
                p2.scaleY(-bezierScaleRatioValue * bezierControlValue * thumbRadius * (rProcess - 0.502f) / 0.24800003f);
                p4.scaleY(-bezierScaleRatioValue * bezierControlValue * thumbRadius * (rProcess - 0.502f) / 0.24800003f);
                p2.moveX(-stretchDistance / 2.0f * (rProcess - 0.502f) / 0.24800003f);
            } else if (0.75f < rProcess && rProcess <= 1.0f) {
                this.changeShape(p1, p2, p3, p4, stretchDistance, bezierControlValue, bezierScaleRatioValue, thumbRadius, 0.25f, state);
                p2.moveX(-stretchDistance / 2.0f * (rProcess - 0.75f) / 0.25f);
            }
        } else if (!state.equals((Object)State.LEFT) && state.equals((Object)State.RIGHT)) {
            p1.moveX(this.extractLength(stretchDistance, bezierControlValue, bezierScaleRatioValue, thumbRadius));
            p2.moveX(this.extractLength(stretchDistance, bezierControlValue, bezierScaleRatioValue, thumbRadius));
            p3.moveX(this.extractLength(stretchDistance, bezierControlValue, bezierScaleRatioValue, thumbRadius));
            p4.moveX(this.extractLength(stretchDistance, bezierControlValue, bezierScaleRatioValue, thumbRadius));
        }
    }

    @Override
    public void changeOffset(PointWithHorizontalPoints p1, PointWithVerticalPoints p2, PointWithHorizontalPoints p3, PointWithVerticalPoints p4, float totalLength, float extractLength, float process, State state, EaseType easeType) {
        if (state.equals((Object)State.LEFT_TO_RIGHT)) {
            float offset = totalLength * easeType.getOffset((process - 0.251f) / 0.749f);
            offset = Utils.limitOffset(offset, totalLength);
            p1.moveX(offset);
            p2.moveX(offset);
            p3.moveX(offset);
            p4.moveX(offset);
        } else if (state.equals((Object)State.RIGHT_TO_LEFT)) {
            float rProcess = 1.0f - process;
            float offset = totalLength * easeType.getOffset((rProcess - 0.251f) / 0.749f);
            offset = Utils.limitOffset(offset, totalLength);
            p1.moveX(totalLength + extractLength - offset);
            p2.moveX(totalLength + extractLength - offset);
            p3.moveX(totalLength + extractLength - offset);
            p4.moveX(totalLength + extractLength - offset);
        } else if (state.equals((Object)State.LEFT)) {
            p1.moveX(0.0f);
            p2.moveX(0.0f);
            p3.moveX(0.0f);
            p4.moveX(0.0f);
        } else if (state.equals((Object)State.RIGHT)) {
            p1.moveX(totalLength);
            p2.moveX(totalLength);
            p3.moveX(totalLength);
            p4.moveX(totalLength);
        }
    }

    @Override
    public float extractLength(float stretchDistance, float bezierControlValue, float bezierScaleRatioValue, float thumbRadius) {
        return stretchDistance;
    }
}

