/*
 * Decompiled with CFR 0.152.
 */
package com.nightonke.jellytogglebutton;

import android.graphics.Color;
import com.nightonke.jellytogglebutton.ColorChangeTypes.ColorChangeType;

public class Utils {
    private static final float ERROR = 0.001f;
    private static Utils ourInstance = new Utils();

    public static int calculateMidColor(int leftColor, int rightColor, float process, ColorChangeType colorChangeType) {
        if (colorChangeType.equals((Object)ColorChangeType.RGB)) {
            return Color.argb((int)(Color.alpha((int)leftColor) + (int)((float)(Color.alpha((int)rightColor) - Color.alpha((int)leftColor)) * process)), (int)(Color.red((int)leftColor) + (int)((float)(Color.red((int)rightColor) - Color.red((int)leftColor)) * process)), (int)(Color.green((int)leftColor) + (int)((float)(Color.green((int)rightColor) - Color.green((int)leftColor)) * process)), (int)(Color.blue((int)leftColor) + (int)((float)(Color.blue((int)rightColor) - Color.blue((int)leftColor)) * process)));
        }
        if (colorChangeType.equals((Object)ColorChangeType.HSV)) {
            return Utils.getHSVColor(Utils.toHsvVector(leftColor), Utils.toHsvVector(rightColor), process);
        }
        return 0;
    }

    public static float[] toHsvVector(int color) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color, (float[])hsv);
        float[] vector = new float[3];
        double rad = Math.PI * (double)hsv[0] / 180.0;
        vector[0] = (float)Math.cos(rad) * hsv[1];
        vector[1] = (float)Math.sin(rad) * hsv[1];
        vector[2] = hsv[2];
        return vector;
    }

    public static int getHSVColor(float[] vector0, float[] vector1, float delta) {
        float[] vector = new float[]{(vector1[0] - vector0[0]) * delta + vector0[0], (vector1[1] - vector0[1]) * delta + vector0[1], (vector1[2] - vector0[2]) * delta + vector0[2]};
        float[] hsv = new float[3];
        hsv[1] = (float)Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1]);
        float f = hsv[0] = hsv[1] < 0.001f ? 0.0f : (float)(Math.atan2(vector[1] / hsv[1], vector[0] / hsv[1]) * 180.0 / Math.PI);
        if (hsv[0] < 0.0f) {
            hsv[0] = hsv[0] + 360.0f;
        }
        hsv[2] = vector[2];
        return Color.HSVToColor((float[])hsv);
    }

    public static float vibration(float x, float totalLength, float A, float B, float C, float D) {
        return (float)((double)A * Math.exp(-B * (x *= totalLength)) * Math.sin(C * x + D));
    }

    public static float limitOffset(float offset, float totalLength) {
        offset = offset > 0.0f ? offset : 0.0f;
        offset = offset > totalLength ? totalLength : offset;
        return offset;
    }

    public static Utils getInstance() {
        return ourInstance;
    }

    private Utils() {
    }
}

