/*
 * Decompiled with CFR 0.152.
 */
package com.nike.backstopper.validation.constraints.impl;

import com.nike.backstopper.validation.constraints.StringConvertsToClassType;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringConvertsToClassTypeValidator
implements ConstraintValidator<StringConvertsToClassType, String> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Class<?> desiredClass;
    private boolean allowCaseInsensitiveEnumMatch;

    public void initialize(StringConvertsToClassType constraintAnnotation) {
        this.desiredClass = constraintAnnotation.classType();
        this.allowCaseInsensitiveEnumMatch = constraintAnnotation.allowCaseInsensitiveEnumMatch();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (this.desiredClass.isEnum()) {
            return this.validateAsEnum(value);
        }
        if (this.isDesiredClassAssignableToOneOf(Byte.class, Byte.TYPE)) {
            return this.validateAsByte(value);
        }
        if (this.isDesiredClassAssignableToOneOf(Short.class, Short.TYPE)) {
            return this.validateAsShort(value);
        }
        if (this.isDesiredClassAssignableToOneOf(Integer.class, Integer.TYPE)) {
            return this.validateAsInt(value);
        }
        if (this.isDesiredClassAssignableToOneOf(Long.class, Long.TYPE)) {
            return this.validateAsLong(value);
        }
        if (this.isDesiredClassAssignableToOneOf(Float.class, Float.TYPE)) {
            return this.validateAsFloat(value);
        }
        if (this.isDesiredClassAssignableToOneOf(Double.class, Double.TYPE)) {
            return this.validateAsDouble(value);
        }
        if (this.isDesiredClassAssignableToOneOf(Boolean.class, Boolean.TYPE)) {
            return this.validateAsBoolean(value);
        }
        if (this.isDesiredClassAssignableToOneOf(Character.class, Character.TYPE)) {
            return this.validateAsChar(value);
        }
        if (this.isDesiredClassAssignableToOneOf(String.class)) {
            return true;
        }
        this.logger.error("Unhandled class type in StringConvertsToClassTypeValidator. This validator either needs to be expanded to support the class type or this constraint should not be used on the field. converts_to_class_type_validator_unhandled_class_type=true, class_type={}, field_value={}", this.desiredClass, (Object)value);
        return false;
    }

    protected boolean isDesiredClassAssignableToOneOf(Class<?> ... allowedClasses) {
        for (Class<?> allowedClass : allowedClasses) {
            if (!allowedClass.isAssignableFrom(this.desiredClass)) continue;
            return true;
        }
        return false;
    }

    protected boolean validateAsEnum(String value) {
        try {
            Enum.valueOf(this.desiredClass, value);
            return true;
        }
        catch (Exception exception) {
            if (!this.allowCaseInsensitiveEnumMatch) {
                return false;
            }
            ?[] enumValues = this.desiredClass.getEnumConstants();
            if (enumValues == null) {
                return false;
            }
            for (Object enumValue : enumValues) {
                if (!(enumValue instanceof Enum) || !((Enum)enumValue).name().equalsIgnoreCase(value)) continue;
                return true;
            }
            return false;
        }
    }

    protected boolean validateAsByte(String value) {
        try {
            Byte.parseByte(value);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected boolean validateAsShort(String value) {
        try {
            Short.parseShort(value);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected boolean validateAsInt(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected boolean validateAsLong(String value) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected boolean validateAsFloat(String value) {
        try {
            Float floatValue = Float.valueOf(Float.parseFloat(value));
            return !floatValue.isInfinite() && !floatValue.isNaN();
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected boolean validateAsDouble(String value) {
        try {
            Double doubleValue = Double.parseDouble(value);
            return !doubleValue.isInfinite() && !doubleValue.isNaN();
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected boolean validateAsBoolean(String value) {
        try {
            return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false");
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected boolean validateAsChar(String value) {
        try {
            if (value.length() != 1) {
                return false;
            }
            value.charAt(0);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

