/*
 * Decompiled with CFR 0.152.
 */
package com.nike.backstopper.model.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.nike.backstopper.model.DefaultErrorDTO;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtilWithDefaultErrorContractDTOSupport {
    private static final Logger logger = LoggerFactory.getLogger(JsonUtilWithDefaultErrorContractDTOSupport.class);
    public static final ObjectMapper DEFAULT_SMART_MAPPER = JsonUtilWithDefaultErrorContractDTOSupport.generateErrorContractObjectMapper(true, true);
    public static final String DEFAULT_ERROR_RESPONSE_STRING = "{\"error_id\":\"%uuid%\",\"errors\":[{\"code\":10,\"message\":\"An error occurred while fulfilling the request\"}]}";

    protected JsonUtilWithDefaultErrorContractDTOSupport() {
    }

    public static String writeValueAsString(Object value) {
        return JsonUtilWithDefaultErrorContractDTOSupport.writeValueAsString(value, DEFAULT_SMART_MAPPER);
    }

    public static String writeValueAsString(Object value, ObjectMapper mapper) {
        return JsonUtilWithDefaultErrorContractDTOSupport.writeValueAsString(value, mapper, DEFAULT_ERROR_RESPONSE_STRING);
    }

    public static String writeValueAsString(Object value, ObjectMapper mapper, String defaultResponseIfErrorDuringSerialization) {
        try {
            return mapper.writeValueAsString(value);
        }
        catch (Exception e) {
            String errorId = UUID.randomUUID().toString();
            logger.error("Exception occurred while generating error code JSON. Falling back to default response with error_id={}", (Object)errorId, (Object)e);
            if (defaultResponseIfErrorDuringSerialization == null) {
                defaultResponseIfErrorDuringSerialization = DEFAULT_ERROR_RESPONSE_STRING;
            }
            return defaultResponseIfErrorDuringSerialization.replace("%uuid%", errorId);
        }
    }

    public static ObjectMapper generateErrorContractObjectMapper(boolean excludeEmptyMetadataFromJson, boolean serializeErrorCodeFieldAsIntegerIfPossible) {
        return new ObjectMapper().setSerializerFactory((SerializerFactory)new ErrorContractSerializationFactory(null, excludeEmptyMetadataFromJson, serializeErrorCodeFieldAsIntegerIfPossible));
    }

    protected static class SmartErrorCodePropertyWriter
    extends BeanPropertyWriter {
        protected SmartErrorCodePropertyWriter(BeanPropertyWriter base) {
            super(base);
        }

        public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
            if (bean instanceof DefaultErrorDTO) {
                DefaultErrorDTO error = (DefaultErrorDTO)bean;
                try {
                    int codeAsInt = Integer.parseInt(error.code);
                    jgen.writeFieldName((SerializableString)this._name);
                    jgen.writeNumber(codeAsInt);
                    return;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            super.serializeAsField(bean, jgen, prov);
        }
    }

    protected static class MetadataPropertyWriter
    extends BeanPropertyWriter {
        protected MetadataPropertyWriter(BeanPropertyWriter base) {
            super(base);
        }

        public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
            if (bean instanceof DefaultErrorDTO) {
                DefaultErrorDTO error = (DefaultErrorDTO)bean;
                if (error.metadata == null || error.metadata.isEmpty()) {
                    return;
                }
            }
            super.serializeAsField(bean, jgen, prov);
        }
    }

    protected static class ErrorContractSerializationFactory
    extends BeanSerializerFactory {
        private static final String METADATA_FIELD_NAME = "metadata";
        private static final String ERROR_CODE_FIELD_NAME = "code";
        private final boolean excludeEmptyMetadataFromJson;
        private final boolean serializeErrorCodeFieldAsIntegerIfPossible;

        protected ErrorContractSerializationFactory(SerializerFactoryConfig config, boolean excludeEmptyMetadataFromJson, boolean serializeErrorCodeFieldAsIntegerIfPossible) {
            super(config);
            this.excludeEmptyMetadataFromJson = excludeEmptyMetadataFromJson;
            this.serializeErrorCodeFieldAsIntegerIfPossible = serializeErrorCodeFieldAsIntegerIfPossible;
        }

        protected List<BeanPropertyWriter> filterBeanProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> props) {
            List superResult = super.filterBeanProperties(config, beanDesc, props);
            if (DefaultErrorDTO.class.equals((Object)beanDesc.getBeanClass())) {
                int indexOfOrig;
                if (this.excludeEmptyMetadataFromJson) {
                    BeanPropertyWriter origMetadataPropWriter = this.findPropWriter(superResult, METADATA_FIELD_NAME);
                    indexOfOrig = superResult.indexOf(origMetadataPropWriter);
                    superResult.remove(origMetadataPropWriter);
                    superResult.add(indexOfOrig, new MetadataPropertyWriter(origMetadataPropWriter));
                }
                if (this.serializeErrorCodeFieldAsIntegerIfPossible) {
                    BeanPropertyWriter origErrorCodePropWriter = this.findPropWriter(superResult, ERROR_CODE_FIELD_NAME);
                    indexOfOrig = superResult.indexOf(origErrorCodePropWriter);
                    superResult.remove(origErrorCodePropWriter);
                    superResult.add(indexOfOrig, new SmartErrorCodePropertyWriter(origErrorCodePropWriter));
                }
            }
            return superResult;
        }

        protected BeanPropertyWriter findPropWriter(List<BeanPropertyWriter> propWriters, String desiredFieldName) {
            for (BeanPropertyWriter propWriter : propWriters) {
                if (!desiredFieldName.equals(propWriter.getName())) continue;
                return propWriter;
            }
            return null;
        }
    }
}

