/*
 * Decompiled with CFR 0.152.
 */
package com.nike.backstopper.apierror.contract.jsr303convention;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nike.backstopper.apierror.contract.jsr303convention.ReflectionBasedJsr303AnnotationTrollerBase;
import com.nike.backstopper.validation.constraints.StringConvertsToClassType;
import com.nike.internal.util.Pair;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;

public abstract class VerifyEnumsReferencedByStringConvertsToClassTypeJsr303AnnotationsAreJacksonCaseInsensitiveTest {
    @Nullable
    private final String fixReflectionsFieldScanner;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public VerifyEnumsReferencedByStringConvertsToClassTypeJsr303AnnotationsAreJacksonCaseInsensitiveTest() {
        this.fixReflectionsFieldScanner = null;
    }

    protected abstract ReflectionBasedJsr303AnnotationTrollerBase getAnnotationTroller();

    @Test
    public void verifyEnumsReferencedByStringConvertsToClassTypeJsr303AnnotationsAreCaseInsensitive() throws IOException {
        ReflectionBasedJsr303AnnotationTrollerBase troller = this.getAnnotationTroller();
        List<Pair<Annotation, AnnotatedElement>> allStringConvertsToClassTypeAnnotations = ReflectionBasedJsr303AnnotationTrollerBase.getSubAnnotationListForAnnotationsOfClassType(troller.projectRelevantConstraintAnnotationsExcludingUnitTestsList, StringConvertsToClassType.class);
        for (Pair<Annotation, AnnotatedElement> annotationPair : allStringConvertsToClassTypeAnnotations) {
            StringConvertsToClassType sctctAnnotation = (StringConvertsToClassType)annotationPair.getLeft();
            if (!sctctAnnotation.classType().isEnum() || !sctctAnnotation.allowCaseInsensitiveEnumMatch()) continue;
            Class enumClass = sctctAnnotation.classType();
            Object[] enumValuesArray = sctctAnnotation.classType().getEnumConstants();
            ((ObjectArrayAssert)Assertions.assertThat((Object[])enumValuesArray).isNotNull()).isNotEmpty();
            for (Object enumValue : enumValuesArray) {
                boolean deserializationSucceeded;
                String enumAsJsonString = this.objectMapper.writeValueAsString(enumValue);
                String lowercaseEnumAsJsonString = enumAsJsonString.toLowerCase();
                String uppercaseEnumAsJsonString = enumAsJsonString.toUpperCase();
                String alternateCaseEnumAsJsonString = enumAsJsonString.equals(lowercaseEnumAsJsonString) ? uppercaseEnumAsJsonString : lowercaseEnumAsJsonString;
                Assertions.assertThat((String)alternateCaseEnumAsJsonString).isNotEqualTo((Object)enumAsJsonString);
                try {
                    Enum deserializedEnum = (Enum)this.objectMapper.readValue(alternateCaseEnumAsJsonString, enumClass);
                    deserializationSucceeded = deserializedEnum.equals(enumValue);
                }
                catch (Throwable ex) {
                    deserializationSucceeded = false;
                }
                if (deserializationSucceeded) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("Found a @").append(StringConvertsToClassType.class.getSimpleName()).append(" annotation that references an enum class type that is not case insensitive. ").append("This most likely means you need to add a @JsonCreator method in the enum that knows how to deserialize the enum in a case insensitive manner. ").append("Offending enum class: ").append(enumClass.getName()).append(", offending element containing the annotation: ").append(ReflectionBasedJsr303AnnotationTrollerBase.getAnnotatedElementLocationAsString((AnnotatedElement)annotationPair.getRight()));
                throw new AssertionError((Object)sb.toString());
            }
        }
    }
}

