/*
 * Decompiled with CFR 0.152.
 */
package com.nike.backstopper.apierror.contract.jsr303convention;

import com.nike.backstopper.apierror.ApiError;
import com.nike.backstopper.apierror.contract.jsr303convention.ReflectionBasedJsr303AnnotationTrollerBase;
import com.nike.backstopper.apierror.projectspecificinfo.ProjectApiErrors;
import com.nike.internal.util.Pair;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class VerifyJsr303ValidationMessagesPointToApiErrorsTest {
    protected abstract ReflectionBasedJsr303AnnotationTrollerBase getAnnotationTroller();

    protected abstract ProjectApiErrors getProjectApiErrors();

    @Test
    public void verifyThatAllValidationAnnotationsReferToApiErrors() {
        AnnotatedElement annotatedElement;
        ReflectionBasedJsr303AnnotationTrollerBase troller = this.getAnnotationTroller();
        List<Pair<Annotation, AnnotatedElement>> relevantAnnotations = troller.projectRelevantConstraintAnnotationsExcludingUnitTestsList;
        ArrayList<InvalidAnnotationDescription> invalidAnnotations = new ArrayList<InvalidAnnotationDescription>();
        for (Pair<Annotation, AnnotatedElement> pair : relevantAnnotations) {
            Annotation annotation = (Annotation)pair.getLeft();
            annotatedElement = (AnnotatedElement)pair.getRight();
            String message = ReflectionBasedJsr303AnnotationTrollerBase.extractMessageFromAnnotation(annotation);
            try {
                ApiError apiError = this.getProjectApiErrors().convertToApiError(message);
                Assertions.assertThat((Object)apiError).isNotNull();
            }
            catch (Throwable ex) {
                invalidAnnotations.add(new InvalidAnnotationDescription(annotation, annotatedElement, message));
            }
        }
        if (invalidAnnotations.size() > 0) {
            invalidAnnotations.sort(Comparator.comparing(o -> ReflectionBasedJsr303AnnotationTrollerBase.getOwnerClass(o.annotatedElement).getName()).thenComparing(o -> ReflectionBasedJsr303AnnotationTrollerBase.getAnnotatedElementLocationAsString(o.annotatedElement)));
            StringBuilder sb = new StringBuilder();
            sb.append("There are ").append(invalidAnnotations.size()).append(" JSR 303 validation annotations that are invalid. All validation annotations MUST contain a message and that message MUST map to one of the ApiError names contained in ").append(this.getProjectApiErrors().getClass().getName()).append(". If any of these are false positive errors then you must add the Class or specific Member/annotated element that owns the annotation to one of the exclusion lists in this unit test.\n").append("You should only exclude annotations, however, if you REALLY REALLY REALLY know what you're doing and can 100% GUARANTEE that the exclusion won't break your error handling contract, because this strict message requirement *IS* how we're guaranteeing your error handling contract.\n").append("Here are the invalid annotations, where they are found, and the offending message:").append("\nANNOTATION CLASS\t|\tLOCATION\t|\tMESSAGE");
            for (InvalidAnnotationDescription invalidAnnotation : invalidAnnotations) {
                annotatedElement = invalidAnnotation.annotatedElement;
                sb.append("\n@").append(invalidAnnotation.annotation.annotationType().getSimpleName()).append("\t|\t");
                sb.append(ReflectionBasedJsr303AnnotationTrollerBase.getAnnotatedElementLocationAsString(annotatedElement));
                sb.append("\t|\t").append(invalidAnnotation.message);
            }
            throw new AssertionError((Object)sb.toString());
        }
    }

    private static class InvalidAnnotationDescription {
        public final Annotation annotation;
        public final AnnotatedElement annotatedElement;
        public final String message;

        private InvalidAnnotationDescription(Annotation annotation, AnnotatedElement annotatedElement, String message) {
            this.annotation = annotation;
            this.annotatedElement = annotatedElement;
            this.message = message;
        }
    }
}

