/*
 * Decompiled with CFR 0.152.
 */
package com.nike.backstopper.apierror.contract.jsr303convention;

import com.google.common.base.Predicate;
import com.nike.internal.util.Pair;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.validation.Constraint;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.MethodParameterScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public abstract class ReflectionBasedJsr303AnnotationTrollerBase {
    private Set<String> DEFAULT_CONSTRAINT_SEARCH_PACKAGES = new LinkedHashSet<String>(Arrays.asList("com.nike", "org.hibernate.validator.constraints", "javax.validation.constraints"));
    private final Reflections reflections;
    public final List<Class<? extends Annotation>> constraintAnnotationClasses;
    public final List<Pair<Annotation, AnnotatedElement>> allConstraintAnnotationsMasterList;
    public final List<Pair<Annotation, AnnotatedElement>> projectRelevantConstraintAnnotationsExcludingUnitTestsList;
    private final List<Class<?>> ignoreAllAnnotationsAssociatedWithTheseClasses = new ArrayList(this.setupIgnoreAllAnnotationsAssociatedWithTheseClasses());
    private final List<Predicate<Pair<Annotation, AnnotatedElement>>> specificAnnotationDeclarationsExcludedFromStrictMessageRequirement = new ArrayList<Predicate<Pair<Annotation, AnnotatedElement>>>(this.setupSpecificAnnotationDeclarationExclusions());

    protected abstract List<Class<?>> ignoreAllAnnotationsAssociatedWithTheseProjectClasses();

    protected abstract List<Predicate<Pair<Annotation, AnnotatedElement>>> specificAnnotationDeclarationExclusionsForProject() throws Exception;

    public ReflectionBasedJsr303AnnotationTrollerBase() {
        this((Set<String>)null);
    }

    public ReflectionBasedJsr303AnnotationTrollerBase(String ... extraPackagesForConstraintAnnotationSearch) {
        this(new LinkedHashSet<String>(Arrays.asList(extraPackagesForConstraintAnnotationSearch)));
    }

    public ReflectionBasedJsr303AnnotationTrollerBase(Set<String> extraPackagesForConstraintAnnotationSearch) {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        for (String packageToAdd : this.getFinalPackagesToSearchForConstraintAnnotations(extraPackagesForConstraintAnnotationSearch)) {
            configurationBuilder.addUrls(ClasspathHelper.forPackage((String)packageToAdd, (ClassLoader[])new ClassLoader[0]));
        }
        this.reflections = new Reflections((Configuration)configurationBuilder.setScanners(new Scanner[]{new SubTypesScanner(), new MethodParameterScanner(), new TypeAnnotationsScanner(), new MethodAnnotationsScanner(), new FieldAnnotationsScanner()}));
        this.constraintAnnotationClasses = new ArrayList<Class<? extends Annotation>>();
        for (Class constraintAnnotatedType : this.reflections.getTypesAnnotatedWith(Constraint.class, true)) {
            if (!constraintAnnotatedType.isAnnotation()) continue;
            this.constraintAnnotationClasses.add(constraintAnnotatedType);
        }
        for (Class annotationClass : this.reflections.getSubTypesOf(Annotation.class)) {
            if (!ReflectionBasedJsr303AnnotationTrollerBase.isMultiValueConstraintClass(annotationClass)) continue;
            this.constraintAnnotationClasses.add(annotationClass);
        }
        this.allConstraintAnnotationsMasterList = new ArrayList<Pair<Annotation, AnnotatedElement>>(this.setupAllConstraintAnnotationsMasterList(this.reflections, this.constraintAnnotationClasses));
        this.projectRelevantConstraintAnnotationsExcludingUnitTestsList = Collections.unmodifiableList(ReflectionBasedJsr303AnnotationTrollerBase.getSubAnnotationListUsingExclusionFilters(this.allConstraintAnnotationsMasterList, this.ignoreAllAnnotationsAssociatedWithTheseClasses, this.specificAnnotationDeclarationsExcludedFromStrictMessageRequirement));
    }

    protected Set<String> getFinalPackagesToSearchForConstraintAnnotations(Set<String> extraPackagesForConstraintAnnotationSearch) {
        LinkedHashSet<String> finalPackages = new LinkedHashSet<String>(this.getDefaultPackagesToSearchForConstraintAnnotations());
        if (extraPackagesForConstraintAnnotationSearch != null) {
            finalPackages.addAll(extraPackagesForConstraintAnnotationSearch);
        }
        return finalPackages;
    }

    protected Set<String> getDefaultPackagesToSearchForConstraintAnnotations() {
        return this.DEFAULT_CONSTRAINT_SEARCH_PACKAGES;
    }

    private List<Class<?>> setupIgnoreAllAnnotationsAssociatedWithTheseClasses() {
        List<Class<?>> ignoreList = this.ignoreAllAnnotationsAssociatedWithTheseProjectClasses();
        if (ignoreList == null) {
            ignoreList = new ArrayList();
        }
        return ignoreList;
    }

    private List<Predicate<Pair<Annotation, AnnotatedElement>>> setupSpecificAnnotationDeclarationExclusions() {
        List<Predicate<Pair<Annotation, AnnotatedElement>>> specificDeclarationExclusionsList;
        try {
            specificDeclarationExclusionsList = this.specificAnnotationDeclarationExclusionsForProject();
            if (specificDeclarationExclusionsList == null) {
                specificDeclarationExclusionsList = new ArrayList<Predicate<Pair<Annotation, AnnotatedElement>>>();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return specificDeclarationExclusionsList;
    }

    private List<Pair<Annotation, AnnotatedElement>> setupAllConstraintAnnotationsMasterList(Reflections reflectionsArg, List<Class<? extends Annotation>> constraintAnnotationClassesArg) {
        ArrayList<Pair<Annotation, AnnotatedElement>> masterList = new ArrayList<Pair<Annotation, AnnotatedElement>>();
        for (Class<? extends Annotation> constraintAnnotationClass : constraintAnnotationClassesArg) {
            Object annotatedElement22;
            boolean isMultiValueConstraint = ReflectionBasedJsr303AnnotationTrollerBase.isMultiValueConstraintClass(constraintAnnotationClass);
            ArrayList elementsAnnotatedWithThisClass = new ArrayList();
            elementsAnnotatedWithThisClass.addAll(reflectionsArg.getConstructorsAnnotatedWith(constraintAnnotationClass));
            elementsAnnotatedWithThisClass.addAll(reflectionsArg.getMethodsAnnotatedWith(constraintAnnotationClass));
            elementsAnnotatedWithThisClass.addAll(reflectionsArg.getFieldsAnnotatedWith(constraintAnnotationClass));
            for (Object annotatedElement22 : elementsAnnotatedWithThisClass) {
                List<Annotation> annotationsToRegister = ReflectionBasedJsr303AnnotationTrollerBase.explodeAnnotationToManyConstraintsIfMultiValue(annotatedElement22.getAnnotation(constraintAnnotationClass), isMultiValueConstraint);
                for (Annotation annotation : annotationsToRegister) {
                    masterList.add((Pair<Annotation, AnnotatedElement>)Pair.of((Object)annotation, (Object)annotatedElement22));
                }
            }
            ArrayList typesAnnotatedWithThisClass = new ArrayList();
            typesAnnotatedWithThisClass.addAll(reflectionsArg.getTypesAnnotatedWith(constraintAnnotationClass));
            annotatedElement22 = typesAnnotatedWithThisClass.iterator();
            while (annotatedElement22.hasNext()) {
                Class annotatedClassType = (Class)annotatedElement22.next();
                if (annotatedClassType.isAnnotation()) continue;
                List<Annotation> annotationsToRegister = ReflectionBasedJsr303AnnotationTrollerBase.explodeAnnotationToManyConstraintsIfMultiValue(annotatedClassType.getAnnotation(constraintAnnotationClass), isMultiValueConstraint);
                for (Annotation annotationToRegister2 : annotationsToRegister) {
                    masterList.add((Pair<Annotation, AnnotatedElement>)Pair.of((Object)annotationToRegister2, (Object)annotatedClassType));
                }
            }
            ArrayList methodParamsAnnotatedWithThisClass = new ArrayList();
            methodParamsAnnotatedWithThisClass.addAll(reflectionsArg.getMethodsWithAnyParamAnnotated(constraintAnnotationClass));
            for (Method methodWithAnnotatedParam : methodParamsAnnotatedWithThisClass) {
                Annotation[][] annotationArray = methodWithAnnotatedParam.getParameterAnnotations();
                masterList.addAll(ReflectionBasedJsr303AnnotationTrollerBase.extractAnnotationsFrom2dArray(annotationArray, constraintAnnotationClass, isMultiValueConstraint, methodWithAnnotatedParam));
            }
            ArrayList constructorParamsAnnotatedWithThisClass = new ArrayList();
            constructorParamsAnnotatedWithThisClass.addAll(reflectionsArg.getConstructorsWithAnyParamAnnotated(constraintAnnotationClass));
            for (Constructor constructor : constructorParamsAnnotatedWithThisClass) {
                Annotation[][] paramAnnotations = constructor.getParameterAnnotations();
                masterList.addAll(ReflectionBasedJsr303AnnotationTrollerBase.extractAnnotationsFrom2dArray(paramAnnotations, constraintAnnotationClass, isMultiValueConstraint, constructor));
            }
        }
        return masterList;
    }

    private static boolean isMultiValueConstraintClass(Class<? extends Annotation> annotationClass) {
        Method valueMethod;
        try {
            valueMethod = annotationClass.getDeclaredMethod("value", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return valueMethod.getReturnType().isArray() && valueMethod.getReturnType().getComponentType().getAnnotation(Constraint.class) != null;
    }

    private static List<Annotation> explodeAnnotationToManyConstraintsIfMultiValue(Annotation annotation, boolean isMultiValueConstraint) {
        if (!isMultiValueConstraint) {
            return Collections.singletonList(annotation);
        }
        try {
            Method valueMethod = annotation.getClass().getMethod("value", new Class[0]);
            Object[] subAnnotations = (Object[])valueMethod.invoke((Object)annotation, new Object[0]);
            ArrayList<Annotation> returnList = new ArrayList<Annotation>();
            for (Object subAnnotation : subAnnotations) {
                returnList.add((Annotation)subAnnotation);
            }
            return returnList;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Expected multi-value constraint annotation to have a 'value' method.", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Pair<Annotation, AnnotatedElement>> extractAnnotationsFrom2dArray(Annotation[][] annotations2dArray, Class<? extends Annotation> desiredAnnotationClass, boolean desiredAnnotationClassIsMultiValueConstraint, AnnotatedElement owningElement) {
        ArrayList<Pair<Annotation, AnnotatedElement>> returnList = new ArrayList<Pair<Annotation, AnnotatedElement>>();
        Annotation[][] annotationArray = annotations2dArray;
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] innerArray;
            for (Annotation annotation : innerArray = annotationArray[i]) {
                if (!annotation.annotationType().equals(desiredAnnotationClass)) continue;
                List<Annotation> annotationsToRegister = ReflectionBasedJsr303AnnotationTrollerBase.explodeAnnotationToManyConstraintsIfMultiValue(annotation, desiredAnnotationClassIsMultiValueConstraint);
                for (Annotation annotationToRegister : annotationsToRegister) {
                    returnList.add((Pair<Annotation, AnnotatedElement>)Pair.of((Object)annotationToRegister, (Object)owningElement));
                }
            }
        }
        return returnList;
    }

    public static Predicate<Pair<Annotation, AnnotatedElement>> generateExclusionForAnnotatedElementAndAnnotationClass(final AnnotatedElement annotatedElement, final Class<? extends Annotation> annotationClass) {
        return new Predicate<Pair<Annotation, AnnotatedElement>>(){

            public boolean apply(Pair<Annotation, AnnotatedElement> input) {
                return annotatedElement.equals(input.getRight()) && annotationClass.equals(((Annotation)input.getLeft()).annotationType());
            }
        };
    }

    public static String extractMessageFromAnnotation(Annotation annotation) {
        try {
            Method messageMethod = annotation.annotationType().getDeclaredMethod("message", new Class[0]);
            return (String)messageMethod.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class getOwnerClass(AnnotatedElement annotatedElement) {
        if (annotatedElement instanceof Member) {
            return ((Member)((Object)annotatedElement)).getDeclaringClass();
        }
        if (annotatedElement instanceof Class) {
            return (Class)annotatedElement;
        }
        throw new IllegalArgumentException("Expected annotatedElement to be of type Member or Class, but instead received: " + annotatedElement.getClass().getName());
    }

    public static List<Pair<Annotation, AnnotatedElement>> getSubAnnotationList(List<Pair<Annotation, AnnotatedElement>> listToFilter, Predicate<Pair<Annotation, AnnotatedElement>> keepTheseItemsFilter) {
        ArrayList<Pair<Annotation, AnnotatedElement>> returnList = new ArrayList<Pair<Annotation, AnnotatedElement>>();
        for (Pair<Annotation, AnnotatedElement> pair : listToFilter) {
            if (!keepTheseItemsFilter.apply(pair)) continue;
            returnList.add(pair);
        }
        return returnList;
    }

    public static List<Pair<Annotation, AnnotatedElement>> getSubAnnotationListForElementsOfOwnerClass(List<Pair<Annotation, AnnotatedElement>> listToFilter, final Class ownerClass) {
        return ReflectionBasedJsr303AnnotationTrollerBase.getSubAnnotationList(listToFilter, new Predicate<Pair<Annotation, AnnotatedElement>>(){

            public boolean apply(Pair<Annotation, AnnotatedElement> input) {
                return ReflectionBasedJsr303AnnotationTrollerBase.getOwnerClass((AnnotatedElement)input.getRight()).equals(ownerClass);
            }
        });
    }

    public static List<Pair<Annotation, AnnotatedElement>> getSubAnnotationListForAnnotationsOfClassType(List<Pair<Annotation, AnnotatedElement>> listToFilter, final Class desiredAnnotationClass) {
        return ReflectionBasedJsr303AnnotationTrollerBase.getSubAnnotationList(listToFilter, new Predicate<Pair<Annotation, AnnotatedElement>>(){

            public boolean apply(Pair<Annotation, AnnotatedElement> input) {
                return ((Annotation)input.getLeft()).annotationType().equals(desiredAnnotationClass);
            }
        });
    }

    public static List<Pair<Annotation, AnnotatedElement>> getSubAnnotationListUsingExclusionFilters(List<Pair<Annotation, AnnotatedElement>> listToFilter, final List<Class<?>> annotatedElementOwnerClassesToExclude, final List<Predicate<Pair<Annotation, AnnotatedElement>>> specificAnnotationDeclarationExclusionMatchers) {
        return ReflectionBasedJsr303AnnotationTrollerBase.getSubAnnotationList(listToFilter, new Predicate<Pair<Annotation, AnnotatedElement>>(){

            public boolean apply(Pair<Annotation, AnnotatedElement> input) {
                AnnotatedElement annotatedElement = (AnnotatedElement)input.getRight();
                if (annotatedElementOwnerClassesToExclude != null && annotatedElementOwnerClassesToExclude.contains(ReflectionBasedJsr303AnnotationTrollerBase.getOwnerClass(annotatedElement))) {
                    return false;
                }
                if (specificAnnotationDeclarationExclusionMatchers != null) {
                    for (Predicate exclusionMatcher : specificAnnotationDeclarationExclusionMatchers) {
                        if (!exclusionMatcher.apply(input)) continue;
                        return false;
                    }
                }
                return true;
            }
        });
    }

    public static String getAnnotatedElementLocationAsString(AnnotatedElement annotatedElement) {
        StringBuilder sb = new StringBuilder();
        sb.append(ReflectionBasedJsr303AnnotationTrollerBase.getOwnerClass(annotatedElement).getName());
        if (annotatedElement instanceof Constructor) {
            sb.append("[CONSTRUCTOR]");
        } else if (annotatedElement instanceof Class) {
            sb.append("[CLASS]");
        } else if (annotatedElement instanceof Method) {
            sb.append(".").append(((Method)annotatedElement).getName()).append("[METHOD]");
        } else if (annotatedElement instanceof Field) {
            sb.append(".").append(((Field)annotatedElement).getName()).append("[FIELD]");
        } else {
            sb.append(".").append(annotatedElement.toString()).append("[???]");
        }
        return sb.toString();
    }
}

