/*
 * Decompiled with CFR 0.152.
 */
package com.nike.backstopper.apierror.projectspecificinfo;

import com.nike.backstopper.apierror.ApiError;
import com.nike.backstopper.apierror.ApiErrorBase;
import com.nike.backstopper.apierror.projectspecificinfo.ProjectApiErrors;
import com.nike.backstopper.apierror.projectspecificinfo.ProjectSpecificErrorCodeRange;
import com.nike.backstopper.apierror.testutil.BarebonesCoreApiErrorForTesting;
import com.nike.backstopper.apierror.testutil.ProjectApiErrorsForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class ProjectApiErrorsTestBase {
    protected ApiError findRandomApiErrorWithHttpStatusCode(int httpStatusCode) {
        for (ApiError error : this.getProjectApiErrors().getProjectApiErrors()) {
            if (error.getHttpStatusCode() != httpStatusCode) continue;
            return error;
        }
        throw new IllegalStateException("Couldn't find ApiError with HTTP status code: " + httpStatusCode);
    }

    protected abstract ProjectApiErrors getProjectApiErrors();

    @Test
    public void verifyGetStatusCodePriorityOrderMethodContainsAllRelevantCodes() {
        for (ApiError error : this.getProjectApiErrors().getProjectApiErrors()) {
            int relevantCode = error.getHttpStatusCode();
            boolean containsRelevantCode = this.getProjectApiErrors().getStatusCodePriorityOrder().contains(relevantCode);
            if (!containsRelevantCode) {
                throw new AssertionError((Object)("getStatusCodePriorityOrder() did not contain HTTP Status Code: " + relevantCode + " for " + this.getProjectApiErrors().getClass().getName() + "'s ApiError: " + error));
            }
        }
    }

    @Test
    public void determineHighestPriorityHttpStatusCodeShouldReturnNullForNullErrorCollection() {
        MatcherAssert.assertThat((Object)this.getProjectApiErrors().determineHighestPriorityHttpStatusCode(null), (Matcher)Matchers.nullValue());
    }

    @Test
    public void determineHighestPriorityHttpStatusCodeShouldReturnNullForEmptyErrorCollection() {
        MatcherAssert.assertThat((Object)this.getProjectApiErrors().determineHighestPriorityHttpStatusCode(Collections.emptyList()), (Matcher)Matchers.nullValue());
    }

    @Test
    public void determineHighestPriorityHttpStatusCodeShouldReturnTheSameValueRegardlessOfErrorOrder() {
        List<ApiError> list = Arrays.asList(this.findRandomApiErrorWithHttpStatusCode((Integer)this.getProjectApiErrors().getStatusCodePriorityOrder().get(0)), this.findRandomApiErrorWithHttpStatusCode((Integer)this.getProjectApiErrors().getStatusCodePriorityOrder().get(1)));
        int returnValNormalOrder = this.getProjectApiErrors().determineHighestPriorityHttpStatusCode(list);
        Collections.reverse(list);
        int returnValReverseOrder = this.getProjectApiErrors().determineHighestPriorityHttpStatusCode(list);
        MatcherAssert.assertThat((Object)returnValNormalOrder, (Matcher)Matchers.is((Object)returnValReverseOrder));
    }

    @Test
    public void determineHighestPriorityHttpStatusCodeShouldReturnTheCorrectValueWithAMixedList() {
        ArrayList<ApiError> list = new ArrayList<ApiError>(Arrays.asList(this.findRandomApiErrorWithHttpStatusCode((Integer)this.getProjectApiErrors().getStatusCodePriorityOrder().get(2)), this.findRandomApiErrorWithHttpStatusCode((Integer)this.getProjectApiErrors().getStatusCodePriorityOrder().get(3))));
        MatcherAssert.assertThat((Object)this.getProjectApiErrors().determineHighestPriorityHttpStatusCode(list), (Matcher)Matchers.is(this.getProjectApiErrors().getStatusCodePriorityOrder().get(2)));
        list.add(this.findRandomApiErrorWithHttpStatusCode((Integer)this.getProjectApiErrors().getStatusCodePriorityOrder().get(1)));
        MatcherAssert.assertThat((Object)this.getProjectApiErrors().determineHighestPriorityHttpStatusCode(list), (Matcher)Matchers.is(this.getProjectApiErrors().getStatusCodePriorityOrder().get(1)));
    }

    @Test
    public void determineHighestPriorityHttpStatusCodeShouldReturnNullIfNoApiErrorsYouPassItHasHttpStatusCodeInPriorityOrderList() {
        ApiError mockApiError1 = (ApiError)Mockito.mock(ApiError.class);
        ApiError mockApiError2 = (ApiError)Mockito.mock(ApiError.class);
        ((ApiError)Mockito.doReturn((Object)414141).when((Object)mockApiError1)).getHttpStatusCode();
        ((ApiError)Mockito.doReturn((Object)424242).when((Object)mockApiError2)).getHttpStatusCode();
        List<ApiError> list = Arrays.asList(mockApiError1, mockApiError2);
        MatcherAssert.assertThat((Object)this.getProjectApiErrors().determineHighestPriorityHttpStatusCode(list), (Matcher)Matchers.nullValue());
    }

    @Test
    public void determineHighestPriorityHttpStatusCodeShouldReturnStatusCodeIfAtLeastOneApiErrorInListYouPassItHasHttpStatusCodeInPriorityOrderList() {
        ApiError mockApiError1 = (ApiError)Mockito.mock(ApiError.class);
        ApiError mockApiError2 = (ApiError)Mockito.mock(ApiError.class);
        ((ApiError)Mockito.doReturn((Object)424242).when((Object)mockApiError1)).getHttpStatusCode();
        ((ApiError)Mockito.doReturn((Object)400).when((Object)mockApiError2)).getHttpStatusCode();
        List<ApiError> list = Arrays.asList(mockApiError1, mockApiError2);
        MatcherAssert.assertThat((Object)this.getProjectApiErrors().determineHighestPriorityHttpStatusCode(list), (Matcher)Matchers.is((Object)400));
    }

    @Test
    public void determineHighestPriorityHttpStatusCodeShouldReturnStatusCodeIfOnlyApiError() {
        ApiError mockApiError = (ApiError)Mockito.mock(ApiError.class);
        ((ApiError)Mockito.doReturn((Object)400).when((Object)mockApiError)).getHttpStatusCode();
        MatcherAssert.assertThat((Object)this.getProjectApiErrors().determineHighestPriorityHttpStatusCode(Collections.singleton(mockApiError)), (Matcher)Matchers.is((Object)400));
    }

    @Test
    public void determineHighestPriorityHttpStatusCodeShouldReturnStatusCodeIfOnlyApiErrorEvenIfNotInPriorityOrderList() {
        ApiError mockApiError = (ApiError)Mockito.mock(ApiError.class);
        ((ApiError)Mockito.doReturn((Object)424242).when((Object)mockApiError)).getHttpStatusCode();
        MatcherAssert.assertThat((Object)this.getProjectApiErrors().determineHighestPriorityHttpStatusCode(Collections.singleton(mockApiError)), (Matcher)Matchers.is((Object)424242));
    }

    @Test
    public void getSublistContainingOnlyHttpStatusCodeShouldReturnEmptyListForNullErrorCollection() {
        MatcherAssert.assertThat((Object)this.getProjectApiErrors().getSublistContainingOnlyHttpStatusCode(null, (Integer)this.getProjectApiErrors().getStatusCodePriorityOrder().get(0)).size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void getSublistContainingOnlyHttpStatusCodeShouldReturnEmptyListForNullStatusCode() {
        ApiError randomError = (ApiError)this.getProjectApiErrors().getProjectApiErrors().get(0);
        MatcherAssert.assertThat((Object)this.getProjectApiErrors().getSublistContainingOnlyHttpStatusCode(Collections.singletonList(randomError), null).size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void getSublistContainingOnlyHttpStatusCodeShouldFilterOutExpectedValues() {
        List<ApiError> mixedList = Arrays.asList(this.findRandomApiErrorWithHttpStatusCode((Integer)this.getProjectApiErrors().getStatusCodePriorityOrder().get(0)), this.findRandomApiErrorWithHttpStatusCode((Integer)this.getProjectApiErrors().getStatusCodePriorityOrder().get(1)));
        List filteredList = this.getProjectApiErrors().getSublistContainingOnlyHttpStatusCode(mixedList, (Integer)this.getProjectApiErrors().getStatusCodePriorityOrder().get(1));
        for (ApiError error : filteredList) {
            MatcherAssert.assertThat((Object)error.getHttpStatusCode(), (Matcher)Matchers.is(this.getProjectApiErrors().getStatusCodePriorityOrder().get(1)));
        }
    }

    @Test
    public void convertToApiErrorShouldReturnNullIfYouPassItNull() {
        MatcherAssert.assertThat((Object)this.getProjectApiErrors().convertToApiError(null), (Matcher)Matchers.nullValue());
    }

    @Test
    public void convertToApiErrorShouldReturnExpectedResultIfPassedValidNames() {
        for (ApiError apiError : this.getProjectApiErrors().getProjectApiErrors()) {
            MatcherAssert.assertThat((String)("Did not get back the same instance for ApiError with name: " + apiError.getName() + ". This is usually because you have duplicate ApiError names - see the output of the shouldNotContainDuplicateNamedApiErrors() test to be sure. If that's not the case then you'll probably need to do some breakpoint debugging."), (Object)this.getProjectApiErrors().convertToApiError(apiError.getName()), (Matcher)Matchers.is((Object)apiError));
        }
    }

    @Test
    public void convertToApiErrorShouldReturnNullIfYouPassItGarbage() {
        MatcherAssert.assertThat((Object)this.getProjectApiErrors().convertToApiError(UUID.randomUUID().toString()), (Matcher)Matchers.nullValue());
    }

    @Test
    public void convertToApiErrorShouldUseFallbackOnNullValue() {
        BarebonesCoreApiErrorForTesting fallback = BarebonesCoreApiErrorForTesting.GENERIC_SERVICE_ERROR;
        MatcherAssert.assertThat((Object)this.getProjectApiErrors().convertToApiError(null, (ApiError)fallback), (Matcher)Matchers.is((Object)((Object)fallback)));
    }

    @Test
    public void convertToApiErrorShouldUseFallbackOnInvalidValue() {
        BarebonesCoreApiErrorForTesting fallback = BarebonesCoreApiErrorForTesting.GENERIC_SERVICE_ERROR;
        MatcherAssert.assertThat((Object)this.getProjectApiErrors().convertToApiError("notavaliderror", (ApiError)fallback), (Matcher)Matchers.is((Object)((Object)fallback)));
    }

    @Test(expected=IllegalStateException.class)
    public void verifyErrorsAreInRangeShouldThrowExceptionIfListIncludesNonCoreApiErrorAndRangeIsNull() {
        ProjectApiErrorsForTesting.withProjectSpecificData(Collections.singletonList(new ApiErrorBase("blah", 99001, "stuff", 400)), null);
    }

    @Test
    public void verifyErrorsAreInRangeShouldNotThrowExceptionIfListIncludesCoreApiErrors() {
        ProjectApiErrorsForTesting pae = ProjectApiErrorsForTesting.withProjectSpecificData(null, null);
        MatcherAssert.assertThat((Object)((Object)pae), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)pae.getProjectApiErrors().contains((Object)BarebonesCoreApiErrorForTesting.GENERIC_SERVICE_ERROR), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void verifyErrorsAreInRangeShouldNotThrowExceptionIfListIncludesCoreApiErrorWrapper() {
        BarebonesCoreApiErrorForTesting coreApiError = BarebonesCoreApiErrorForTesting.GENERIC_SERVICE_ERROR;
        ApiErrorBase coreApiErrorWrapper = new ApiErrorBase("blah", coreApiError.getErrorCode(), coreApiError.getMessage(), coreApiError.getHttpStatusCode());
        ProjectApiErrorsForTesting pae = ProjectApiErrorsForTesting.withProjectSpecificData(Collections.singletonList(coreApiErrorWrapper), null);
        MatcherAssert.assertThat((Object)((Object)pae), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)pae.getProjectApiErrors().contains(coreApiErrorWrapper), (Matcher)Matchers.is((Object)true));
    }

    @Test(expected=IllegalStateException.class)
    public void verifyErrorsAreInRangeShouldThrowExceptionIfListIncludesErrorOutOfRange() {
        ProjectApiErrorsForTesting.withProjectSpecificData(Collections.singletonList(new ApiErrorBase("blah", 1, "stuff", 400)), new ProjectSpecificErrorCodeRange(){

            public boolean isInRange(ApiError error) {
                return "42".equals(error.getErrorCode());
            }

            public String getName() {
                return "test error range";
            }
        });
    }

    @Test
    public void shouldNotContainDuplicateNamedApiErrors() {
        HashMap<String, Integer> nameToCountMap = new HashMap<String, Integer>();
        TreeSet<String> duplicateErrorNames = new TreeSet<String>();
        for (ApiError apiError : this.getProjectApiErrors().getProjectApiErrors()) {
            Integer currentCount = (Integer)nameToCountMap.get(apiError.getName());
            if (currentCount == null) {
                currentCount = 0;
            }
            Integer newCount = currentCount + 1;
            nameToCountMap.put(apiError.getName(), newCount);
            if (newCount <= 1) continue;
            duplicateErrorNames.add(apiError.getName());
        }
        if (!duplicateErrorNames.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("There are ApiError instances in the ProjectApiErrors that share duplicate names. [name, count]: ");
            boolean first = true;
            for (String dup : duplicateErrorNames) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append("[").append(dup).append(", ").append(nameToCountMap.get(dup)).append("]");
                first = false;
            }
            throw new AssertionError((Object)sb.toString());
        }
    }

    protected Set<String> allowedDuplicateErrorCodes() {
        return Collections.emptySet();
    }

    @Test
    public void should_not_contain_same_error_codes_for_different_instances_that_are_not_wrappers() {
        Set<String> allowedDuplicateErrorCodes = this.allowedDuplicateErrorCodes();
        HashMap<String, ApiError> codeToErrorMap = new HashMap<String, ApiError>();
        for (ApiError apiError : this.getProjectApiErrors().getProjectApiErrors()) {
            ApiError errorWithSameCode = (ApiError)codeToErrorMap.get(apiError.getErrorCode());
            if (errorWithSameCode != null && !this.areWrappersOfEachOther(apiError, errorWithSameCode) && !allowedDuplicateErrorCodes.contains(apiError.getErrorCode())) {
                throw new AssertionError((Object)("There are ApiError instances in the ProjectApiErrors that share duplicate error codes and are not wrappers of each other. error_code=" + apiError.getErrorCode() + ", conflicting_api_errors=[" + apiError.getName() + ", " + errorWithSameCode.getName() + "]"));
            }
            codeToErrorMap.put(apiError.getErrorCode(), apiError);
        }
    }

    private boolean areWrappersOfEachOther(ApiError error1, ApiError error2) {
        boolean httpStatusCodeMatches;
        boolean errorCodeMatches = Objects.equals(error1.getErrorCode(), error2.getErrorCode());
        boolean messageMatches = Objects.equals(error1.getMessage(), error2.getMessage());
        boolean bl = httpStatusCodeMatches = error1.getHttpStatusCode() == error2.getHttpStatusCode();
        return errorCodeMatches && messageMatches && httpStatusCodeMatches;
    }

    @Test
    public void allErrorsShouldBeCoreApiErrorsOrCoreApiErrorWrappersOrFallInProjectSpecificErrorRange() {
        ProjectSpecificErrorCodeRange projectSpecificErrorCodeRange = this.getProjectApiErrors().getProjectSpecificErrorCodeRange();
        for (ApiError error : this.getProjectApiErrors().getProjectApiErrors()) {
            boolean valid = false;
            if (this.getProjectApiErrors().getCoreApiErrors().contains(error) || this.getProjectApiErrors().isWrapperAroundCoreError(error, this.getProjectApiErrors().getCoreApiErrors())) {
                valid = true;
            } else if (projectSpecificErrorCodeRange != null && projectSpecificErrorCodeRange.isInRange(error)) {
                valid = true;
            }
            if (!valid) {
                throw new AssertionError((Object)("Found an ApiError in the ProjectApiErrors that is not a core error or wrapper around a core error, and its error code does not fall in the  range of getProjectApiErrors().getProjectSpecificErrorCodeRange(). getProjectApiErrors().getProjectSpecificErrorCodeRange(): " + projectSpecificErrorCodeRange + ". Offending error info: name=" + error.getName() + ", errorCode=" + error.getErrorCode() + ", message=\"" + error.getMessage() + "\", httpStatusCode=" + error.getHttpStatusCode() + ", class=" + error.getClass().getName()));
            }
        }
    }
}

