/*
 * Decompiled with CFR 0.152.
 */
package com.nike.backstopper.apierror.testutil;

import com.nike.backstopper.apierror.ApiError;
import com.nike.backstopper.apierror.ApiErrorBase;
import java.util.Map;
import java.util.UUID;

public enum BarebonesCoreApiErrorForTesting implements ApiError
{
    GENERIC_SERVICE_ERROR(10, "An error occurred while fulfilling the request", 500),
    OUTSIDE_DEPENDENCY_RETURNED_AN_UNRECOVERABLE_ERROR(GENERIC_SERVICE_ERROR),
    SERVERSIDE_VALIDATION_ERROR(GENERIC_SERVICE_ERROR),
    TEMPORARY_SERVICE_PROBLEM(20, "Service is temporarily unavailable, try again later", 503),
    OUTSIDE_DEPENDENCY_RETURNED_A_TEMPORARY_ERROR(TEMPORARY_SERVICE_PROBLEM),
    GENERIC_BAD_REQUEST(30, "Invalid request", 400),
    MISSING_EXPECTED_CONTENT(40, "Missing expected content", 400),
    TYPE_CONVERSION_ERROR(50, "Type conversion error", 400),
    MALFORMED_REQUEST(60, "Malformed request", 400),
    UNAUTHORIZED(70, "Unauthorized access", 401),
    FORBIDDEN(80, "Forbidden access", 403),
    NOT_FOUND(90, "The requested resource was not found", 404),
    METHOD_NOT_ALLOWED(100, "Http Request method not allowed for this resource", 405),
    NO_ACCEPTABLE_REPRESENTATION(110, "No acceptable representation for this resource", 406),
    UNSUPPORTED_MEDIA_TYPE(120, "Unsupported media type", 415),
    TOO_MANY_REQUESTS(130, "Too many requests or simultaneous requests not allowed for this endpoint", 429);

    private final ApiError delegate;

    private BarebonesCoreApiErrorForTesting(ApiError delegate) {
        this.delegate = delegate;
    }

    private BarebonesCoreApiErrorForTesting(int errorCode, String message, int httpStatusCode) {
        this((ApiError)new ApiErrorBase("delegated-to-enum-wrapper-" + UUID.randomUUID().toString(), errorCode, message, httpStatusCode));
    }

    public String getName() {
        return this.name();
    }

    public String getErrorCode() {
        return this.delegate.getErrorCode();
    }

    public String getMessage() {
        return this.delegate.getMessage();
    }

    public int getHttpStatusCode() {
        return this.delegate.getHttpStatusCode();
    }

    public Map<String, Object> getMetadata() {
        return this.delegate.getMetadata();
    }
}

