/*
 * Decompiled with CFR 0.152.
 */
package com.nike.backstopper.apierror.contract.jsr303convention;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nike.backstopper.apierror.contract.jsr303convention.ReflectionBasedJsr303AnnotationTrollerBase;
import com.nike.backstopper.validation.constraints.StringConvertsToClassType;
import com.nike.internal.util.Pair;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

@Deprecated
public abstract class VerifyEnumsReferencedByStringConvertsToClassTypeJsr303AnnotationsAreJacksonCaseInsensitiveTest {
    private ObjectMapper objectMapper = new ObjectMapper();

    protected abstract ReflectionBasedJsr303AnnotationTrollerBase getAnnotationTroller();

    @Test
    public void verifyEnumsReferencedByStringConvertsToClassTypeJsr303AnnotationsAreCaseInsensitive() throws IOException {
        ReflectionBasedJsr303AnnotationTrollerBase troller = this.getAnnotationTroller();
        List<Pair<Annotation, AnnotatedElement>> allStringConvertsToClassTypeAnnotations = ReflectionBasedJsr303AnnotationTrollerBase.getSubAnnotationListForAnnotationsOfClassType(troller.projectRelevantConstraintAnnotationsExcludingUnitTestsList, StringConvertsToClassType.class);
        for (Pair<Annotation, AnnotatedElement> annotationPair : allStringConvertsToClassTypeAnnotations) {
            StringConvertsToClassType sctctAnnotation = (StringConvertsToClassType)annotationPair.getLeft();
            if (!sctctAnnotation.classType().isEnum() || !sctctAnnotation.allowCaseInsensitiveEnumMatch()) continue;
            Class enumClass = sctctAnnotation.classType();
            T[] enumValuesArray = sctctAnnotation.classType().getEnumConstants();
            MatcherAssert.assertThat(enumValuesArray, (Matcher)CoreMatchers.notNullValue());
            for (Object enumValue : enumValuesArray) {
                boolean deserializationSucceeded;
                String enumAsJsonString = this.objectMapper.writeValueAsString(enumValue);
                String lowercaseEnumAsJsonString = enumAsJsonString.toLowerCase();
                String uppercaseEnumAsJsonString = enumAsJsonString.toUpperCase();
                String alternateCaseEnumAsJsonString = enumAsJsonString.equals(lowercaseEnumAsJsonString) ? uppercaseEnumAsJsonString : lowercaseEnumAsJsonString;
                MatcherAssert.assertThat((Object)alternateCaseEnumAsJsonString, (Matcher)CoreMatchers.not((Object)enumAsJsonString));
                try {
                    Enum deserializedEnum = (Enum)this.objectMapper.readValue(alternateCaseEnumAsJsonString, enumClass);
                    deserializationSucceeded = deserializedEnum.equals(enumValue);
                }
                catch (Throwable ex) {
                    deserializationSucceeded = false;
                }
                if (deserializationSucceeded) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("Found a @").append(StringConvertsToClassType.class.getSimpleName()).append(" annotation that references an enum class type that is not case insensitive. ").append("This most likely means you need to add a @JsonCreator method in the enum that knows how to deserialize the enum in a case insensitive manner. ").append("Offending enum class: ").append(enumClass.getName()).append(", offending element containing the annotation: ").append(ReflectionBasedJsr303AnnotationTrollerBase.getAnnotatedElementLocationAsString((AnnotatedElement)annotationPair.getRight()));
                throw new AssertionError((Object)sb.toString());
            }
        }
    }
}

