/*
 * Decompiled with CFR 0.152.
 */
package com.nike.backstopper.handler.adapter;

import com.nike.backstopper.handler.RequestInfoForLogging;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestInfoForLoggingServletApiAdapter
implements RequestInfoForLogging {
    private static final Logger logger = LoggerFactory.getLogger(RequestInfoForLoggingServletApiAdapter.class);
    private final HttpServletRequest request;
    private Map<String, List<String>> headersMapCache;

    public RequestInfoForLoggingServletApiAdapter(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        this.request = request;
    }

    public String getRequestUri() {
        return this.request.getRequestURI();
    }

    public String getRequestHttpMethod() {
        return this.request.getMethod();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public Map<String, List<String>> getHeadersMap() {
        if (this.headersMapCache == null) {
            HashMap<String, List<String>> headersMap = new HashMap<String, List<String>>();
            Enumeration headerNames = this.request.getHeaderNames();
            if (headerNames != null) {
                while (headerNames.hasMoreElements()) {
                    String nextHeaderName = (String)headerNames.nextElement();
                    Enumeration headerValues = this.request.getHeaders(nextHeaderName);
                    if (headerValues == null) continue;
                    headersMap.put(nextHeaderName, Collections.list(headerValues));
                }
            }
            this.headersMapCache = headersMap;
        }
        return this.headersMapCache;
    }

    public String getHeader(String headerName) {
        return this.request.getHeader(headerName);
    }

    public List<String> getHeaders(String headerName) {
        return this.getHeadersMap().get(headerName);
    }

    public Object getAttribute(String key) {
        return this.request.getAttribute(key);
    }

    public String getBody() throws RequestInfoForLogging.GetBodyException {
        ServletInputStream is = null;
        BufferedReader reader = null;
        try {
            int c;
            is = this.request.getInputStream();
            reader = new BufferedReader(new InputStreamReader((InputStream)is, this.request.getCharacterEncoding() != null ? this.request.getCharacterEncoding() : StandardCharsets.UTF_8.name()));
            StringBuilder textBuilder = new StringBuilder();
            while ((c = ((Reader)reader).read()) != -1) {
                textBuilder.append((char)c);
            }
            String string = textBuilder.toString();
            this.safeCloseCloseable(reader);
            this.safeCloseCloseable((Closeable)is);
            return string;
        }
        catch (Throwable e) {
            try {
                throw new RequestInfoForLogging.GetBodyException("An error occurred while extracting the request body", e);
            }
            catch (Throwable throwable) {
                this.safeCloseCloseable(reader);
                this.safeCloseCloseable((Closeable)is);
                throw throwable;
            }
        }
    }

    protected void safeCloseCloseable(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Throwable e) {
            logger.warn("An error occurred closing a Closeable resource. closeable_classname=\"" + closeable.getClass().getName() + "\", exception_during_close=\"" + e.toString() + "\"");
        }
    }
}

