/*
 * Decompiled with CFR 0.152.
 */
package com.nike.backstopper.servletapi;

import com.nike.backstopper.apierror.ApiError;
import com.nike.backstopper.apierror.projectspecificinfo.ProjectApiErrors;
import com.nike.backstopper.exception.ApiException;
import com.nike.backstopper.exception.WrapperException;
import com.nike.internal.util.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Singleton
public class UnhandledServletContainerErrorHelper {
    protected static final List<String> DEFAULT_THROWABLE_REQUEST_ATTR_NAMES = Arrays.asList("org.springframework.boot.web.reactive.error.DefaultErrorAttributes.ERROR", "org.springframework.boot.web.servlet.error.DefaultErrorAttributes.ERROR", "org.springframework.boot.autoconfigure.web.DefaultErrorAttributes.ERROR", "javax.servlet.error.exception");
    protected static final List<String> DEFAULT_ERROR_STATUS_CODE_REQUEST_ATTR_NAMES = Collections.singletonList("javax.servlet.error.status_code");

    @NotNull
    public Throwable extractOrGenerateErrorForRequest(ServletRequest request, @NotNull ProjectApiErrors projectApiErrors) {
        Throwable ex = this.extractErrorThrowable(request);
        if (ex != null) {
            return new WrapperException("Caught a container exception.", ex);
        }
        Integer errorStatusCode = this.extractErrorStatusCode(request);
        if (errorStatusCode != null && errorStatusCode == 404) {
            return ApiException.newBuilder().withApiErrors(new ApiError[]{projectApiErrors.getNotFoundApiError()}).withExceptionMessage("Synthetic exception for container 404.").withExtraDetailsForLogging(new Pair[]{Pair.of((Object)"synthetic_exception_for_container_404", (Object)"true")}).build();
        }
        return ApiException.newBuilder().withApiErrors(new ApiError[]{projectApiErrors.getGenericServiceError()}).withExceptionMessage("Synthetic exception for unhandled container status code: " + errorStatusCode).withExtraDetailsForLogging(new Pair[]{Pair.of((Object)"synthetic_exception_for_unhandled_status_code", (Object)String.valueOf(errorStatusCode))}).build();
    }

    @NotNull
    protected List<String> getThrowableRequestAttrNames() {
        return DEFAULT_THROWABLE_REQUEST_ATTR_NAMES;
    }

    @Nullable
    protected Throwable extractErrorThrowable(@NotNull ServletRequest request) {
        for (String throwableAttrName : this.getThrowableRequestAttrNames()) {
            Object throwableObj = request.getAttribute(throwableAttrName);
            if (!(throwableObj instanceof Throwable)) continue;
            return (Throwable)throwableObj;
        }
        return null;
    }

    @NotNull
    protected List<String> getErrorStatusCodeRequestAttrNames() {
        return DEFAULT_ERROR_STATUS_CODE_REQUEST_ATTR_NAMES;
    }

    @Nullable
    protected Integer extractErrorStatusCode(@NotNull ServletRequest request) {
        for (String errorStatusCodeAttrName : this.getErrorStatusCodeRequestAttrNames()) {
            Integer errorStatusCode = this.extractRequestAttrAsInteger(request, errorStatusCodeAttrName);
            if (errorStatusCode == null) continue;
            return errorStatusCode;
        }
        return null;
    }

    @Nullable
    protected Integer extractRequestAttrAsInteger(@NotNull ServletRequest request, @NotNull String attrName) {
        Object attrObj = request.getAttribute(attrName);
        if (attrObj == null) {
            return null;
        }
        if (attrObj instanceof Integer) {
            return (Integer)attrObj;
        }
        try {
            return Integer.parseInt(attrObj.toString());
        }
        catch (Exception ex) {
            return null;
        }
    }
}

