/*
 * Decompiled with CFR 0.152.
 */
package com.nike.backstopper.handler.spring;

import com.nike.backstopper.apierror.ApiError;
import com.nike.backstopper.apierror.projectspecificinfo.ProjectApiErrors;
import com.nike.backstopper.handler.ApiExceptionHandlerServletApiBase;
import com.nike.backstopper.handler.ApiExceptionHandlerUtils;
import com.nike.backstopper.handler.ErrorResponseInfo;
import com.nike.backstopper.handler.RequestInfoForLogging;
import com.nike.backstopper.handler.UnexpectedMajorExceptionHandlingError;
import com.nike.backstopper.handler.spring.SpringApiExceptionHandlerUtils;
import com.nike.backstopper.handler.spring.SpringUnhandledExceptionHandler;
import com.nike.backstopper.handler.spring.listener.ApiExceptionHandlerListenerList;
import com.nike.backstopper.model.DefaultErrorContractDTO;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Named
@Singleton
public class SpringApiExceptionHandler
extends ApiExceptionHandlerServletApiBase<ModelAndView>
implements HandlerExceptionResolver,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private int order = -2147483647;
    protected final SpringApiExceptionHandlerUtils springUtils;

    @Inject
    public SpringApiExceptionHandler(ProjectApiErrors projectApiErrors, ApiExceptionHandlerListenerList apiExceptionHandlerListeners, ApiExceptionHandlerUtils generalUtils, SpringApiExceptionHandlerUtils springUtils) {
        super(projectApiErrors, apiExceptionHandlerListeners.listeners, generalUtils);
        this.springUtils = springUtils;
    }

    protected ModelAndView prepareFrameworkRepresentation(DefaultErrorContractDTO errorContractDTO, int httpStatusCode, Collection<ApiError> rawFilteredApiErrors, Throwable originalException, RequestInfoForLogging request) {
        return this.springUtils.generateModelAndViewForErrorResponse(errorContractDTO, httpStatusCode, rawFilteredApiErrors, originalException, request);
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        try {
            ErrorResponseInfo errorResponseInfo = this.maybeHandleException(ex, request, response);
            if (errorResponseInfo == null) {
                return null;
            }
            return (ModelAndView)errorResponseInfo.frameworkRepresentationObj;
        }
        catch (UnexpectedMajorExceptionHandlingError ohNoException) {
            this.logger.error("Unexpected major error while handling exception. " + SpringUnhandledExceptionHandler.class.getName() + " should handle it.", (Throwable)ohNoException);
            return null;
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

