/*
 * Decompiled with CFR 0.152.
 */
package com.nike.backstopper.handler.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nike.backstopper.apierror.ApiError;
import com.nike.backstopper.handler.RequestInfoForLogging;
import com.nike.backstopper.model.DefaultErrorContractDTO;
import com.nike.backstopper.model.util.JsonUtilWithDefaultErrorContractDTOSupport;
import java.util.Collection;
import javax.inject.Named;
import javax.inject.Singleton;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

@Named
@Singleton
public class SpringApiExceptionHandlerUtils {
    public static final SpringApiExceptionHandlerUtils DEFAULT_IMPL = new SpringApiExceptionHandlerUtils();

    public ModelAndView generateModelAndViewForErrorResponse(DefaultErrorContractDTO errorContractDTO, int httpStatusCode, Collection<ApiError> rawFilteredApiErrors, Throwable originalException, RequestInfoForLogging request) {
        MappingJackson2JsonView view = new MappingJackson2JsonView();
        view.setExtractValueFromSingleKeyModel(true);
        view.setObjectMapper(this.getObjectMapperForJsonErrorResponseSerialization(errorContractDTO, httpStatusCode, rawFilteredApiErrors, originalException, request));
        ModelAndView mv = new ModelAndView((View)view);
        mv.addObject((Object)errorContractDTO);
        return mv;
    }

    protected ObjectMapper getObjectMapperForJsonErrorResponseSerialization(DefaultErrorContractDTO errorContractDTO, int httpStatusCode, Collection<ApiError> rawFilteredApiErrors, Throwable originalException, RequestInfoForLogging request) {
        return JsonUtilWithDefaultErrorContractDTOSupport.DEFAULT_SMART_MAPPER;
    }
}

