/*
 * Decompiled with CFR 0.152.
 */
package com.nike.backstopper.handler.spring;

import com.nike.backstopper.apierror.projectspecificinfo.ProjectApiErrors;
import com.nike.backstopper.servletapi.UnhandledServletContainerErrorHelper;
import javax.servlet.ServletRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"${server.error.path:${error.path:/error}}"})
@Conditional(value={SpringbootErrorControllerIsNotOnClasspath.class})
public class SpringContainerErrorController {
    @NotNull
    protected final ProjectApiErrors projectApiErrors;
    @NotNull
    protected final UnhandledServletContainerErrorHelper unhandledServletContainerErrorHelper;

    public SpringContainerErrorController(@NotNull ProjectApiErrors projectApiErrors, @NotNull UnhandledServletContainerErrorHelper unhandledServletContainerErrorHelper) {
        if (projectApiErrors == null) {
            throw new NullPointerException("ProjectApiErrors cannot be null.");
        }
        if (unhandledServletContainerErrorHelper == null) {
            throw new NullPointerException("UnhandledServletContainerErrorHelper cannot be null.");
        }
        this.projectApiErrors = projectApiErrors;
        this.unhandledServletContainerErrorHelper = unhandledServletContainerErrorHelper;
    }

    @RequestMapping
    public void error(ServletRequest request) throws Throwable {
        throw this.unhandledServletContainerErrorHelper.extractOrGenerateErrorForRequest(request, this.projectApiErrors);
    }

    protected static class SpringbootErrorControllerIsNotOnClasspath
    implements ConfigurationCondition {
        protected SpringbootErrorControllerIsNotOnClasspath() {
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return !this.isClassAvailableOnClasspath("org.springframework.boot.autoconfigure.web.ErrorController") && !this.isClassAvailableOnClasspath("org.springframework.boot.web.servlet.error.ErrorController");
        }

        protected boolean isClassAvailableOnClasspath(String classname) {
            try {
                Class.forName(classname);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
    }
}

