/*
 * Decompiled with CFR 0.152.
 */
package com.nike.backstopper.handler.spring;

import com.nike.backstopper.apierror.ApiError;
import com.nike.backstopper.apierror.projectspecificinfo.ProjectApiErrors;
import com.nike.backstopper.handler.ApiExceptionHandlerUtils;
import com.nike.backstopper.handler.ErrorResponseInfo;
import com.nike.backstopper.handler.RequestInfoForLogging;
import com.nike.backstopper.handler.UnhandledExceptionHandlerServletApiBase;
import com.nike.backstopper.handler.spring.SpringApiExceptionHandlerUtils;
import com.nike.backstopper.model.DefaultErrorContractDTO;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Named
@Singleton
public class SpringUnhandledExceptionHandler
extends UnhandledExceptionHandlerServletApiBase<ModelAndView>
implements HandlerExceptionResolver,
Ordered {
    private int order = -1;
    protected final SpringApiExceptionHandlerUtils springUtils;
    protected final Set<ApiError> singletonGenericServiceError;
    protected final int genericServiceErrorHttpStatusCode;

    @Inject
    public SpringUnhandledExceptionHandler(ProjectApiErrors projectApiErrors, ApiExceptionHandlerUtils generalUtils, SpringApiExceptionHandlerUtils springUtils) {
        super(projectApiErrors, generalUtils);
        this.springUtils = springUtils;
        this.singletonGenericServiceError = Collections.singleton(projectApiErrors.getGenericServiceError());
        this.genericServiceErrorHttpStatusCode = projectApiErrors.getGenericServiceError().getHttpStatusCode();
    }

    protected ModelAndView prepareFrameworkRepresentation(DefaultErrorContractDTO errorContractDTO, int httpStatusCode, Collection<ApiError> rawFilteredApiErrors, Throwable originalException, RequestInfoForLogging request) {
        return this.springUtils.generateModelAndViewForErrorResponse(errorContractDTO, httpStatusCode, rawFilteredApiErrors, originalException, request);
    }

    protected ErrorResponseInfo<ModelAndView> generateLastDitchFallbackErrorResponseInfo(Throwable ex, RequestInfoForLogging request, String errorUid, Map<String, List<String>> headersForResponseWithErrorUid) {
        DefaultErrorContractDTO errorContract = new DefaultErrorContractDTO(errorUid, this.singletonGenericServiceError);
        return new ErrorResponseInfo(this.genericServiceErrorHttpStatusCode, (Object)SpringApiExceptionHandlerUtils.DEFAULT_IMPL.generateModelAndViewForErrorResponse(errorContract, this.genericServiceErrorHttpStatusCode, this.singletonGenericServiceError, ex, request), headersForResponseWithErrorUid);
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        return (ModelAndView)this.handleException((Throwable)ex, (HttpServletRequest)request, (HttpServletResponse)response).frameworkRepresentationObj;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

