/*
 * Decompiled with CFR 0.152.
 */
package com.nike.backstopper.handler.spring.listener.impl;

import com.nike.backstopper.apierror.ApiError;
import com.nike.backstopper.apierror.ApiErrorWithMetadata;
import com.nike.backstopper.apierror.projectspecificinfo.ProjectApiErrors;
import com.nike.backstopper.handler.ApiExceptionHandlerUtils;
import com.nike.backstopper.handler.listener.ApiExceptionHandlerListenerResult;
import com.nike.backstopper.handler.spring.listener.impl.OneOffSpringCommonFrameworkExceptionHandlerListener;
import com.nike.internal.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;

@Named
@Singleton
public class OneOffSpringWebMvcFrameworkExceptionHandlerListener
extends OneOffSpringCommonFrameworkExceptionHandlerListener {
    @Inject
    public OneOffSpringWebMvcFrameworkExceptionHandlerListener(ProjectApiErrors projectApiErrors, ApiExceptionHandlerUtils utils) {
        super(projectApiErrors, utils);
    }

    @NotNull
    protected ApiExceptionHandlerListenerResult handleSpringMvcOrWebfluxSpecificFrameworkExceptions(@NotNull Throwable ex) {
        ArrayList<Pair<String, String>> extraDetailsForLogging = new ArrayList<Pair<String, String>>();
        if (ex instanceof ServletRequestBindingException) {
            return this.handleServletRequestBindingException((ServletRequestBindingException)ex, extraDetailsForLogging);
        }
        if (ex instanceof HttpMediaTypeNotAcceptableException) {
            return this.handleError(this.projectApiErrors.getNoAcceptableRepresentationApiError(), extraDetailsForLogging);
        }
        if (ex instanceof HttpMediaTypeNotSupportedException) {
            return this.handleError(this.projectApiErrors.getUnsupportedMediaTypeApiError(), extraDetailsForLogging);
        }
        if (ex instanceof HttpRequestMethodNotSupportedException) {
            return this.handleError(this.projectApiErrors.getMethodNotAllowedApiError(), extraDetailsForLogging);
        }
        if (ex instanceof MissingServletRequestPartException) {
            MissingServletRequestPartException detailsEx = (MissingServletRequestPartException)ex;
            return this.handleError((ApiError)new ApiErrorWithMetadata(this.projectApiErrors.getMalformedRequestApiError(), new Pair[]{Pair.of((Object)"missing_required_part", (Object)detailsEx.getRequestPartName())}), extraDetailsForLogging);
        }
        return ApiExceptionHandlerListenerResult.ignoreResponse();
    }

    protected ApiExceptionHandlerListenerResult handleServletRequestBindingException(ServletRequestBindingException ex, List<Pair<String, String>> extraDetailsForLogging) {
        this.utils.addBaseExceptionMessageToExtraDetailsForLogging((Throwable)ex, extraDetailsForLogging);
        ApiError errorToUse = this.projectApiErrors.getMalformedRequestApiError();
        if (ex instanceof MissingServletRequestParameterException) {
            MissingServletRequestParameterException detailsEx = (MissingServletRequestParameterException)ex;
            errorToUse = new ApiErrorWithMetadata(errorToUse, new Pair[]{Pair.of((Object)"missing_param_name", (Object)detailsEx.getParameterName()), Pair.of((Object)"missing_param_type", (Object)detailsEx.getParameterType())});
        }
        return this.handleError(errorToUse, extraDetailsForLogging);
    }
}

