/*
 * Decompiled with CFR 0.152.
 */
package com.nike.internal.util;

import com.nike.internal.util.ImmutablePair;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public abstract class Pair<L, R>
implements Map.Entry<L, R>,
Comparable<Pair<L, R>>,
Serializable {
    private static final long serialVersionUID = 4954918890077093841L;

    public static <L, R> Pair<L, R> of(L left, R right) {
        return new ImmutablePair<L, R>(left, right);
    }

    public abstract L getLeft();

    public abstract R getRight();

    @Override
    public final L getKey() {
        return this.getLeft();
    }

    @Override
    public R getValue() {
        return this.getRight();
    }

    @Override
    public int compareTo(Pair<L, R> other) {
        if (this == other) {
            return 0;
        }
        int leftComparison = this.compareObj(this.getLeft(), other.getLeft());
        if (leftComparison != 0) {
            return leftComparison;
        }
        return this.compareObj(this.getRight(), other.getRight());
    }

    protected <T> int compareObj(T thisObj, T otherObj) {
        if (thisObj == otherObj) {
            return 0;
        }
        if (thisObj == null) {
            return -1;
        }
        if (otherObj == null) {
            return 1;
        }
        Comparable comparable = (Comparable)thisObj;
        return comparable.compareTo(otherObj);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Map.Entry) {
            Map.Entry other = (Map.Entry)obj;
            return Objects.equals(this.getKey(), other.getKey()) && Objects.equals(this.getValue(), other.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
    }

    public String toString() {
        return "" + '(' + this.getLeft() + ',' + this.getRight() + ')';
    }

    public String toString(String format) {
        return String.format(format, this.getLeft(), this.getRight());
    }
}

