/*
 * Decompiled with CFR 0.152.
 */
package com.nike.internal.util;

import java.util.Collection;

public class StringUtils {
    protected StringUtils() {
    }

    public static String join(Collection<?> iterable, String delimiter) {
        return StringUtils.join(iterable, delimiter, null, null);
    }

    public static String join(Collection<?> iterable, String delimiter, String prefix, String suffix) {
        if (iterable == null) {
            throw new IllegalArgumentException("iterable cannot be null");
        }
        if (delimiter == null) {
            throw new IllegalArgumentException("delimiter cannot be null");
        }
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        boolean firstItem = true;
        for (Object obj : iterable) {
            if (!firstItem) {
                sb.append(delimiter);
            }
            sb.append(String.valueOf(obj));
            firstItem = false;
        }
        sb.append(suffix);
        return sb.toString();
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }
}

