/*
 * Decompiled with CFR 0.152.
 */
package com.nike.backstopper.handler.riposte;

import com.nike.backstopper.handler.RequestInfoForLogging;
import com.nike.riposte.server.http.RequestInfo;
import com.nike.riposte.util.HttpUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequestInfoForLoggingRiposteAdapter
implements RequestInfoForLogging {
    @NotNull
    private final RequestInfo<?> request;
    @Nullable
    private Map<String, List<String>> headersMapCache;

    public RequestInfoForLoggingRiposteAdapter(@NotNull RequestInfo<?> request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        this.request = request;
    }

    @NotNull
    public String getRequestUri() {
        return this.request.getPath();
    }

    @NotNull
    public String getRequestHttpMethod() {
        return String.valueOf(this.request.getMethod());
    }

    @Nullable
    public String getQueryString() {
        return HttpUtils.extractQueryString(this.request.getUri());
    }

    @NotNull
    public Map<String, List<String>> getHeadersMap() {
        if (this.headersMapCache == null) {
            HashMap<String, List<String>> headersMap = new HashMap<String, List<String>>();
            Set headerNames = this.request.getHeaders().names();
            if (headerNames != null) {
                for (String headerName : headerNames) {
                    List headerValues = this.request.getHeaders().getAll(headerName);
                    if (headerValues == null) continue;
                    headersMap.put(headerName, headerValues);
                }
            }
            this.headersMapCache = headersMap;
        }
        return this.headersMapCache;
    }

    @Nullable
    public String getHeader(String headerName) {
        return this.request.getHeaders().get(headerName);
    }

    @Nullable
    public List<String> getHeaders(String headerName) {
        return this.getHeadersMap().get(headerName);
    }

    @Nullable
    public Object getAttribute(String key) {
        return null;
    }

    @NotNull
    public String getBody() throws RequestInfoForLogging.GetBodyException {
        try {
            String result = this.request.getRawContent();
            if (result == null) {
                result = "";
            }
            return result;
        }
        catch (Exception ex) {
            throw new RequestInfoForLogging.GetBodyException("An error occurred while trying to extract the request body.", (Throwable)ex);
        }
    }
}

