/*
 * Decompiled with CFR 0.152.
 */
package com.nike.backstopper.handler.riposte;

import com.nike.backstopper.apierror.ApiError;
import com.nike.backstopper.apierror.projectspecificinfo.ProjectApiErrors;
import com.nike.backstopper.handler.ApiExceptionHandlerBase;
import com.nike.backstopper.handler.ApiExceptionHandlerUtils;
import com.nike.backstopper.handler.ErrorResponseInfo;
import com.nike.backstopper.handler.RequestInfoForLogging;
import com.nike.backstopper.handler.UnexpectedMajorExceptionHandlingError;
import com.nike.backstopper.handler.listener.ApiExceptionHandlerListener;
import com.nike.backstopper.handler.riposte.RequestInfoForLoggingRiposteAdapter;
import com.nike.backstopper.model.DefaultErrorContractDTO;
import com.nike.backstopper.model.riposte.ErrorResponseBodyImpl;
import com.nike.backstopper.model.riposte.ErrorResponseInfoImpl;
import com.nike.riposte.server.error.exception.UnexpectedMajorErrorHandlingError;
import com.nike.riposte.server.error.handler.ErrorResponseBody;
import com.nike.riposte.server.error.handler.RiposteErrorHandler;
import com.nike.riposte.server.http.RequestInfo;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class RiposteApiExceptionHandler
extends ApiExceptionHandlerBase<ErrorResponseBody>
implements RiposteErrorHandler {
    @Inject
    public RiposteApiExceptionHandler(@NotNull ProjectApiErrors projectApiErrors, @NotNull List<ApiExceptionHandlerListener> apiExceptionHandlerListenerList, @NotNull ApiExceptionHandlerUtils utils) {
        super(projectApiErrors, apiExceptionHandlerListenerList, utils);
    }

    @Override
    @Nullable
    public com.nike.riposte.server.error.handler.ErrorResponseInfo maybeHandleError(@NotNull Throwable error, @NotNull RequestInfo<?> requestInfo) throws UnexpectedMajorErrorHandlingError {
        try {
            ErrorResponseInfo backstopperErrorResponseInfo = this.maybeHandleException(error, new RequestInfoForLoggingRiposteAdapter(requestInfo));
            if (backstopperErrorResponseInfo == null) {
                return null;
            }
            return new ErrorResponseInfoImpl((ErrorResponseInfo<ErrorResponseBody>)backstopperErrorResponseInfo);
        }
        catch (UnexpectedMajorExceptionHandlingError ex) {
            throw new UnexpectedMajorErrorHandlingError("Wrapping the actual cause", ex);
        }
    }

    @NotNull
    protected ErrorResponseBody prepareFrameworkRepresentation(@NotNull DefaultErrorContractDTO errorContractDTO, int httpStatusCode, @NotNull Collection<ApiError> rawFilteredApiErrors, @NotNull Throwable originalException, @NotNull RequestInfoForLogging request) {
        return new ErrorResponseBodyImpl(errorContractDTO);
    }
}

