/*
 * Decompiled with CFR 0.152.
 */
package com.nike.backstopper.handler.riposte;

import com.nike.backstopper.apierror.ApiError;
import com.nike.backstopper.apierror.projectspecificinfo.ProjectApiErrors;
import com.nike.backstopper.handler.ApiExceptionHandlerUtils;
import com.nike.backstopper.handler.ErrorResponseInfo;
import com.nike.backstopper.handler.RequestInfoForLogging;
import com.nike.backstopper.handler.UnhandledExceptionHandlerBase;
import com.nike.backstopper.handler.riposte.RequestInfoForLoggingRiposteAdapter;
import com.nike.backstopper.model.DefaultErrorContractDTO;
import com.nike.backstopper.model.riposte.ErrorResponseBodyImpl;
import com.nike.backstopper.model.riposte.ErrorResponseInfoImpl;
import com.nike.riposte.server.error.handler.ErrorResponseBody;
import com.nike.riposte.server.error.handler.RiposteUnhandledErrorHandler;
import com.nike.riposte.server.http.RequestInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public class RiposteUnhandledExceptionHandler
extends UnhandledExceptionHandlerBase<ErrorResponseBody>
implements RiposteUnhandledErrorHandler {
    protected final Set<ApiError> singletonGenericServiceError;
    protected final int genericServiceErrorHttpStatusCode;

    @Inject
    public RiposteUnhandledExceptionHandler(@NotNull ProjectApiErrors projectApiErrors, @NotNull ApiExceptionHandlerUtils utils) {
        super(projectApiErrors, utils);
        this.singletonGenericServiceError = Collections.singleton(projectApiErrors.getGenericServiceError());
        this.genericServiceErrorHttpStatusCode = projectApiErrors.getGenericServiceError().getHttpStatusCode();
    }

    @NotNull
    protected ErrorResponseBody prepareFrameworkRepresentation(@NotNull DefaultErrorContractDTO errorContractDTO, int httpStatusCode, @NotNull Collection<ApiError> rawFilteredApiErrors, @NotNull Throwable originalException, @NotNull RequestInfoForLogging request) {
        return new ErrorResponseBodyImpl(errorContractDTO);
    }

    protected ErrorResponseInfo<ErrorResponseBody> generateLastDitchFallbackErrorResponseInfo(@NotNull Throwable ex, @NotNull RequestInfoForLogging request, @NotNull String errorUid, @NotNull Map<String, List<String>> headersForResponseWithErrorUid) {
        return new ErrorResponseInfo(this.genericServiceErrorHttpStatusCode, (Object)new ErrorResponseBodyImpl(errorUid, this.singletonGenericServiceError), headersForResponseWithErrorUid);
    }

    @Override
    @NotNull
    public com.nike.riposte.server.error.handler.ErrorResponseInfo handleError(@NotNull Throwable error, @NotNull RequestInfo<?> requestInfo) {
        ErrorResponseInfo backstopperErrorResponseInfo = this.handleException(error, new RequestInfoForLoggingRiposteAdapter(requestInfo));
        return new ErrorResponseInfoImpl((ErrorResponseInfo<ErrorResponseBody>)backstopperErrorResponseInfo);
    }
}

