/*
 * Decompiled with CFR 0.152.
 */
package com.nike.backstopper.handler.riposte.listener.impl;

import com.nike.backstopper.apierror.ApiError;
import com.nike.backstopper.apierror.ApiErrorBase;
import com.nike.backstopper.apierror.ApiErrorWithMetadata;
import com.nike.backstopper.apierror.SortedApiErrorSet;
import com.nike.backstopper.apierror.projectspecificinfo.ProjectApiErrors;
import com.nike.backstopper.handler.ApiExceptionHandlerUtils;
import com.nike.backstopper.handler.listener.ApiExceptionHandlerListener;
import com.nike.backstopper.handler.listener.ApiExceptionHandlerListenerResult;
import com.nike.fastbreak.exception.CircuitBreakerException;
import com.nike.fastbreak.exception.CircuitBreakerOpenException;
import com.nike.fastbreak.exception.CircuitBreakerTimeoutException;
import com.nike.internal.util.Pair;
import com.nike.internal.util.StringUtils;
import com.nike.riposte.server.error.exception.DownstreamChannelClosedUnexpectedlyException;
import com.nike.riposte.server.error.exception.DownstreamIdleChannelTimeoutException;
import com.nike.riposte.server.error.exception.Forbidden403Exception;
import com.nike.riposte.server.error.exception.HostnameResolutionException;
import com.nike.riposte.server.error.exception.IncompleteHttpCallTimeoutException;
import com.nike.riposte.server.error.exception.InvalidCharsetInContentTypeHeaderException;
import com.nike.riposte.server.error.exception.InvalidHttpRequestException;
import com.nike.riposte.server.error.exception.MethodNotAllowed405Exception;
import com.nike.riposte.server.error.exception.MissingRequiredContentException;
import com.nike.riposte.server.error.exception.MultipleMatchingEndpointsException;
import com.nike.riposte.server.error.exception.NativeIoExceptionWrapper;
import com.nike.riposte.server.error.exception.NonblockingEndpointCompletableFutureTimedOut;
import com.nike.riposte.server.error.exception.PathNotFound404Exception;
import com.nike.riposte.server.error.exception.PathParameterMatchingException;
import com.nike.riposte.server.error.exception.RequestContentDeserializationException;
import com.nike.riposte.server.error.exception.RequestTooBigException;
import com.nike.riposte.server.error.exception.TooManyOpenChannelsException;
import com.nike.riposte.server.error.exception.Unauthorized401Exception;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.TooLongFrameException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BackstopperRiposteFrameworkErrorHandlerListener
implements ApiExceptionHandlerListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    public final ApiError CIRCUIT_BREAKER_GENERIC_API_ERROR;
    @NotNull
    public final ApiError CIRCUIT_BREAKER_OPEN_API_ERROR;
    @NotNull
    public final ApiError CIRCUIT_BREAKER_TIMEOUT_API_ERROR;
    protected final String TOO_LONG_FRAME_LINE_METADATA_MESSAGE = "The request contained a HTTP line that was longer than the maximum allowed";
    protected final String TOO_LONG_FRAME_HEADER_METADATA_MESSAGE = "The combined size of the request's HTTP headers was more than the maximum allowed";
    @NotNull
    protected final ApiError TOO_LONG_FRAME_LINE_API_ERROR_BASE;
    @NotNull
    protected final ApiError TOO_LONG_FRAME_HEADER_API_ERROR_BASE;
    @NotNull
    protected final ProjectApiErrors projectApiErrors;

    @Inject
    public BackstopperRiposteFrameworkErrorHandlerListener(@NotNull ProjectApiErrors projectApiErrors) {
        if (projectApiErrors == null) {
            throw new IllegalArgumentException("ProjectApiErrors cannot be null");
        }
        this.projectApiErrors = projectApiErrors;
        this.CIRCUIT_BREAKER_GENERIC_API_ERROR = new ApiErrorBase(projectApiErrors.getTemporaryServiceProblemApiError(), "CIRCUIT_BREAKER");
        this.CIRCUIT_BREAKER_OPEN_API_ERROR = new ApiErrorBase(projectApiErrors.getTemporaryServiceProblemApiError(), "CIRCUIT_BREAKER_OPEN");
        this.CIRCUIT_BREAKER_TIMEOUT_API_ERROR = new ApiErrorBase(projectApiErrors.getTemporaryServiceProblemApiError(), "CIRCUIT_BREAKER_TIMEOUT");
        ApiError malformedReqError = projectApiErrors.getMalformedRequestApiError();
        this.TOO_LONG_FRAME_LINE_API_ERROR_BASE = new ApiErrorWithMetadata((ApiError)new ApiErrorBase(malformedReqError, "TOO_LONG_HTTP_LINE"), new Pair[]{Pair.of((Object)"cause", (Object)"The request contained a HTTP line that was longer than the maximum allowed")});
        this.TOO_LONG_FRAME_HEADER_API_ERROR_BASE = new ApiErrorWithMetadata((ApiError)new ApiErrorBase("TOO_LONG_HEADERS", malformedReqError.getErrorCode(), malformedReqError.getMessage(), 431, malformedReqError.getMetadata()), new Pair[]{Pair.of((Object)"cause", (Object)"The combined size of the request's HTTP headers was more than the maximum allowed")});
    }

    public ApiExceptionHandlerListenerResult shouldHandleException(Throwable ex) {
        if (ex instanceof CircuitBreakerException) {
            CircuitBreakerException cbe = (CircuitBreakerException)ex;
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError(this.getApiErrorForCircuitBreakerException(cbe)), Collections.singletonList(Pair.of((Object)"circuit_breaker_id", (Object)String.valueOf(cbe.circuitBreakerId))));
        }
        if (ex instanceof NonblockingEndpointCompletableFutureTimedOut) {
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError(this.projectApiErrors.getTemporaryServiceProblemApiError()), Collections.singletonList(Pair.of((Object)"completable_future_timeout_value_millis", (Object)String.valueOf(((NonblockingEndpointCompletableFutureTimedOut)ex).timeoutValueMillis))));
        }
        if (ex instanceof DownstreamIdleChannelTimeoutException) {
            DownstreamIdleChannelTimeoutException idleEx = (DownstreamIdleChannelTimeoutException)ex;
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError(this.projectApiErrors.getTemporaryServiceProblemApiError()), Arrays.asList(Pair.of((Object)"async_downstream_call_timeout_value_millis", (Object)String.valueOf(idleEx.timeoutValueMillis)), Pair.of((Object)"idle_channel_id", (Object)String.valueOf(idleEx.channelId))));
        }
        if (ex instanceof DownstreamChannelClosedUnexpectedlyException) {
            DownstreamChannelClosedUnexpectedlyException dsClosedEx = (DownstreamChannelClosedUnexpectedlyException)ex;
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError(this.projectApiErrors.getTemporaryServiceProblemApiError()), Collections.singletonList(Pair.of((Object)"closed_channel_id", (Object)String.valueOf(dsClosedEx.channelId))));
        }
        if (ex instanceof DecoderException) {
            ApiError errorToUse = ex instanceof TooLongFrameException ? this.generateTooLongFrameApiError((TooLongFrameException)ex) : this.projectApiErrors.getMalformedRequestApiError();
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError(errorToUse), this.withBaseExceptionMessage(ex, Pair.of((Object)"decoder_exception", (Object)"true")));
        }
        if (ex instanceof RequestTooBigException) {
            ApiErrorWithMetadata errorToUse = new ApiErrorWithMetadata(this.projectApiErrors.getMalformedRequestApiError(), new Pair[]{Pair.of((Object)"cause", (Object)"The request exceeded the maximum payload size allowed")});
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError((ApiError)errorToUse), this.withBaseExceptionMessage(ex, Pair.of((Object)"decoder_exception", (Object)"true")));
        }
        if (ex instanceof HostnameResolutionException) {
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError(this.projectApiErrors.getTemporaryServiceProblemApiError()), this.withBaseExceptionMessage(ex, new Pair[0]));
        }
        if (ex instanceof NativeIoExceptionWrapper) {
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError(this.projectApiErrors.getTemporaryServiceProblemApiError()), Collections.singletonList(this.causeDetailsForLogs(ex)));
        }
        if (ex instanceof RequestContentDeserializationException) {
            RequestContentDeserializationException theEx = (RequestContentDeserializationException)ex;
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError(this.projectApiErrors.getMalformedRequestApiError()), Arrays.asList(Pair.of((Object)"method", (Object)theEx.httpMethod), Pair.of((Object)"request_path", (Object)theEx.requestPath), Pair.of((Object)"desired_object_type", (Object)theEx.desiredObjectType.getType().toString()), this.causeDetailsForLogs(ex)));
        }
        if (ex instanceof PathNotFound404Exception) {
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError(this.projectApiErrors.getNotFoundApiError()));
        }
        if (ex instanceof MethodNotAllowed405Exception) {
            MethodNotAllowed405Exception theEx = (MethodNotAllowed405Exception)ex;
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError(this.projectApiErrors.getMethodNotAllowedApiError()), Arrays.asList(Pair.of((Object)"incoming_request_path", (Object)theEx.requestPath), Pair.of((Object)"incoming_request_method", (Object)theEx.requestMethod)));
        }
        if (ex instanceof Unauthorized401Exception) {
            Unauthorized401Exception theEx = (Unauthorized401Exception)ex;
            List<Pair<String, String>> extraDetails = this.withBaseExceptionMessage(ex, Pair.of((Object)"incoming_request_path", (Object)theEx.requestPath));
            extraDetails.addAll(theEx.extraDetailsForLogging);
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError(this.projectApiErrors.getUnauthorizedApiError()), extraDetails);
        }
        if (ex instanceof Forbidden403Exception) {
            Forbidden403Exception theEx = (Forbidden403Exception)ex;
            List<Pair<String, String>> extraDetails = this.withBaseExceptionMessage(ex, Pair.of((Object)"incoming_request_path", (Object)theEx.requestPath));
            extraDetails.addAll(theEx.extraDetailsForLogging);
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError(this.projectApiErrors.getForbiddenApiError()), extraDetails);
        }
        if (ex instanceof MissingRequiredContentException) {
            MissingRequiredContentException theEx = (MissingRequiredContentException)ex;
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError(this.projectApiErrors.getMissingExpectedContentApiError()), Arrays.asList(Pair.of((Object)"incoming_request_path", (Object)theEx.path), Pair.of((Object)"incoming_request_method", (Object)theEx.method), Pair.of((Object)"endpoint_class_name", (Object)theEx.endpointClassName)));
        }
        if (ex instanceof MultipleMatchingEndpointsException) {
            MultipleMatchingEndpointsException theEx = (MultipleMatchingEndpointsException)ex;
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError(this.projectApiErrors.getGenericServiceError()), Arrays.asList(Pair.of((Object)"incoming_request_path", (Object)theEx.requestPath), Pair.of((Object)"incoming_request_method", (Object)theEx.requestMethod), Pair.of((Object)"matching_endpoints", (Object)StringUtils.join(theEx.matchingEndpointsDetails, (String)","))));
        }
        if (ex instanceof PathParameterMatchingException) {
            PathParameterMatchingException theEx = (PathParameterMatchingException)ex;
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError(this.projectApiErrors.getGenericServiceError()), Arrays.asList(Pair.of((Object)"path_template", (Object)theEx.pathTemplate), Pair.of((Object)"non_matching_uri_path", (Object)theEx.nonMatchingUriPath)));
        }
        if (ex instanceof InvalidCharsetInContentTypeHeaderException) {
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError(this.projectApiErrors.getUnsupportedMediaTypeApiError()), Collections.singletonList(Pair.of((Object)"invalid_content_type_header", (Object)((InvalidCharsetInContentTypeHeaderException)ex).invalidContentTypeHeader)));
        }
        if (ex instanceof TooManyOpenChannelsException) {
            TooManyOpenChannelsException theEx = (TooManyOpenChannelsException)ex;
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError(this.projectApiErrors.getTemporaryServiceProblemApiError()), Arrays.asList(Pair.of((Object)"num_current_open_channels", (Object)String.valueOf(theEx.actualOpenChannelsCount)), Pair.of((Object)"max_open_channels_limit", (Object)String.valueOf(theEx.maxOpenChannelsLimit))));
        }
        if (ex instanceof IncompleteHttpCallTimeoutException) {
            IncompleteHttpCallTimeoutException theEx = (IncompleteHttpCallTimeoutException)ex;
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError((ApiError)new ApiErrorWithMetadata(this.projectApiErrors.getMalformedRequestApiError(), new Pair[]{Pair.of((Object)"cause", (Object)"Unfinished/invalid HTTP request")})), this.withBaseExceptionMessage(ex, Pair.of((Object)"incomplete_http_call_timeout_millis", (Object)String.valueOf(theEx.timeoutMillis))));
        }
        if (ex instanceof InvalidHttpRequestException) {
            InvalidHttpRequestException theEx = (InvalidHttpRequestException)ex;
            Throwable cause = theEx.getCause();
            ApiErrorWithMetadata apiErrorToUse = cause instanceof TooLongFrameException ? this.generateTooLongFrameApiError((TooLongFrameException)cause) : new ApiErrorWithMetadata(this.projectApiErrors.getMalformedRequestApiError(), new Pair[]{Pair.of((Object)"cause", (Object)"Invalid HTTP request")});
            return ApiExceptionHandlerListenerResult.handleResponse((SortedApiErrorSet)this.singletonError((ApiError)apiErrorToUse), this.withBaseExceptionMessage(ex, this.causeDetailsForLogs(theEx)));
        }
        return ApiExceptionHandlerListenerResult.ignoreResponse();
    }

    @SafeVarargs
    @NotNull
    protected final List<Pair<String, String>> withBaseExceptionMessage(@NotNull Throwable ex, Pair<String, String> ... extraLogMessages) {
        ArrayList<Pair<String, String>> logPairs = new ArrayList<Pair<String, String>>();
        ApiExceptionHandlerUtils.DEFAULT_IMPL.addBaseExceptionMessageToExtraDetailsForLogging(ex, logPairs);
        if (extraLogMessages != null) {
            logPairs.addAll(Arrays.asList(extraLogMessages));
        }
        return logPairs;
    }

    @NotNull
    protected final Pair<String, String> causeDetailsForLogs(@NotNull Throwable orig) {
        Throwable cause = orig.getCause();
        String causeDetails = cause == null ? "NO_CAUSE" : cause.toString();
        return Pair.of((Object)"exception_cause_details", (Object)ApiExceptionHandlerUtils.DEFAULT_IMPL.quotesToApostrophes(causeDetails));
    }

    @NotNull
    protected ApiError generateTooLongFrameApiError(@NotNull TooLongFrameException ex) {
        String exMessage = String.valueOf(ex.getMessage());
        Integer tooLongFrameMaxSize = this.extractTooLongFrameMaxSizeFromExceptionMessage(ex);
        HashMap<String, Integer> maxSizeMetadata = new HashMap<String, Integer>();
        if (tooLongFrameMaxSize != null) {
            maxSizeMetadata.put("max_length_allowed", tooLongFrameMaxSize);
        }
        if (exMessage.startsWith("HTTP header is larger than")) {
            return new ApiErrorWithMetadata(this.TOO_LONG_FRAME_HEADER_API_ERROR_BASE, maxSizeMetadata);
        }
        return new ApiErrorWithMetadata(this.TOO_LONG_FRAME_LINE_API_ERROR_BASE, maxSizeMetadata);
    }

    @Nullable
    private Integer extractTooLongFrameMaxSizeFromExceptionMessage(@NotNull TooLongFrameException ex) {
        String exMessage = ex.getMessage();
        if (exMessage == null || !exMessage.endsWith(" bytes.")) {
            return null;
        }
        try {
            String[] messageWords = exMessage.split(" ");
            String maxSizeWord = messageWords[messageWords.length - 2];
            return Integer.parseInt(maxSizeWord);
        }
        catch (Throwable t) {
            this.logger.debug("Unable to parse max size from TooLongFrameException. ex_message={}", (Object)exMessage, (Object)t);
            return null;
        }
    }

    @NotNull
    protected SortedApiErrorSet singletonError(@NotNull ApiError apiError) {
        return new SortedApiErrorSet(Collections.singleton(apiError));
    }

    @NotNull
    protected ApiError getApiErrorForCircuitBreakerException(@NotNull CircuitBreakerException cbe) {
        if (cbe instanceof CircuitBreakerOpenException) {
            return this.CIRCUIT_BREAKER_OPEN_API_ERROR;
        }
        if (cbe instanceof CircuitBreakerTimeoutException) {
            return this.CIRCUIT_BREAKER_TIMEOUT_API_ERROR;
        }
        return this.CIRCUIT_BREAKER_GENERIC_API_ERROR;
    }
}

