/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.server.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nike.backstopper.apierror.ApiError;
import com.nike.backstopper.apierror.projectspecificinfo.ProjectApiErrors;
import com.nike.backstopper.apierror.projectspecificinfo.ProjectSpecificErrorCodeRange;
import com.nike.backstopper.apierror.sample.SampleProjectApiErrorsBase;
import com.nike.backstopper.handler.ApiExceptionHandlerUtils;
import com.nike.backstopper.handler.riposte.config.BackstopperRiposteConfigHelper;
import com.nike.riposte.metrics.MetricsListener;
import com.nike.riposte.server.config.AppInfo;
import com.nike.riposte.server.config.distributedtracing.DistributedTracingConfig;
import com.nike.riposte.server.error.handler.ErrorResponseBodySerializer;
import com.nike.riposte.server.error.handler.RiposteErrorHandler;
import com.nike.riposte.server.error.handler.RiposteUnhandledErrorHandler;
import com.nike.riposte.server.error.validation.RequestSecurityValidator;
import com.nike.riposte.server.error.validation.RequestValidator;
import com.nike.riposte.server.hooks.PipelineCreateHook;
import com.nike.riposte.server.hooks.PostServerStartupHook;
import com.nike.riposte.server.hooks.PreServerStartupHook;
import com.nike.riposte.server.hooks.ServerShutdownHook;
import com.nike.riposte.server.http.Endpoint;
import com.nike.riposte.server.http.filter.RequestAndResponseFilter;
import com.nike.riposte.server.logging.AccessLogger;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ServerConfig {
    @NotNull
    public @NotNull Collection<@NotNull Endpoint<?>> appEndpoints();

    default public @Nullable List<@NotNull RequestAndResponseFilter> requestAndResponseFilters() {
        return null;
    }

    @NotNull
    default public RiposteErrorHandler riposteErrorHandler() {
        SampleProjectApiErrorsBase projectApiErrors = new SampleProjectApiErrorsBase(){

            protected List<ApiError> getProjectSpecificApiErrors() {
                return null;
            }

            protected ProjectSpecificErrorCodeRange getProjectSpecificErrorCodeRange() {
                return null;
            }
        };
        return BackstopperRiposteConfigHelper.defaultErrorHandler((ProjectApiErrors)projectApiErrors, ApiExceptionHandlerUtils.DEFAULT_IMPL);
    }

    @NotNull
    default public RiposteUnhandledErrorHandler riposteUnhandledErrorHandler() {
        SampleProjectApiErrorsBase projectApiErrors = new SampleProjectApiErrorsBase(){

            protected List<ApiError> getProjectSpecificApiErrors() {
                return null;
            }

            protected ProjectSpecificErrorCodeRange getProjectSpecificErrorCodeRange() {
                return null;
            }
        };
        return BackstopperRiposteConfigHelper.defaultUnhandledErrorHandler((ProjectApiErrors)projectApiErrors, ApiExceptionHandlerUtils.DEFAULT_IMPL);
    }

    @Nullable
    default public ErrorResponseBodySerializer errorResponseBodySerializer() {
        return null;
    }

    @Nullable
    default public SslContext createSslContext() throws SSLException, CertificateException {
        SelfSignedCertificate ssc = new SelfSignedCertificate("localhost");
        return SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
    }

    @Nullable
    default public RequestValidator requestContentValidationService() {
        return null;
    }

    @Nullable
    default public ObjectMapper defaultRequestContentDeserializer() {
        return null;
    }

    @Nullable
    default public ObjectMapper defaultResponseContentSerializer() {
        return null;
    }

    default public boolean isDebugActionsEnabled() {
        return false;
    }

    default public boolean isDebugChannelLifecycleLoggingEnabled() {
        return false;
    }

    default public int endpointsPort() {
        return 8080;
    }

    default public int endpointsSslPort() {
        return 8443;
    }

    default public boolean isEndpointsUseSsl() {
        return false;
    }

    default public int numBossThreads() {
        return 1;
    }

    @Nullable
    default public ThreadFactory bossThreadFactory() {
        return null;
    }

    default public int numWorkerThreads() {
        return 0;
    }

    @Nullable
    default public ThreadFactory workerThreadFactory() {
        return null;
    }

    default public long defaultCompletableFutureTimeoutInMillisForNonblockingEndpoints() {
        return 58000L;
    }

    default public long workerChannelIdleTimeoutMillis() {
        return 5000L;
    }

    default public long proxyRouterConnectTimeoutMillis() {
        return 10000L;
    }

    default public long incompleteHttpCallTimeoutMillis() {
        return 5000L;
    }

    default public int maxOpenIncomingServerChannels() {
        return 20000;
    }

    default public int maxRequestSizeInBytes() {
        return 0;
    }

    default public int responseCompressionThresholdBytes() {
        return 500;
    }

    @Nullable
    default public Executor longRunningTaskExecutor() {
        return null;
    }

    @Nullable
    default public MetricsListener metricsListener() {
        return null;
    }

    @Nullable
    default public AccessLogger accessLogger() {
        return null;
    }

    @Nullable
    default public @Nullable CompletableFuture<@Nullable AppInfo> appInfo() {
        return null;
    }

    default public @Nullable List<@NotNull PostServerStartupHook> postServerStartupHooks() {
        return null;
    }

    default public @Nullable List<@NotNull PreServerStartupHook> preServerStartupHooks() {
        return null;
    }

    default public @Nullable List<@NotNull ServerShutdownHook> serverShutdownHooks() {
        return null;
    }

    default public @Nullable List<@NotNull PipelineCreateHook> pipelineCreateHooks() {
        return null;
    }

    @Nullable
    default public ChannelInitializer<SocketChannel> customChannelInitializer() {
        return null;
    }

    @Nullable
    default public RequestSecurityValidator requestSecurityValidator() {
        return null;
    }

    default public @Nullable List<@NotNull String> userIdHeaderKeys() {
        return null;
    }

    @Nullable
    default public HttpRequestDecoderConfig httpRequestDecoderConfig() {
        return null;
    }

    @Nullable
    default public DistributedTracingConfig<?> distributedTracingConfig() {
        return null;
    }

    public static interface HttpRequestDecoderConfig {
        @NotNull
        public static final HttpRequestDecoderConfig DEFAULT_IMPL = new HttpRequestDecoderConfig(){};

        default public int maxInitialLineLength() {
            return 4096;
        }

        default public int maxHeaderSize() {
            return 8192;
        }

        default public int maxChunkSize() {
            return 8192;
        }
    }
}

