/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.server.config.distributedtracing;

import com.nike.riposte.server.config.distributedtracing.SpanNamingAndTaggingStrategy;
import com.nike.riposte.server.http.RequestInfo;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProxyRouterSpanNamingAndTaggingStrategy<S>
extends SpanNamingAndTaggingStrategy<HttpRequest, HttpResponse, S> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String SPAN_NAME_FOR_OUTBOUND_PROXY_CALL_REQ_ATTR_KEY = "SpanNameForOutboundProxyCall";

    public static void setSpanNameOverrideForOutboundProxyRouterEndpointCall(String spanName, RequestInfo<?> request) {
        request.addRequestAttribute(SPAN_NAME_FOR_OUTBOUND_PROXY_CALL_REQ_ATTR_KEY, spanName);
    }

    public boolean shouldAddConnStartAnnotation() {
        return true;
    }

    @NotNull
    public String connStartAnnotationName() {
        return "conn.start";
    }

    public boolean shouldAddConnFinishAnnotation() {
        return true;
    }

    @NotNull
    public String connFinishAnnotationName() {
        return "conn.finish";
    }

    @Nullable
    public final String getInitialSpanNameOverride(@NotNull HttpRequest downstreamRequest, @NotNull RequestInfo<?> overallRequest, @Nullable String initialSpanName, @Nullable String overallRequestSpanName) {
        if (downstreamRequest == null || overallRequest == null) {
            return null;
        }
        try {
            return this.doGetInitialSpanNameOverride(downstreamRequest, overallRequest, initialSpanName, overallRequestSpanName);
        }
        catch (Throwable t) {
            this.logger.error("An unexpected error occurred while getting the initial span name override. The error will be swallowed to avoid doing any damage and null will be returned, but your span name may not be what you expect. This error should be fixed.", t);
            return null;
        }
    }

    @Nullable
    protected String doGetInitialSpanNameOverride(@NotNull HttpRequest downstreamRequest, @NotNull RequestInfo<?> overallRequest, @Nullable String initialSpanName, @Nullable String overallRequestSpanName) {
        Object requestInfoAttrOverrideValue = overallRequest.getRequestAttributes().get(SPAN_NAME_FOR_OUTBOUND_PROXY_CALL_REQ_ATTR_KEY);
        if (requestInfoAttrOverrideValue != null) {
            return requestInfoAttrOverrideValue.toString();
        }
        String httpMethodStr = downstreamRequest.method().name();
        if (initialSpanName != null && (initialSpanName.equals("proxy-" + httpMethodStr) || initialSpanName.equals(httpMethodStr)) && overallRequestSpanName != null) {
            return "proxy-" + overallRequestSpanName;
        }
        return null;
    }
}

