/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.server.config.distributedtracing;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpanNamingAndTaggingStrategy<REQ, RES, S> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Nullable
    public final String getInitialSpanName(@NotNull REQ request) {
        if (request == null) {
            return null;
        }
        try {
            return this.doGetInitialSpanName(request);
        }
        catch (Throwable t) {
            this.logger.error("An unexpected error occurred while getting the initial span name. The error will be swallowed to avoid doing any damage and null will be returned, but your span name may not be what you expect. This error should be fixed.", t);
            return null;
        }
    }

    @Nullable
    protected abstract String doGetInitialSpanName(@NotNull REQ var1);

    public final void changeSpanName(@NotNull S span, @NotNull String newName) {
        if (span == null || newName == null) {
            return;
        }
        try {
            this.doChangeSpanName(span, newName);
        }
        catch (Throwable t) {
            this.logger.error("An unexpected error occurred while changing the span name. The error will be swallowed to avoid doing any damage, but your span name may not be what you expect. This error should be fixed.", t);
        }
    }

    protected abstract void doChangeSpanName(@NotNull S var1, @NotNull String var2);

    public final void handleRequestTagging(@NotNull S span, @NotNull REQ request) {
        if (span == null || request == null) {
            return;
        }
        try {
            this.doHandleRequestTagging(span, request);
        }
        catch (Throwable t) {
            this.logger.error("An unexpected error occurred while handling request tagging. The error will be swallowed to avoid doing any damage, but your span may be missing some expected tags. This error should be fixed.", t);
        }
    }

    protected abstract void doHandleRequestTagging(@NotNull S var1, @NotNull REQ var2);

    public final void handleResponseTaggingAndFinalSpanName(@NotNull S span, @Nullable REQ request, @Nullable RES response, @Nullable Throwable error) {
        if (span == null) {
            return;
        }
        try {
            this.doHandleResponseTaggingAndFinalSpanName(span, request, response, error);
        }
        catch (Throwable t) {
            this.logger.error("An unexpected error occurred while handling response tagging and final span name. The error will be swallowed to avoid doing any damage, but your span may be missing some expected tags and/or the span name might not be what you expect. This error should be fixed.", t);
        }
    }

    protected abstract void doHandleResponseTaggingAndFinalSpanName(@NotNull S var1, @Nullable REQ var2, @Nullable RES var3, @Nullable Throwable var4);

    public boolean shouldAddWireReceiveStartAnnotation() {
        return true;
    }

    @NotNull
    public String wireReceiveStartAnnotationName() {
        return "wr.start";
    }

    public boolean shouldAddWireReceiveFinishAnnotation() {
        return true;
    }

    @NotNull
    public String wireReceiveFinishAnnotationName() {
        return "wr.finish";
    }

    public boolean shouldAddWireSendStartAnnotation() {
        return true;
    }

    @NotNull
    public String wireSendStartAnnotationName() {
        return "ws.start";
    }

    public boolean shouldAddWireSendFinishAnnotation() {
        return true;
    }

    @NotNull
    public String wireSendFinishAnnotationName() {
        return "ws.finish";
    }

    public boolean shouldAddErrorAnnotationForCaughtException(@Nullable RES response, @NotNull Throwable error) {
        return true;
    }

    @NotNull
    public String errorAnnotationName(@Nullable RES response, @NotNull Throwable error) {
        return "error";
    }
}

