/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.server.config.impl;

import com.nike.riposte.server.config.AppInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppInfoImpl
implements AppInfo {
    private static final Logger logger = LoggerFactory.getLogger(AppInfoImpl.class);
    private static LocalHostnameGetter LOCAL_HOSTNAME_GETTER = new LocalHostnameGetter();
    @NotNull
    public final String appId;
    @NotNull
    public final String environment;
    @NotNull
    public final String dataCenter;
    @NotNull
    public final String instanceId;

    protected AppInfoImpl() {
        this("unknown", "unknown", "unknown", "unknown");
    }

    public AppInfoImpl(@NotNull String appId, @NotNull String environment, @Nullable String dataCenter, @Nullable String instanceId) {
        if (appId == null) {
            appId = "unknown";
        }
        if (environment == null) {
            environment = "unknown";
        }
        if (dataCenter == null) {
            dataCenter = "unknown";
        }
        if (instanceId == null) {
            instanceId = "unknown";
        }
        this.appId = appId;
        this.environment = environment;
        this.dataCenter = dataCenter;
        this.instanceId = instanceId;
    }

    @Override
    @NotNull
    public String appId() {
        return this.appId;
    }

    @Override
    @NotNull
    public String environment() {
        return this.environment;
    }

    @Override
    @NotNull
    public String dataCenter() {
        return this.dataCenter;
    }

    @Override
    @NotNull
    public String instanceId() {
        return this.instanceId;
    }

    @NotNull
    public static AppInfoImpl createLocalInstance() {
        String appId = AppInfoImpl.detectAppId();
        if (appId == null) {
            throw new IllegalStateException("Unable to autodetect app ID. Please call createLocalInstance(String) instead and pass the app ID manually");
        }
        return AppInfoImpl.createLocalInstance(appId);
    }

    protected static String getLocalHostName() throws UnknownHostException {
        return LOCAL_HOSTNAME_GETTER.getLocalHostname();
    }

    @NotNull
    public static AppInfoImpl createLocalInstance(@NotNull String appId) {
        String environment = "local";
        String datacenter = "local";
        String instanceId = null;
        try {
            instanceId = AppInfoImpl.getLocalHostName();
        }
        catch (UnknownHostException e) {
            logger.error("Unable to extract localhost address", (Throwable)e);
        }
        if (instanceId == null) {
            instanceId = "unknown";
        }
        return new AppInfoImpl(appId, environment, datacenter, instanceId);
    }

    @Nullable
    public static String detectAppId() {
        String appId = System.getProperty("@appId");
        if (appId != null) {
            return appId;
        }
        appId = System.getProperty("archaius.deployment.applicationId");
        if (appId != null) {
            return appId;
        }
        appId = System.getProperty("eureka.name");
        if (appId != null) {
            return appId;
        }
        return null;
    }

    @Nullable
    public static String detectEnvironment() {
        String environment = System.getProperty("@environment");
        if (environment != null) {
            return environment;
        }
        environment = System.getProperty("archaius.deployment.environment");
        if (environment != null) {
            return environment;
        }
        return null;
    }

    protected static class LocalHostnameGetter {
        protected LocalHostnameGetter() {
        }

        public String getLocalHostname() throws UnknownHostException {
            return InetAddress.getLocalHost().getHostName();
        }
    }
}

