/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.server.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nike.riposte.server.http.RequestInfo;
import com.nike.riposte.util.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Endpoint<I> {
    @NotNull
    public Matcher requestMatcher();

    @Nullable
    default public Long completableFutureTimeoutOverrideMillis() {
        return null;
    }

    @Nullable
    default public TypeReference<I> requestContentType() {
        return null;
    }

    default public boolean isValidateRequestContent(@NotNull RequestInfo<?> request) {
        return true;
    }

    default public boolean isRequireRequestContent() {
        TypeReference<I> requestContentType = this.requestContentType();
        return requestContentType != null && !Void.class.equals((Object)requestContentType.getType());
    }

    default public boolean shouldValidateAsynchronously(@NotNull RequestInfo<?> request) {
        return request.getRawContentLengthInBytes() > 50000;
    }

    @Nullable
    default public Class<?>[] validationGroups(@NotNull RequestInfo<?> request) {
        return null;
    }

    @Nullable
    default public ObjectMapper customRequestContentDeserializer(@NotNull RequestInfo<?> request) {
        return null;
    }

    @Nullable
    default public ObjectMapper customResponseContentSerializer(@NotNull RequestInfo<?> request) {
        return null;
    }

    @Nullable
    default public Integer maxRequestSizeInBytesOverride() {
        return null;
    }

    default public boolean isDecompressRequestPayloadAllowed(@NotNull RequestInfo<?> request) {
        return true;
    }
}

