/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.server.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RequestInfo<T> {
    public static final String NONE_OR_UNKNOWN_TAG = "none_or_unknown";
    public static final Charset DEFAULT_CONTENT_CHARSET = CharsetUtil.UTF_8;

    @NotNull
    public String getUri();

    @NotNull
    public String getPath();

    @Nullable
    public HttpMethod getMethod();

    @NotNull
    public HttpHeaders getHeaders();

    @NotNull
    public HttpHeaders getTrailingHeaders();

    @NotNull
    public QueryStringDecoder getQueryParams();

    @Nullable
    default public String getQueryParamSingle(@NotNull String key) {
        if (this.getQueryParams() == null || this.getQueryParams().parameters() == null) {
            return null;
        }
        List paramList = (List)this.getQueryParams().parameters().get(key);
        if (paramList == null || paramList.size() == 0) {
            return null;
        }
        return (String)paramList.get(0);
    }

    @NotNull
    public Map<String, String> getPathParams();

    @Nullable
    default public String getPathParam(@NotNull String key) {
        return this.getPathParams().get(key);
    }

    @NotNull
    public RequestInfo<T> setPathParamsBasedOnPathTemplate(@NotNull String var1);

    public int getRawContentLengthInBytes();

    @Nullable
    public byte[] getRawContentBytes();

    @Nullable
    public String getRawContent();

    @Nullable
    public T getContent();

    public boolean isMultipartRequest();

    @Nullable
    public List<InterfaceHttpData> getMultipartParts();

    @NotNull
    public RequestInfo<T> setupContentDeserializer(@NotNull ObjectMapper var1, @NotNull TypeReference<T> var2);

    public boolean isContentDeserializerSetup();

    @NotNull
    public Set<Cookie> getCookies();

    @NotNull
    public Charset getContentCharset();

    @Nullable
    public HttpVersion getProtocolVersion();

    public boolean isKeepAliveRequested();

    public int addContentChunk(@NotNull HttpContent var1);

    public boolean isCompleteRequestWithAllChunks();

    public void addRequestAttribute(@NotNull String var1, @NotNull Object var2);

    @NotNull
    public Map<String, Object> getRequestAttributes();

    public void releaseAllResources();

    public void releaseContentChunks();

    public void releaseMultipartData();

    @NotNull
    public String getPathTemplate();
}

