/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.server.http;

import com.nike.riposte.server.http.impl.ChunkedResponseInfo;
import com.nike.riposte.server.http.impl.FullResponseInfo;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ResponseInfo<T> {
    public static final String DEFAULT_MIME_TYPE = "application/json";
    public static final Charset DEFAULT_CONTENT_ENCODING = CharsetUtil.UTF_8;

    @Nullable
    public Integer getHttpStatusCode();

    default public int getHttpStatusCodeWithDefault(int defaultIfNull) {
        Integer actual = this.getHttpStatusCode();
        if (actual == null) {
            return defaultIfNull;
        }
        return actual;
    }

    public void setHttpStatusCode(@Nullable Integer var1);

    @NotNull
    public HttpHeaders getHeaders();

    public boolean isChunkedResponse();

    @Nullable
    public T getContentForFullResponse();

    public void setContentForFullResponse(@Nullable T var1);

    @Nullable
    public String getDesiredContentWriterMimeType();

    public void setDesiredContentWriterMimeType(@Nullable String var1);

    @Nullable
    public Charset getDesiredContentWriterEncoding();

    public void setDesiredContentWriterEncoding(@Nullable Charset var1);

    @Nullable
    public Set<Cookie> getCookies();

    public void setCookies(@Nullable Set<Cookie> var1);

    public boolean isPreventCompressedOutput();

    public void setPreventCompressedOutput(boolean var1);

    @Nullable
    public Long getUncompressedRawContentLength();

    public void setUncompressedRawContentLength(@Nullable Long var1);

    @Nullable
    public Long getFinalContentLength();

    public void setFinalContentLength(@Nullable Long var1);

    public boolean isResponseSendingStarted();

    public void setResponseSendingStarted(boolean var1);

    public boolean isResponseSendingLastChunkSent();

    public void setResponseSendingLastChunkSent(boolean var1);

    public boolean isForceConnectionCloseAfterResponseSent();

    public void setForceConnectionCloseAfterResponseSent(boolean var1);

    @NotNull
    public static <T> FullResponseInfo.FullResponseInfoBuilder<T> newBuilder() {
        return new FullResponseInfo.FullResponseInfoBuilder();
    }

    @NotNull
    public static <T> FullResponseInfo.FullResponseInfoBuilder<T> newBuilder(@Nullable T content) {
        return new FullResponseInfo.FullResponseInfoBuilder<T>().withContentForFullResponse(content);
    }

    @NotNull
    public static ChunkedResponseInfo.ChunkedResponseInfoBuilder newChunkedResponseBuilder() {
        return new ChunkedResponseInfo.ChunkedResponseInfoBuilder();
    }
}

