/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.server.http.header;

import com.nike.internal.util.Pair;
import com.nike.riposte.server.http.header.AcceptHeader;
import com.nike.riposte.server.http.header.accept.MediaRange;
import com.nike.riposte.server.http.header.accept.MediaRangeSubType;
import com.nike.riposte.server.http.header.accept.MediaRangeType;
import com.nike.riposte.server.http.header.accept.MimeMediaRangeSubType;
import com.nike.riposte.server.http.header.accept.MimeMediaRangeType;
import com.nike.riposte.server.http.mimetype.MimeTypeParser;
import com.nike.riposte.util.text.parsercombinator.Parser;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class AcceptHeaderParser {
    public static Parser<Float> qualityFactorParser = Parser.Parsers.skip(Parser.Parsers.regex("\\s*;?\\s*q\\s*=\\s*")).thenParse(Parser.Parsers.filter(Parser.Parsers.floatNumber(), q -> q.floatValue() > 0.0f && q.floatValue() <= 1.0f));
    public static Parser<Pair<String, String>> mediaRangeParamaterParser = Parser.Parsers.filter(MimeTypeParser.token, t -> !"q".equals(t)).thenSkip(Parser.Parsers.regex("\\s*q?\\s*=\\s*")).thenParse(MimeTypeParser.token);
    public static final Parser<Map<String, String>> mediaRangeParamatersParser = Parser.Parsers.skip(Parser.Parsers.regex("\\s*;?\\s*")).thenParse(Parser.Parsers.zeroOrMore(mediaRangeParamaterParser, MimeTypeParser.semicolon)).map(list -> list.stream().collect(Collectors.toMap(Pair::getLeft, Pair::getRight)));
    public static final Parser<Map<String, String>> acceptParamatersParser = Parser.Parsers.skip(Parser.Parsers.regex("\\s*;?\\s*")).thenParse(Parser.Parsers.zeroOrMore(MimeTypeParser.parameterParser, MimeTypeParser.semicolon)).map(list -> list.stream().collect(Collectors.toMap(Pair::getLeft, Pair::getRight)));
    public static final Parser<MediaRangeType> mediaRangeTypeParser = Parser.Parsers.oneOf(Parser.Parsers.string("*").map(s -> MediaRange.WILDCARD_TYPE), MimeTypeParser.typeParser.map(MimeMediaRangeType::new));
    public static final Parser<MediaRangeSubType> mediaRangeSubTypeParser = Parser.Parsers.oneOf(Parser.Parsers.string("*").map(s -> MediaRange.WILDCARD_SUBTYPE), MimeTypeParser.subTypeParser.map(MimeMediaRangeSubType::new));
    public static final Parser<MediaRange> mediaRangeParser = mediaRangeTypeParser.thenSkip(Parser.Parsers.string("/")).thenParse(mediaRangeSubTypeParser).thenParse(mediaRangeParamatersParser).thenParse(qualityFactorParser.optional()).thenParse(acceptParamatersParser).filter(Parser.Apply.test((type, subType, mediaRangeParamaters, qualityFactor, acceptParamaters) -> MediaRange.WILDCARD_TYPE.equals(type) ? MediaRange.WILDCARD_SUBTYPE.equals(subType) : true)).map(Parser.Apply.match((type, subType, mediaRangeParamaters, qualityFactor, acceptParamaters) -> new MediaRange((MediaRangeType)type, (MediaRangeSubType)subType, qualityFactor.orElse(Float.valueOf(1.0f)), (Map<String, String>)mediaRangeParamaters, (Map<String, String>)acceptParamaters)));
    public static final Parser<List<MediaRange>> mediaRangesParser = Parser.Parsers.zeroOrMore(mediaRangeParser, Parser.Parsers.regex("\\s*,\\s*"));

    public static Optional<AcceptHeader> parse(String acceptHeaderString) {
        return mediaRangesParser.tryParse(acceptHeaderString).map(AcceptHeader::new);
    }
}

