/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.server.http.header.accept;

import com.nike.riposte.server.http.header.accept.MediaRangeSubType;
import com.nike.riposte.server.http.header.accept.MediaRangeType;
import com.nike.riposte.server.http.header.accept.MimeMediaRangeSubType;
import com.nike.riposte.server.http.header.accept.MimeMediaRangeType;
import com.nike.riposte.server.http.mimetype.MimeType;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class MediaRange
implements Comparable<MediaRange> {
    public final MediaRangeType type;
    public final MediaRangeSubType subType;
    public final Map<String, String> mediaRangeParameters;
    public final Map<String, String> acceptParameters;
    public final Float qualityFactor;
    public static final MediaRangeType WILDCARD_TYPE = new MediaRangeType(){

        public String toString() {
            return "*";
        }
    };
    public static final MediaRangeSubType WILDCARD_SUBTYPE = new MediaRangeSubType(){

        public String toString() {
            return "*";
        }
    };
    private String toStringCache = null;

    public MediaRange(MediaRangeType type, MediaRangeSubType subType, Float qualityFactor, Map<String, String> mediaRangeParameters, Map<String, String> acceptParameters) {
        if (type == null) {
            throw new IllegalArgumentException("type instance cannot be null.");
        }
        this.type = type;
        if (subType == null) {
            throw new IllegalArgumentException("subType instance cannot be null.");
        }
        this.subType = subType;
        if (qualityFactor == null) {
            throw new IllegalArgumentException("qualityFactor instance cannot be null.");
        }
        if (qualityFactor.floatValue() > 1.0f) {
            throw new IllegalArgumentException("qualityFactor can not be greater than 1.");
        }
        if (qualityFactor.floatValue() < 0.0f) {
            throw new IllegalArgumentException("qualityFactor can not be less than 0.");
        }
        this.qualityFactor = qualityFactor;
        this.mediaRangeParameters = mediaRangeParameters != null ? mediaRangeParameters : Collections.emptyMap();
        this.acceptParameters = acceptParameters != null ? acceptParameters : Collections.emptyMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MediaRange)) {
            return false;
        }
        MediaRange that = (MediaRange)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.subType, that.subType) && Objects.equals(this.qualityFactor, that.qualityFactor) && Objects.equals(this.mediaRangeParameters, that.mediaRangeParameters) && Objects.equals(this.acceptParameters, that.acceptParameters);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.subType, this.qualityFactor, this.mediaRangeParameters, this.acceptParameters);
    }

    public String toString() {
        if (this.toStringCache == null) {
            StringBuilder sb = new StringBuilder(this.type.toString()).append("/").append(this.subType.toString());
            sb.append(this.mediaRangeParameters.entrySet().stream().map(entry -> ";" + (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining()));
            if (1.0f > this.qualityFactor.floatValue()) {
                sb.append(";q=");
                sb.append(this.qualityFactor);
            }
            sb.append(this.acceptParameters.entrySet().stream().map(entry -> ";" + (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining()));
            this.toStringCache = sb.toString();
        }
        return this.toStringCache;
    }

    @Override
    public int compareTo(MediaRange that) {
        if (this.qualityFactor.floatValue() > that.qualityFactor.floatValue()) {
            return -1;
        }
        if (this.qualityFactor.floatValue() < that.qualityFactor.floatValue()) {
            return 1;
        }
        if (WILDCARD_TYPE.equals(this.type) && WILDCARD_TYPE.equals(that.type)) {
            return 0;
        }
        if (WILDCARD_TYPE.equals(this.type)) {
            return 1;
        }
        if (WILDCARD_TYPE.equals(that.type)) {
            return -1;
        }
        if (WILDCARD_SUBTYPE.equals(this.subType) && WILDCARD_SUBTYPE.equals(that.subType)) {
            return this.type.toString().compareTo(that.type.toString());
        }
        if (WILDCARD_SUBTYPE.equals(this.subType)) {
            return 1;
        }
        if (WILDCARD_SUBTYPE.equals(that.subType)) {
            return -1;
        }
        int thisParamsCount = this.mediaRangeParameters.size() + this.acceptParameters.size();
        int thatParamsCount = that.mediaRangeParameters.size() + that.acceptParameters.size();
        int paramsDelta = thatParamsCount - thisParamsCount;
        if (paramsDelta != 0) {
            return paramsDelta;
        }
        MimeType.Type thisType = ((MimeMediaRangeType)this.type).getType();
        MimeType.Type thatType = ((MimeMediaRangeType)that.type).getType();
        MimeType.SubType thisSubType = ((MimeMediaRangeSubType)this.subType).getSubType();
        MimeType.SubType thatSubType = ((MimeMediaRangeSubType)that.subType).getSubType();
        if (thisSubType.facet == MimeType.Facet.STANDARD && thatSubType.facet != MimeType.Facet.STANDARD) {
            return 1;
        }
        if (thisSubType.facet != MimeType.Facet.STANDARD && thatSubType.facet == MimeType.Facet.STANDARD) {
            return -1;
        }
        if (thisSubType.getSuffix().isPresent() && !thatSubType.getSuffix().isPresent()) {
            return -1;
        }
        if (!thisSubType.getSuffix().isPresent() && thatSubType.getSuffix().isPresent()) {
            return 1;
        }
        int typeCompare = thisType.getName().compareTo(thatType.getName());
        if (typeCompare != 0) {
            return typeCompare;
        }
        int subTypeCompare = thisSubType.getName().compareTo(thatSubType.getName());
        if (subTypeCompare != 0) {
            return subTypeCompare;
        }
        return 0;
    }
}

