/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.server.http.impl;

import com.nike.riposte.server.http.ResponseInfo;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.cookie.Cookie;
import java.nio.charset.Charset;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseResponseInfo<T>
implements ResponseInfo<T> {
    @Nullable
    protected Integer httpStatusCode;
    @NotNull
    protected final HttpHeaders headers;
    @Nullable
    protected String desiredContentWriterMimeType;
    @Nullable
    protected Charset desiredContentWriterEncoding;
    @Nullable
    protected Set<Cookie> cookies;
    protected boolean preventCompressedOutput;
    @Nullable
    protected Long uncompressedRawContentLength;
    @Nullable
    protected Long finalContentLength;
    protected boolean responseSendingStarted;
    protected boolean responseSendingLastChunkSent;
    protected boolean forceConnectionCloseAfterResponseSent = false;

    protected BaseResponseInfo(@Nullable Integer httpStatusCode, @Nullable HttpHeaders headers, @Nullable String desiredContentWriterMimeType, @Nullable Charset desiredContentWriterEncoding, @Nullable Set<Cookie> cookies, boolean preventCompressedOutput) {
        if (headers == null) {
            headers = new DefaultHttpHeaders();
        }
        if (desiredContentWriterMimeType != null && desiredContentWriterMimeType.contains("charset=")) {
            throw new IllegalArgumentException("desiredContentWriterMimeType should not contain the charset as well. It should just be the mime type. Specify the charset using the desiredContentWriterEncoding argument");
        }
        this.httpStatusCode = httpStatusCode;
        this.headers = headers;
        this.desiredContentWriterMimeType = desiredContentWriterMimeType;
        this.desiredContentWriterEncoding = desiredContentWriterEncoding;
        this.cookies = cookies;
        this.preventCompressedOutput = preventCompressedOutput;
    }

    @Override
    @Nullable
    public Integer getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @Override
    public void setHttpStatusCode(@Nullable Integer httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    @Override
    @NotNull
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    @Nullable
    public String getDesiredContentWriterMimeType() {
        return this.desiredContentWriterMimeType;
    }

    @Override
    public void setDesiredContentWriterMimeType(@Nullable String desiredContentWriterMimeType) {
        this.desiredContentWriterMimeType = desiredContentWriterMimeType;
    }

    @Override
    @Nullable
    public Charset getDesiredContentWriterEncoding() {
        return this.desiredContentWriterEncoding;
    }

    @Override
    public void setDesiredContentWriterEncoding(@Nullable Charset desiredContentWriterEncoding) {
        this.desiredContentWriterEncoding = desiredContentWriterEncoding;
    }

    @Override
    @Nullable
    public Set<Cookie> getCookies() {
        return this.cookies;
    }

    @Override
    public void setCookies(@Nullable Set<Cookie> cookies) {
        this.cookies = cookies;
    }

    @Override
    public boolean isPreventCompressedOutput() {
        return this.preventCompressedOutput;
    }

    @Override
    public void setPreventCompressedOutput(boolean preventCompressedOutput) {
        this.preventCompressedOutput = preventCompressedOutput;
    }

    @Override
    @Nullable
    public Long getUncompressedRawContentLength() {
        return this.uncompressedRawContentLength;
    }

    @Override
    public void setUncompressedRawContentLength(@Nullable Long uncompressedRawContentLength) {
        this.uncompressedRawContentLength = uncompressedRawContentLength;
    }

    @Override
    @Nullable
    public Long getFinalContentLength() {
        return this.finalContentLength;
    }

    @Override
    public void setFinalContentLength(@Nullable Long finalContentLength) {
        this.finalContentLength = finalContentLength;
    }

    @Override
    public boolean isResponseSendingStarted() {
        return this.responseSendingStarted;
    }

    @Override
    public void setResponseSendingStarted(boolean responseSendingStarted) {
        this.responseSendingStarted = responseSendingStarted;
    }

    @Override
    public boolean isResponseSendingLastChunkSent() {
        return this.responseSendingLastChunkSent;
    }

    @Override
    public void setResponseSendingLastChunkSent(boolean responseSendingLastChunkSent) {
        this.responseSendingLastChunkSent = responseSendingLastChunkSent;
    }

    @Override
    public boolean isForceConnectionCloseAfterResponseSent() {
        return this.forceConnectionCloseAfterResponseSent;
    }

    @Override
    public void setForceConnectionCloseAfterResponseSent(boolean forceConnectionCloseAfterResponseSent) {
        this.forceConnectionCloseAfterResponseSent = forceConnectionCloseAfterResponseSent;
    }
}

