/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.server.http.impl;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.cookie.Cookie;
import java.nio.charset.Charset;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseResponseInfoBuilder<T> {
    @Nullable
    private Integer httpStatusCode;
    @Nullable
    private HttpHeaders headers;
    @Nullable
    private String desiredContentWriterMimeType;
    @Nullable
    private Charset desiredContentWriterEncoding;
    @Nullable
    private Set<Cookie> cookies;
    private boolean preventCompressedOutput = false;

    protected BaseResponseInfoBuilder() {
    }

    @NotNull
    public BaseResponseInfoBuilder<T> withHttpStatusCode(@Nullable Integer httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
        return this;
    }

    @NotNull
    public BaseResponseInfoBuilder<T> withHeaders(@Nullable HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    @NotNull
    public BaseResponseInfoBuilder<T> withDesiredContentWriterMimeType(@Nullable String desiredContentWriterMimeType) {
        this.desiredContentWriterMimeType = desiredContentWriterMimeType;
        return this;
    }

    @NotNull
    public BaseResponseInfoBuilder<T> withDesiredContentWriterEncoding(@Nullable Charset desiredContentWriterEncoding) {
        this.desiredContentWriterEncoding = desiredContentWriterEncoding;
        return this;
    }

    @NotNull
    public BaseResponseInfoBuilder<T> withCookies(@Nullable Set<Cookie> cookies) {
        this.cookies = cookies;
        return this;
    }

    @NotNull
    public BaseResponseInfoBuilder<T> withPreventCompressedOutput(boolean preventCompressedOutput) {
        this.preventCompressedOutput = preventCompressedOutput;
        return this;
    }

    @Nullable
    protected Integer getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @Nullable
    protected HttpHeaders getHeaders() {
        return this.headers;
    }

    @Nullable
    protected String getDesiredContentWriterMimeType() {
        return this.desiredContentWriterMimeType;
    }

    @Nullable
    protected Charset getDesiredContentWriterEncoding() {
        return this.desiredContentWriterEncoding;
    }

    @Nullable
    protected Set<Cookie> getCookies() {
        return this.cookies;
    }

    protected boolean isPreventCompressedOutput() {
        return this.preventCompressedOutput;
    }
}

