/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.server.http.impl;

import com.nike.riposte.server.http.impl.BaseResponseInfo;
import com.nike.riposte.server.http.impl.BaseResponseInfoBuilder;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.cookie.Cookie;
import java.nio.charset.Charset;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkedResponseInfo
extends BaseResponseInfo<Void> {
    public ChunkedResponseInfo(@Nullable Integer httpStatusCode, @Nullable HttpHeaders headers, @Nullable String desiredContentWriterMimeType, @Nullable Charset desiredContentWriterEncoding, @Nullable Set<Cookie> cookies, boolean preventCompressedOutput) {
        super(httpStatusCode, headers, desiredContentWriterMimeType, desiredContentWriterEncoding, cookies, preventCompressedOutput);
    }

    public ChunkedResponseInfo() {
        this(null, null, null, null, null, false);
    }

    @Override
    public boolean isChunkedResponse() {
        return true;
    }

    @Override
    @Nullable
    public Void getContentForFullResponse() {
        throw new IllegalStateException("Attempted to call getContentForFullResponse() when isChunkedResponse() is true. Always verify that isChunkedResponse() returns false before calling this method.");
    }

    @Override
    public void setContentForFullResponse(@Nullable Void contentForFullResponse) {
        throw new IllegalStateException("isChunkedResponse() is true. You cannot add full response content to a chunked response.");
    }

    public static final class ChunkedResponseInfoBuilder
    extends BaseResponseInfoBuilder<Void> {
        @NotNull
        public ChunkedResponseInfoBuilder withHttpStatusCode(@Nullable Integer httpStatusCode) {
            super.withHttpStatusCode(httpStatusCode);
            return this;
        }

        @NotNull
        public ChunkedResponseInfoBuilder withHeaders(@Nullable HttpHeaders headers) {
            super.withHeaders(headers);
            return this;
        }

        @NotNull
        public ChunkedResponseInfoBuilder withDesiredContentWriterMimeType(@Nullable String desiredContentWriterMimeType) {
            super.withDesiredContentWriterMimeType(desiredContentWriterMimeType);
            return this;
        }

        @NotNull
        public ChunkedResponseInfoBuilder withDesiredContentWriterEncoding(@Nullable Charset desiredContentWriterEncoding) {
            super.withDesiredContentWriterEncoding(desiredContentWriterEncoding);
            return this;
        }

        @NotNull
        public ChunkedResponseInfoBuilder withCookies(@Nullable Set<Cookie> cookies) {
            super.withCookies(cookies);
            return this;
        }

        @NotNull
        public ChunkedResponseInfoBuilder withPreventCompressedOutput(boolean preventCompressedOutput) {
            super.withPreventCompressedOutput(preventCompressedOutput);
            return this;
        }

        @NotNull
        public ChunkedResponseInfo build() {
            return new ChunkedResponseInfo(this.getHttpStatusCode(), this.getHeaders(), this.getDesiredContentWriterMimeType(), this.getDesiredContentWriterEncoding(), this.getCookies(), this.isPreventCompressedOutput());
        }
    }
}

