/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.server.http.impl;

import com.nike.riposte.server.http.impl.BaseResponseInfo;
import com.nike.riposte.server.http.impl.BaseResponseInfoBuilder;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.cookie.Cookie;
import java.nio.charset.Charset;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FullResponseInfo<T>
extends BaseResponseInfo<T> {
    @Nullable
    protected T contentForFullResponse;

    public FullResponseInfo(@Nullable T contentForFullResponse, @Nullable Integer httpStatusCode, @Nullable HttpHeaders headers, @Nullable String desiredContentWriterMimeType, @Nullable Charset desiredContentWriterEncoding, @Nullable Set<Cookie> cookies, boolean preventCompressedOutput) {
        super(httpStatusCode, headers, desiredContentWriterMimeType, desiredContentWriterEncoding, cookies, preventCompressedOutput);
        this.contentForFullResponse = contentForFullResponse;
    }

    public FullResponseInfo() {
        this(null, null, null, null, null, null, false);
    }

    @Override
    public boolean isChunkedResponse() {
        return false;
    }

    @Override
    @Nullable
    public T getContentForFullResponse() {
        return this.contentForFullResponse;
    }

    @Override
    public void setContentForFullResponse(@Nullable T contentForFullResponse) {
        if (this.isResponseSendingLastChunkSent()) {
            throw new IllegalStateException("isFullResponseSent() is true. You cannot set content for a response that has already been sent to the user.");
        }
        this.contentForFullResponse = contentForFullResponse;
    }

    public static final class FullResponseInfoBuilder<T>
    extends BaseResponseInfoBuilder<T> {
        @Nullable
        private T contentForFullResponse;

        @NotNull
        public FullResponseInfoBuilder<T> withContentForFullResponse(@Nullable T content) {
            this.contentForFullResponse = content;
            return this;
        }

        @Override
        @NotNull
        public FullResponseInfoBuilder<T> withHttpStatusCode(@Nullable Integer httpStatusCode) {
            super.withHttpStatusCode(httpStatusCode);
            return this;
        }

        @Override
        @NotNull
        public FullResponseInfoBuilder<T> withHeaders(@Nullable HttpHeaders headers) {
            super.withHeaders(headers);
            return this;
        }

        @Override
        @NotNull
        public FullResponseInfoBuilder<T> withDesiredContentWriterMimeType(@Nullable String desiredContentWriterMimeType) {
            super.withDesiredContentWriterMimeType(desiredContentWriterMimeType);
            return this;
        }

        @Override
        @NotNull
        public FullResponseInfoBuilder<T> withDesiredContentWriterEncoding(@Nullable Charset desiredContentWriterEncoding) {
            super.withDesiredContentWriterEncoding(desiredContentWriterEncoding);
            return this;
        }

        @Override
        @NotNull
        public FullResponseInfoBuilder<T> withCookies(@Nullable Set<Cookie> cookies) {
            super.withCookies(cookies);
            return this;
        }

        @Override
        @NotNull
        public FullResponseInfoBuilder<T> withPreventCompressedOutput(boolean preventCompressedOutput) {
            super.withPreventCompressedOutput(preventCompressedOutput);
            return this;
        }

        @NotNull
        public FullResponseInfo<T> build() {
            return new FullResponseInfo<T>(this.contentForFullResponse, this.getHttpStatusCode(), this.getHeaders(), this.getDesiredContentWriterMimeType(), this.getDesiredContentWriterEncoding(), this.getCookies(), this.isPreventCompressedOutput());
        }
    }
}

