/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.server.http.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nike.riposte.server.error.exception.RequestContentDeserializationException;
import com.nike.riposte.server.http.RequestInfo;
import com.nike.riposte.server.http.impl.RiposteInternalRequestInfo;
import com.nike.riposte.util.HttpUtils;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.ReferenceCounted;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestInfoImpl<T>
implements RequestInfo<T>,
RiposteInternalRequestInfo {
    private static final Logger logger = LoggerFactory.getLogger(RequestInfoImpl.class);
    @NotNull
    protected final String uri;
    @NotNull
    protected final String path;
    @Nullable
    protected final HttpMethod method;
    @NotNull
    protected final HttpHeaders headers;
    @NotNull
    protected HttpHeaders trailingHeaders;
    @NotNull
    protected final QueryStringDecoder queryParams;
    @NotNull
    protected final Set<Cookie> cookies;
    @Nullable
    protected String pathTemplate;
    @NotNull
    protected Map<String, String> pathParams = Collections.emptyMap();
    @NotNull
    protected final Map<String, Object> attributes = new HashMap<String, Object>();
    protected int rawContentLengthInBytes;
    @Nullable
    protected byte[] rawContentBytes;
    @Nullable
    protected String rawContent;
    @Nullable
    protected T content;
    @NotNull
    protected final Charset contentCharset;
    @Nullable
    protected final HttpVersion protocolVersion;
    protected final boolean keepAliveRequested;
    @NotNull
    protected final List<HttpContent> contentChunks = new ArrayList<HttpContent>();
    protected boolean isCompleteRequestWithAllChunks;
    protected final boolean isMultipart;
    protected boolean multipartDataIsDestroyed = false;
    @Nullable
    protected HttpPostMultipartRequestDecoder multipartData;
    @Nullable
    protected ObjectMapper contentDeserializer;
    @Nullable
    protected TypeReference<T> contentDeserializerTypeReference;
    protected boolean contentChunksWillBeReleasedExternally = false;

    public RequestInfoImpl(@Nullable String uri, @Nullable HttpMethod method, @Nullable HttpHeaders headers, @Nullable HttpHeaders trailingHeaders, @Nullable QueryStringDecoder queryParams, @Nullable Set<Cookie> cookies, @Nullable Map<String, String> pathParams, @Nullable List<@NotNull HttpContent> contentChunks, @Nullable HttpVersion protocolVersion, boolean keepAliveRequested, boolean isCompleteRequestWithAllChunks, boolean isMultipart) {
        if (uri == null) {
            uri = "";
        }
        if (headers == null) {
            headers = new DefaultHttpHeaders();
        }
        if (trailingHeaders == null) {
            trailingHeaders = new DefaultHttpHeaders();
        }
        if (queryParams == null) {
            queryParams = new QueryStringDecoder(uri);
        }
        if (cookies == null) {
            cookies = new HashSet<Cookie>();
        }
        this.uri = uri;
        this.path = QueryStringDecoder.decodeComponent((String)HttpUtils.extractPath(uri));
        this.method = method;
        this.headers = headers;
        this.trailingHeaders = trailingHeaders;
        this.queryParams = queryParams;
        this.cookies = cookies;
        this.setPathParams(pathParams);
        this.contentCharset = HttpUtils.determineCharsetFromContentType(headers, DEFAULT_CONTENT_CHARSET);
        if (contentChunks != null) {
            contentChunks.forEach(this::addContentChunk);
        }
        this.protocolVersion = protocolVersion;
        this.keepAliveRequested = keepAliveRequested;
        this.isCompleteRequestWithAllChunks = isCompleteRequestWithAllChunks;
        this.isMultipart = isMultipart;
    }

    public RequestInfoImpl(@NotNull HttpRequest request) {
        this(request.uri(), request.method(), request.headers(), HttpUtils.extractTrailingHeadersIfPossible(request), null, HttpUtils.extractCookies(request), null, HttpUtils.extractContentChunks(request), request.protocolVersion(), HttpUtil.isKeepAlive((HttpMessage)request), request instanceof FullHttpRequest, HttpPostRequestDecoder.isMultipart((HttpRequest)request));
    }

    public static RequestInfoImpl<?> dummyInstanceForUnknownRequests() {
        HttpHeaders headers = new DefaultHttpHeaders().set("none_or_unknown", (Object)"true");
        QueryStringDecoder queryParams = new QueryStringDecoder("/?none_or_unknown=true");
        return new RequestInfoImpl("none_or_unknown", null, headers, null, queryParams, null, null, null, null, false, true, false);
    }

    @Override
    @NotNull
    public String getUri() {
        return this.uri;
    }

    @Override
    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    @NotNull
    public QueryStringDecoder getQueryParams() {
        return this.queryParams;
    }

    @Override
    @NotNull
    public Set<Cookie> getCookies() {
        return this.cookies;
    }

    @Override
    @NotNull
    public Charset getContentCharset() {
        return this.contentCharset;
    }

    @Override
    @Nullable
    public HttpVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public boolean isKeepAliveRequested() {
        return this.keepAliveRequested;
    }

    @Override
    public synchronized int getRawContentLengthInBytes() {
        if (!this.isCompleteRequestWithAllChunks) {
            return 0;
        }
        return this.rawContentLengthInBytes;
    }

    @Override
    @Nullable
    public synchronized byte[] getRawContentBytes() {
        if (!this.isCompleteRequestWithAllChunks) {
            return null;
        }
        if (!this.contentChunks.isEmpty()) {
            this.rawContentBytes = HttpUtils.convertContentChunksToRawBytes(this.contentChunks);
            this.releaseContentChunks();
        }
        return this.rawContentBytes;
    }

    @Override
    @Nullable
    public synchronized String getRawContent() {
        if (!this.isCompleteRequestWithAllChunks) {
            return null;
        }
        if (this.rawContent != null) {
            return this.rawContent;
        }
        this.rawContent = HttpUtils.convertRawBytesToString(this.getContentCharset(), this.getRawContentBytes());
        return this.rawContent;
    }

    @Override
    @Nullable
    public synchronized T getContent() {
        if (!this.isCompleteRequestWithAllChunks) {
            return null;
        }
        if (this.content == null) {
            this.content = this.deserializeContent();
        }
        return this.content;
    }

    @Override
    public boolean isMultipartRequest() {
        return this.isMultipart;
    }

    @Override
    @Nullable
    public synchronized List<InterfaceHttpData> getMultipartParts() {
        if (!this.isMultipartRequest() || !this.isCompleteRequestWithAllChunks()) {
            return null;
        }
        if (this.multipartData == null) {
            byte[] contentBytes = this.getRawContentBytes();
            HttpVersion httpVersion = this.getProtocolVersion();
            HttpMethod httpMethod = this.getMethod();
            if (httpVersion == null) {
                httpVersion = HttpVersion.HTTP_1_0;
            }
            if (httpMethod == null) {
                httpMethod = HttpMethod.POST;
            }
            DefaultFullHttpRequest fullHttpRequestForMultipartDecoder = contentBytes == null ? new DefaultFullHttpRequest(httpVersion, httpMethod, this.getUri()) : new DefaultFullHttpRequest(httpVersion, httpMethod, this.getUri(), Unpooled.wrappedBuffer((byte[])contentBytes));
            fullHttpRequestForMultipartDecoder.headers().add(this.getHeaders());
            this.multipartData = new HttpPostMultipartRequestDecoder((HttpDataFactory)new DefaultHttpDataFactory(false), (HttpRequest)fullHttpRequestForMultipartDecoder, this.getContentCharset());
        }
        return this.multipartData.getBodyHttpDatas();
    }

    protected T deserializeContent() {
        if (!this.isContentDeserializerSetup()) {
            return null;
        }
        try {
            byte[] bytes;
            Type inputType = this.contentDeserializerTypeReference.getType();
            if (inputType instanceof Class) {
                Class inputTypeClass = (Class)inputType;
                if (byte[].class.equals((Object)inputTypeClass)) {
                    return (T)this.getRawContentBytes();
                }
                if (String.class.equals((Object)inputTypeClass) || CharSequence.class.equals((Object)inputTypeClass)) {
                    return (T)this.getRawContent();
                }
            }
            return (T)((bytes = this.getRawContentBytes()) == null ? null : this.contentDeserializer.readValue(bytes, this.contentDeserializerTypeReference));
        }
        catch (Throwable e) {
            logger.info("Unable to deserialize request content to desired object type - {}: {}", (Object)this.contentDeserializerTypeReference.getType().toString(), (Object)e.getMessage());
            throw new RequestContentDeserializationException("Unable to deserialize request content to desired object type.", e, this, this.contentDeserializerTypeReference);
        }
    }

    @Override
    @NotNull
    public RequestInfo<T> setupContentDeserializer(@NotNull ObjectMapper deserializer, @NotNull TypeReference<T> typeReference) {
        this.contentDeserializer = deserializer;
        this.contentDeserializerTypeReference = typeReference;
        return this;
    }

    @Override
    public boolean isContentDeserializerSetup() {
        return this.contentDeserializer != null && this.contentDeserializerTypeReference != null;
    }

    @Override
    @NotNull
    public HttpHeaders getTrailingHeaders() {
        return this.trailingHeaders;
    }

    @Override
    @NotNull
    public RequestInfo<T> setPathParamsBasedOnPathTemplate(@NotNull String pathTemplate) {
        this.pathTemplate = pathTemplate;
        this.setPathParams(HttpUtils.decodePathParams(pathTemplate, this.getPath()));
        return this;
    }

    @Override
    @NotNull
    public Map<String, String> getPathParams() {
        return this.pathParams;
    }

    protected void setPathParams(@Nullable Map<String, String> pathParams) {
        if (pathParams == null) {
            pathParams = Collections.emptyMap();
        }
        this.pathParams = pathParams;
    }

    @Override
    public void contentChunksWillBeReleasedExternally() {
        this.contentChunksWillBeReleasedExternally = true;
        if (this.contentChunks.size() > 0) {
            this.contentChunks.clear();
        }
    }

    @Override
    public int addContentChunk(@NotNull HttpContent chunk) {
        if (this.isCompleteRequestWithAllChunks) {
            throw new IllegalStateException("Cannot add new content chunk - this RequestInfo is already marked as representing the complete request with all chunks");
        }
        chunk.retain();
        this.rawContentLengthInBytes += chunk.content().readableBytes();
        if (!this.contentChunksWillBeReleasedExternally) {
            this.contentChunks.add(chunk);
        }
        if (chunk instanceof LastHttpContent) {
            HttpHeaders chunkTrailingHeaders;
            if (!this.contentChunksWillBeReleasedExternally) {
                this.isCompleteRequestWithAllChunks = true;
            }
            if (this.trailingHeaders != (chunkTrailingHeaders = ((LastHttpContent)chunk).trailingHeaders())) {
                if (!this.trailingHeaders.isEmpty()) {
                    throw new IllegalStateException("Received the final chunk, but trailingHeaders was already populated. This should not be possible.");
                }
                this.trailingHeaders.add(chunkTrailingHeaders);
            }
        }
        return this.rawContentLengthInBytes;
    }

    @Override
    public boolean isCompleteRequestWithAllChunks() {
        return this.isCompleteRequestWithAllChunks;
    }

    @Override
    public void releaseAllResources() {
        this.releaseContentChunks();
        this.releaseMultipartData();
    }

    @Override
    public void releaseContentChunks() {
        if (!this.contentChunksWillBeReleasedExternally) {
            this.contentChunks.forEach(ReferenceCounted::release);
        }
        this.contentChunks.clear();
    }

    @Override
    public void releaseMultipartData() {
        if (this.multipartDataIsDestroyed) {
            return;
        }
        if (this.multipartData != null) {
            this.multipartData.destroy();
            this.multipartDataIsDestroyed = true;
        }
    }

    @Override
    public void addRequestAttribute(@NotNull String attributeName, @NotNull Object attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    @Override
    @NotNull
    public Map<String, Object> getRequestAttributes() {
        return this.attributes;
    }

    @Override
    @NotNull
    public String getPathTemplate() {
        return this.pathTemplate == null ? "" : this.pathTemplate;
    }
}

