/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.server.http.mimetype;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MimeType {
    public final Type type;
    public final SubType subType;
    public final Map<String, String> parameters;
    private String toStringCache = null;

    private MimeType(Type type, SubType subType, Map<String, String> parameters) {
        this.type = type;
        this.subType = subType;
        this.parameters = parameters;
    }

    public static MimeType of(Type type, SubType subType, Map<String, String> parameters) {
        return new MimeType(type, subType, parameters);
    }

    public static MimeType of(Type type, SubType subType) {
        return MimeType.of(type, subType, new HashMap<String, String>());
    }

    public Type getType() {
        return this.type;
    }

    public SubType getSubType() {
        return this.subType;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MimeType mimeType = (MimeType)o;
        if (!this.getType().equals(mimeType.getType())) {
            return false;
        }
        if (!this.getSubType().equals(mimeType.getSubType())) {
            return false;
        }
        return this.getParameters().equals(mimeType.getParameters());
    }

    public int hashCode() {
        int result = this.getType().hashCode();
        result = 67867979 * result + this.getSubType().hashCode();
        result = 67867979 * result + this.getParameters().hashCode();
        return result;
    }

    public String toString() {
        if (this.toStringCache == null) {
            this.toStringCache = this.type.getName() + "/" + this.subType.getFacet().getRegistrationTreeName().map(tree -> tree + ".").orElse("") + this.subType.getName() + this.subType.getSuffix().map(suffix -> "+" + suffix).orElse("") + this.parameters.entrySet().stream().map(entry -> ";" + (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining());
        }
        return this.toStringCache;
    }

    public static enum Facet {
        VENDOR(Optional.of("vnd")),
        PERSONAL(Optional.of("prs")),
        UNREGISTERED(Optional.of("x")),
        STANDARD(Optional.empty());

        private Optional<String> registrationTreeName;
        public static final Map<String, Facet> lowercaseRegistrationTreeNameToFacetValuesMap;

        private Facet(Optional<String> registrationTreeName) {
            this.registrationTreeName = registrationTreeName;
        }

        public Optional<String> getRegistrationTreeName() {
            return this.registrationTreeName;
        }

        public static Optional<Facet> forRegistrationTreeName(String registrationTreeName) {
            return Optional.ofNullable(registrationTreeName).flatMap(name -> Optional.ofNullable(lowercaseRegistrationTreeNameToFacetValuesMap.get(name)));
        }

        static {
            lowercaseRegistrationTreeNameToFacetValuesMap = Collections.unmodifiableMap(Stream.of(Facet.values()).filter(facet -> facet.getRegistrationTreeName().isPresent()).collect(Collectors.toMap(facet -> facet.getRegistrationTreeName().get().toLowerCase(), Function.identity())));
        }
    }

    public static class SubType {
        public final Facet facet;
        public final String name;
        public final Optional<String> suffix;

        private SubType(Facet facet, String name, Optional<String> suffix) {
            this.facet = facet;
            this.name = name;
            this.suffix = suffix;
        }

        public Facet getFacet() {
            return this.facet;
        }

        public String getName() {
            return this.name;
        }

        public Optional<String> getSuffix() {
            return this.suffix;
        }

        public static SubType of(Facet facet, String name, Optional<String> suffix) {
            return new SubType(facet, name, suffix);
        }

        public static SubType of(String name) {
            return new SubType(Facet.STANDARD, name, Optional.empty());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubType subType = (SubType)o;
            if (this.getFacet() != subType.getFacet()) {
                return false;
            }
            if (!this.getName().equals(subType.getName())) {
                return false;
            }
            return this.getSuffix().equals(subType.getSuffix());
        }

        public int hashCode() {
            int result = this.getFacet().hashCode();
            result = 122949829 * result + this.getName().hashCode();
            result = 122949829 * result + this.getSuffix().hashCode();
            return result;
        }
    }

    public static final class Type {
        public static final Type APPLICATION = new Type("application");
        public static final Type TEXT = new Type("text");
        public static final Type IMAGE = new Type("image");
        public static final Type AUDIO = new Type("audio");
        public static final Type VIDEO = new Type("video");
        public static final Type MULTIPART = new Type("multipart");
        public static final Type MESSAGE = new Type("message");
        public static final Type MODEL = new Type("model");
        public static final Type EXAMPLE = new Type("example");
        public static final List<Type> values = Collections.unmodifiableList(Arrays.asList(APPLICATION, TEXT, IMAGE, AUDIO, VIDEO, MULTIPART, MESSAGE, MODEL, EXAMPLE));
        public static final Map<String, Type> lowercaseNameToTypeValuesMap = Collections.unmodifiableMap(values.stream().collect(Collectors.toMap(type -> type.getName().toLowerCase(), Function.identity())));
        public final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Type of(String typeName) {
            Type type = lowercaseNameToTypeValuesMap.get(typeName.toLowerCase());
            return type != null ? type : new Type(typeName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Type type = (Type)o;
            return this.getName().equals(type.getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }
    }
}

