/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.server.http.mimetype;

import com.nike.internal.util.Pair;
import com.nike.riposte.server.http.mimetype.MimeType;
import com.nike.riposte.util.text.parsercombinator.Parser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class MimeTypeParser {
    public static final Pattern tokenPattern = Pattern.compile("([a-zA-Z0-9][a-zA-Z0-9\\!\\#\\$\\&\\-\\^_\\.]*)");
    public static final Parser<String> token = Parser.Parsers.regex(tokenPattern).map(matchResult -> matchResult.group(1));
    public static final Parser<Pair<String, String>> parameterParser = token.thenSkip(Parser.Parsers.string("=")).thenParse(token);
    public static final Parser<MatchResult> semicolon = Parser.Parsers.regex("\\s*;\\s*");
    public static final Parser<Map<String, String>> parametersParser = Parser.Parsers.skip(semicolon).thenParse(parameterParser.oneOrMore(semicolon)).map(list -> {
        HashMap parameters = new HashMap();
        list.forEach(pair -> parameters.put((String)pair.getLeft(), (String)pair.getRight()));
        return parameters;
    });
    public static final Parser<MimeType.Type> typeParser = Parser.Parsers.oneOf(MimeType.Type.values.stream().map(type -> Parser.Parsers.string(type.getName()))).or(token).map(MimeType.Type::of);
    public static final Parser<MimeType.Facet> facetParser = Parser.Parsers.oneOf(Stream.of(MimeType.Facet.values()).filter(facet -> facet.getRegistrationTreeName().isPresent()).map(facet -> Parser.Parsers.string(facet.getRegistrationTreeName().get()))).map(MimeType.Facet::forRegistrationTreeName).flatMap(oFacet -> oFacet.isPresent() ? Parser.Parsers.success((MimeType.Facet)((Object)((Object)oFacet.get()))) : Parser.Parsers.failure("unrecognized facet"));
    public static final Parser<MimeType.SubType> subTypeParser = Parser.Parsers.oneOf(facetParser.thenSkip(Parser.Parsers.string(".")).thenParse(token).thenSkip(Parser.Parsers.string("+")).thenParse(token).map(Parser.Apply.match((facet, name, suffix) -> MimeType.SubType.of(facet, name, Optional.of(suffix)))), facetParser.thenSkip(Parser.Parsers.string(".")).thenParse(token).map(Parser.Apply.match((facet, name) -> MimeType.SubType.of(facet, name, Optional.empty()))), token.thenSkip(Parser.Parsers.string("+")).thenParse(token).map(Parser.Apply.match((name, suffix) -> MimeType.SubType.of(MimeType.Facet.STANDARD, name, Optional.of(suffix)))), token.map(Parser.Apply.match(name -> MimeType.SubType.of(MimeType.Facet.STANDARD, name, Optional.empty()))));
    public static final Parser<MimeType> mimeTypeParser = typeParser.thenSkip(Parser.Parsers.string("/")).thenParse(subTypeParser).thenParse(parametersParser.optional().map(oParams -> oParams.orElse(Collections.emptyMap()))).map(Parser.Apply.match((type, subType, parameters) -> MimeType.of(type, subType, parameters)));

    public static Optional<MimeType> parse(CharSequence text) {
        return mimeTypeParser.tryParse(text);
    }
}

