/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.server.logging;

import com.nike.internal.util.Pair;
import com.nike.riposte.server.http.RequestInfo;
import com.nike.riposte.server.http.ResponseInfo;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogger {
    protected static final Logger logger = LoggerFactory.getLogger((String)"ACCESS_LOG");
    public static final String TRACE_ID = "X-B3-TraceId";
    public static final String SPAN_ID = "X-B3-SpanId";
    public static final String PARENT_ID = "X-B3-ParentSpanId";
    public static final String SPAN_NAME = "X-B3-SpanName";
    public static final String TRACE_ENABLED = "X-B3-Sampled";
    @Nullable
    private static String cachedLocalIpAddress;
    private static long cachedLocalIpAddressLastCheckedTime;
    private static final long LOCAL_IP_ADDRESS_CACHE_CHECK_FREQUENCY_MILLIS = 60000L;
    @NotNull
    private final String timezoneString;
    @NotNull
    private final String[] shortMonthNames;
    private final CompletableFuture<Void> alreadyCompletedFuture = CompletableFuture.completedFuture(null);

    public AccessLogger() {
        this.timezoneString = " " + ZonedDateTime.now().format(DateTimeFormatter.ofPattern("Z"));
        Locale defaultLocale = Locale.getDefault(Locale.Category.FORMAT);
        Map<String, Integer> monthMap = Calendar.getInstance().getDisplayNames(2, 1, defaultLocale);
        int maxMonthIndex = Collections.max(monthMap.values());
        this.shortMonthNames = new String[maxMonthIndex + 1];
        monthMap.forEach((key, value) -> {
            this.shortMonthNames[value.intValue()] = key;
        });
    }

    @NotNull
    public CompletableFuture<Void> log(@NotNull RequestInfo<?> request, @Nullable HttpResponse finalResponseObject, @Nullable ResponseInfo responseInfo, @Nullable Long elapsedTimeMillis) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (this.logAsynchronously()) {
            return CompletableFuture.runAsync(() -> logger.info(this.generateFinalAccessLogMessage(request, finalResponseObject, responseInfo, elapsedTimeMillis)));
        }
        logger.info(this.generateFinalAccessLogMessage(request, finalResponseObject, responseInfo, elapsedTimeMillis));
        return this.alreadyCompletedFuture;
    }

    protected boolean logAsynchronously() {
        return false;
    }

    @NotNull
    protected String generateFinalAccessLogMessage(@NotNull RequestInfo<?> request, @Nullable HttpResponse finalResponseObject, @Nullable ResponseInfo responseInfo, @Nullable Long elapsedTimeMillis) {
        String combinedLogString = this.combinedLogFormatPrefix(request, finalResponseObject, responseInfo);
        List<Pair<String, String>> logMessageAdditions = this.logMessageAdditions(request, finalResponseObject, responseInfo, elapsedTimeMillis);
        String logMessageAdditionsAsString = this.convertAdditionsToString(logMessageAdditions);
        return this.concatenateCombinedLogAndAdditionStrings(combinedLogString, logMessageAdditionsAsString);
    }

    @NotNull
    protected String combinedLogFormatPrefix(@NotNull RequestInfo<?> request, @Nullable HttpResponse finalResponseObject, @Nullable ResponseInfo responseInfo) {
        String ipAddress = "<unknown>";
        try {
            ipAddress = this.getLocalIpAddress();
        }
        catch (UnknownHostException ex) {
            logger.warn("Unable to retrieve local IP address.", (Throwable)ex);
        }
        String method = request.getMethod() == null ? "-" : String.valueOf(request.getMethod());
        String uriString = request.getUri();
        if (uriString == null) {
            uriString = "-";
        }
        String protocolVersion = request.getProtocolVersion() == null ? "-" : String.valueOf(request.getProtocolVersion());
        String url = method + " " + uriString + " " + protocolVersion;
        String referer = "-";
        String userAgent = "-";
        if (request.getHeaders() != null) {
            referer = request.getHeaders().get((CharSequence)HttpHeaderNames.REFERER);
            if (referer == null) {
                referer = "-";
            }
            if ((userAgent = request.getHeaders().get((CharSequence)HttpHeaderNames.USER_AGENT)) == null) {
                userAgent = "-";
            }
        }
        String httpStatusCode = "-";
        if (finalResponseObject != null && finalResponseObject.status() != null) {
            httpStatusCode = String.valueOf(finalResponseObject.status().code());
        } else if (responseInfo != null && responseInfo.getHttpStatusCode() != null) {
            httpStatusCode = String.valueOf(responseInfo.getHttpStatusCode());
        }
        String contentLength = "-";
        if (responseInfo != null && responseInfo.getFinalContentLength() != null && responseInfo.getFinalContentLength() > 0L) {
            contentLength = String.valueOf(responseInfo.getFinalContentLength());
        }
        return ipAddress + " - - [" + this.getFormattedDateTimeForNcsaCombinedLog(ZonedDateTime.now()) + "] \"" + url + "\" " + httpStatusCode + " " + contentLength + " \"" + referer + "\" \"" + userAgent + "\"";
    }

    @NotNull
    protected String getFormattedDateTimeForNcsaCombinedLog(@NotNull ZonedDateTime dateTime) {
        StringBuilder resultString = new StringBuilder(32);
        this.appendTwoDigitFormattedInt(dateTime.getDayOfMonth(), resultString).append("/");
        resultString.append(this.shortMonthNames[dateTime.getMonthValue() - 1]).append("/").append(dateTime.getYear()).append(":");
        this.appendTwoDigitFormattedInt(dateTime.getHour(), resultString).append(":");
        this.appendTwoDigitFormattedInt(dateTime.getMinute(), resultString).append(":");
        this.appendTwoDigitFormattedInt(dateTime.getSecond(), resultString).append(" ");
        resultString.append(this.timezoneString);
        return resultString.toString();
    }

    @NotNull
    protected StringBuilder appendTwoDigitFormattedInt(int theInt, @NotNull StringBuilder sb) {
        if (theInt < 10) {
            sb.append("0");
        }
        return sb.append(theInt);
    }

    @NotNull
    protected String getLocalIpAddress() throws UnknownHostException {
        long currentTimeMillis = System.currentTimeMillis();
        long timeSinceLastCheck = currentTimeMillis - cachedLocalIpAddressLastCheckedTime;
        if (cachedLocalIpAddress == null || timeSinceLastCheck > 60000L) {
            cachedLocalIpAddress = InetAddress.getLocalHost().getHostAddress();
            cachedLocalIpAddressLastCheckedTime = currentTimeMillis;
        }
        return cachedLocalIpAddress;
    }

    @NotNull
    protected List<Pair<String, String>> logMessageAdditions(@NotNull RequestInfo<?> request, @Nullable HttpResponse finalResponseObject, @Nullable ResponseInfo responseInfo, @Nullable Long elapsedTimeMillis) {
        String httpStatusCode = null;
        String contentLengthResponseHeader = null;
        String transferEncodingResponseHeader = null;
        String errorUid = null;
        String responseTraceId = null;
        String uncompressedRawContentLength = null;
        String finalContentLength = null;
        if (finalResponseObject != null && finalResponseObject.status() != null) {
            httpStatusCode = String.valueOf(finalResponseObject.status().code());
        } else if (responseInfo != null && responseInfo.getHttpStatusCode() != null) {
            httpStatusCode = String.valueOf(responseInfo.getHttpStatusCode());
        }
        HttpHeaders responseHeadersToUse = null;
        if (finalResponseObject != null && finalResponseObject.headers() != null) {
            responseHeadersToUse = finalResponseObject.headers();
        } else if (responseInfo != null) {
            responseHeadersToUse = responseInfo.getHeaders();
        }
        if (responseHeadersToUse != null) {
            contentLengthResponseHeader = responseHeadersToUse.get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            transferEncodingResponseHeader = responseHeadersToUse.get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            errorUid = responseHeadersToUse.get("error_uid");
            responseTraceId = responseHeadersToUse.get(TRACE_ID);
        }
        if (responseInfo != null) {
            if (responseInfo.getUncompressedRawContentLength() != null) {
                uncompressedRawContentLength = String.valueOf(responseInfo.getUncompressedRawContentLength());
            }
            if (responseInfo.getFinalContentLength() != null) {
                finalContentLength = String.valueOf(responseInfo.getFinalContentLength());
            }
        }
        ArrayList<Pair<String, String>> logMessageAdditions = new ArrayList<Pair<String, String>>(Arrays.asList(Pair.of((Object)"accept-Req", (Object)request.getHeaders().get((CharSequence)HttpHeaderNames.ACCEPT)), Pair.of((Object)"content-type-Req", (Object)request.getHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE)), Pair.of((Object)"content-length-Res", (Object)contentLengthResponseHeader), Pair.of((Object)"transfer_encoding-Res", (Object)transferEncodingResponseHeader), Pair.of((Object)"http_status_code-Res", (Object)httpStatusCode), Pair.of((Object)"error_uid-Res", (Object)errorUid), Pair.of((Object)"X-B3-Sampled-Req", (Object)request.getHeaders().get(TRACE_ENABLED)), Pair.of((Object)"X-B3-SpanId-Req", (Object)request.getHeaders().get(SPAN_ID)), Pair.of((Object)"X-B3-TraceId-Req", (Object)request.getHeaders().get(TRACE_ID)), Pair.of((Object)"X-B3-TraceId-Res", (Object)responseTraceId), Pair.of((Object)"raw_content_length-Req", (Object)String.valueOf(request.getRawContentLengthInBytes())), Pair.of((Object)"raw_content_length-Res", (Object)uncompressedRawContentLength), Pair.of((Object)"final_content_length-Res", (Object)finalContentLength), Pair.of((Object)"elapsed_time_millis", (Object)(elapsedTimeMillis == null ? null : elapsedTimeMillis.toString()))));
        List<Pair<String, String>> customApplicationLogMessageExtras = this.customApplicationLogMessageExtras(request, finalResponseObject, responseInfo, elapsedTimeMillis);
        if (customApplicationLogMessageExtras != null) {
            logMessageAdditions.addAll(customApplicationLogMessageExtras);
        }
        return logMessageAdditions;
    }

    @Nullable
    protected List<Pair<String, String>> customApplicationLogMessageExtras(@NotNull RequestInfo<?> request, @Nullable HttpResponse finalResponseObject, @Nullable ResponseInfo responseInfo, @Nullable Long elapsedTimeMillis) {
        return null;
    }

    @NotNull
    protected String convertAdditionsToString(@Nullable List<Pair<String, String>> logMessageAdditions) {
        if (logMessageAdditions == null) {
            return "-";
        }
        return logMessageAdditions.stream().map(this::formatAdditionPairForLogMessage).collect(Collectors.joining(" "));
    }

    @NotNull
    protected String formatAdditionPairForLogMessage(@Nullable Pair<String, String> pair) {
        if (pair == null) {
            return "-";
        }
        String key = (String)pair.getKey();
        String value = (String)pair.getValue();
        if (key == null) {
            key = "-";
        }
        if (value == null) {
            value = "-";
        }
        return key + "=" + value;
    }

    @NotNull
    protected String concatenateCombinedLogAndAdditionStrings(@NotNull String combinedLogString, @NotNull String logMessageAdditionsAsString) {
        return combinedLogString + " " + logMessageAdditionsAsString;
    }

    static {
        cachedLocalIpAddressLastCheckedTime = 0L;
    }
}

