/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.util;

import com.nike.riposte.server.error.exception.InvalidCharsetInContentTypeHeaderException;
import com.nike.riposte.server.error.exception.PathParameterMatchingException;
import com.nike.riposte.server.http.Endpoint;
import com.nike.riposte.server.http.RequestInfo;
import com.nike.riposte.util.AntPathMatcher;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpUtils {
    protected static final Pattern CONTENT_TYPE_CHARSET_EXTRACTOR_PATTERN = Pattern.compile("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)");
    protected static final AntPathMatcher pathParamExtractor = new AntPathMatcher();

    protected HttpUtils() {
    }

    @NotNull
    public static String extractPath(@Nullable String uri) {
        if (uri == null) {
            return "";
        }
        int pathEndPos = uri.indexOf(63);
        if (pathEndPos < 0) {
            return uri;
        }
        return uri.substring(0, pathEndPos);
    }

    @Nullable
    public static String extractQueryString(@Nullable String uri) {
        if (uri == null) {
            return null;
        }
        int questionMarkPos = uri.indexOf(63);
        if (questionMarkPos < 0) {
            return null;
        }
        if (questionMarkPos + 1 >= uri.length()) {
            return null;
        }
        return uri.substring(questionMarkPos + 1);
    }

    @NotNull
    public static Charset determineCharsetFromContentType(@Nullable HttpHeaders headers, @NotNull Charset def) {
        if (headers == null) {
            return def;
        }
        String contentTypeHeader = headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentTypeHeader == null) {
            return def;
        }
        Matcher m = CONTENT_TYPE_CHARSET_EXTRACTOR_PATTERN.matcher(contentTypeHeader);
        if (m.find()) {
            String charset = m.group(1).trim().toUpperCase();
            try {
                return Charset.forName(charset);
            }
            catch (Exception ex) {
                throw new InvalidCharsetInContentTypeHeaderException("Invalid charset in Content-Type header", ex, contentTypeHeader);
            }
        }
        return def;
    }

    @Nullable
    public static List<HttpContent> extractContentChunks(@Nullable HttpRequest request) {
        if (!(request instanceof HttpContent)) {
            return null;
        }
        return Collections.singletonList((HttpContent)request);
    }

    @Nullable
    public static String convertRawBytesToString(@NotNull Charset contentCharset, @Nullable byte[] rawBytes) {
        if (contentCharset == null) {
            throw new IllegalArgumentException("contentCharset cannot be null");
        }
        if (rawBytes == null) {
            return null;
        }
        if (rawBytes.length == 0) {
            return "";
        }
        String rawString = new String(rawBytes, contentCharset);
        rawString = rawString.replace("\ufeff", "");
        return rawString;
    }

    @Nullable
    public static String convertContentChunksToRawString(@NotNull Charset contentCharset, @Nullable Collection<HttpContent> contentChunks) {
        byte[] rawBytes = HttpUtils.convertContentChunksToRawBytes(contentChunks);
        if (rawBytes == null) {
            return null;
        }
        return HttpUtils.convertRawBytesToString(contentCharset, rawBytes);
    }

    @Nullable
    public static byte[] convertContentChunksToRawBytes(@Nullable Collection<HttpContent> contentChunks) {
        if (contentChunks == null || contentChunks.size() == 0) {
            return null;
        }
        ByteBuf[] chunkByteBufs = (ByteBuf[])contentChunks.stream().map(ByteBufHolder::content).toArray(ByteBuf[]::new);
        int totalNumBytes = contentChunks.stream().mapToInt(chunk -> chunk.content().readableBytes()).sum();
        if (totalNumBytes == 0) {
            return null;
        }
        byte[] comboBytes = new byte[totalNumBytes];
        int bytesWrittenSoFar = 0;
        for (ByteBuf chunk2 : chunkByteBufs) {
            int numBytesInThisChunk = chunk2.readableBytes();
            chunk2.getBytes(chunk2.readerIndex(), comboBytes, bytesWrittenSoFar, chunk2.readableBytes());
            bytesWrittenSoFar += numBytesInThisChunk;
        }
        return comboBytes;
    }

    @Nullable
    public static HttpHeaders extractTrailingHeadersIfPossible(@Nullable HttpRequest request) {
        if (!(request instanceof LastHttpContent)) {
            return null;
        }
        return ((LastHttpContent)request).trailingHeaders();
    }

    @NotNull
    public static Set<Cookie> extractCookies(@Nullable HttpRequest request) {
        if (request == null) {
            return Collections.emptySet();
        }
        HttpHeaders trailingHeaders = HttpUtils.extractTrailingHeadersIfPossible(request);
        String cookieString = request.headers().get((CharSequence)HttpHeaderNames.COOKIE);
        if (cookieString == null && trailingHeaders != null) {
            cookieString = trailingHeaders.get((CharSequence)HttpHeaderNames.COOKIE);
        }
        if (cookieString != null) {
            return new HashSet<Cookie>(ServerCookieDecoder.LAX.decode(cookieString));
        }
        return Collections.emptySet();
    }

    @NotNull
    public static Map<String, String> decodePathParams(@NotNull String pathTemplate, @NotNull String path) {
        if (pathTemplate.endsWith("/")) {
            pathTemplate = pathTemplate.substring(0, pathTemplate.length() - 1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (!pathParamExtractor.match(pathTemplate, path)) {
            throw new PathParameterMatchingException("Cannot decode path params - path template and URI path do not match.", pathTemplate, path);
        }
        return pathParamExtractor.extractUriTemplateVariables(pathTemplate, path);
    }

    @NotNull
    public static String replaceUriPathVariables(@NotNull RequestInfo<?> request, @NotNull String downstreamDestinationUriPath) {
        for (Map.Entry<String, String> pathParamKeyValue : request.getPathParams().entrySet()) {
            String pathParamKey = pathParamKeyValue.getKey();
            String pathParamValue = pathParamKeyValue.getValue();
            downstreamDestinationUriPath = downstreamDestinationUriPath.replaceAll("\\{" + pathParamKey + "}", pathParamValue);
        }
        return downstreamDestinationUriPath;
    }

    public static boolean isMaxRequestSizeValidationDisabled(int configuredMaxRequestSize) {
        return configuredMaxRequestSize <= 0;
    }

    public static int getConfiguredMaxRequestSize(@Nullable Endpoint<?> endpoint, int globalConfiguredMaxRequestSizeInBytes) {
        Integer endpointMaxSizeOverride;
        Integer n = endpointMaxSizeOverride = endpoint == null ? null : endpoint.maxRequestSizeInBytesOverride();
        if (endpointMaxSizeOverride == null) {
            return globalConfiguredMaxRequestSizeInBytes;
        }
        return endpointMaxSizeOverride;
    }
}

