/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.util;

import com.nike.internal.util.Pair;
import io.netty.util.ResourceLeakDetector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainClassUtils {
    private static final Logger logger = LoggerFactory.getLogger(MainClassUtils.class);
    public static final String NETTY_LEAK_DETECTION_LEVEL_SYSTEM_PROP_KEY = "io.netty.leakDetectionLevel";
    public static final String NETTY_LEAK_DETECTION_LEVEL_APP_PROP_KEY = "netty.leakDetectionLevel";
    protected static final String DEBUG_ACTIONS_ENABLED_PROP_KEY = "debugActionsEnabled";
    public static final String DELAY_CRASH_ON_STARTUP_SYSTEM_PROP_KEY = "delayCrashOnStartup";
    public static final String JBOSS_LOGGING_PROVIDER_SYSTEM_PROP_KEY = "org.jboss.logging.provider";
    public static final long DEFAULT_CRASH_DELAY_MILLIS = 20000L;

    protected MainClassUtils() {
    }

    public static void setupJbossLoggingToUseSlf4j() {
        System.setProperty(JBOSS_LOGGING_PROVIDER_SYSTEM_PROP_KEY, "slf4j");
    }

    @NotNull
    public static Pair<String, String> getAppIdAndEnvironmentFromSystemProperties() {
        String appIdToUse = System.getProperty("@appId");
        if (appIdToUse == null) {
            appIdToUse = System.getProperty("archaius.deployment.applicationId");
        }
        if (appIdToUse == null) {
            throw new IllegalStateException("You must set the @appId or archaius.deployment.applicationId System property before this server will start. This tells the application Config system (Archaius, Typesafe, etc) which set of properties files should be loaded for this application.");
        }
        String environmentToUse = System.getProperty("@environment");
        if (environmentToUse == null) {
            environmentToUse = System.getProperty("archaius.deployment.environment");
        }
        if (environmentToUse == null) {
            throw new IllegalStateException("You must set the @environment or archaius.deployment.environment System property before this server will start. This tells the application Config system (Archaius, Typesafe, etc) which environment-specific properties file to load.");
        }
        return Pair.of((Object)appIdToUse, (Object)environmentToUse);
    }

    public static void setupNettyLeakDetectionLevel(@NotNull Function<String, Boolean> hasPropertyFunction, @NotNull Function<String, String> propertyExtractionFunction) {
        String nettyLeakDetectionLevel = System.getProperty(NETTY_LEAK_DETECTION_LEVEL_SYSTEM_PROP_KEY);
        if (nettyLeakDetectionLevel == null) {
            if (hasPropertyFunction.apply(NETTY_LEAK_DETECTION_LEVEL_SYSTEM_PROP_KEY).booleanValue()) {
                nettyLeakDetectionLevel = propertyExtractionFunction.apply(NETTY_LEAK_DETECTION_LEVEL_SYSTEM_PROP_KEY);
            } else if (hasPropertyFunction.apply(NETTY_LEAK_DETECTION_LEVEL_APP_PROP_KEY).booleanValue()) {
                nettyLeakDetectionLevel = propertyExtractionFunction.apply(NETTY_LEAK_DETECTION_LEVEL_APP_PROP_KEY);
            }
        }
        if (nettyLeakDetectionLevel == null) {
            logger.info("No netty leak detection level specified in System or application properties. The default Netty behavior will be used. netty_leak_detection_level_used={}", (Object)ResourceLeakDetector.getLevel());
        } else {
            nettyLeakDetectionLevel = nettyLeakDetectionLevel.toUpperCase();
            logger.info("Netty leak detection level specified in the System properties or application properties. netty_leak_detection_level_used={}", (Object)nettyLeakDetectionLevel);
            System.setProperty(NETTY_LEAK_DETECTION_LEVEL_SYSTEM_PROP_KEY, nettyLeakDetectionLevel);
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.valueOf((String)nettyLeakDetectionLevel));
        }
    }

    public static void logApplicationPropertiesIfDebugActionsEnabled(@NotNull Function<String, Boolean> hasPropertyFunction, @NotNull Function<String, String> propertyExtractionFunction, @NotNull Collection<String> applicationPropertyNames, boolean forceLogging) {
        boolean debugActionsEnabledInAppProps;
        boolean bl = debugActionsEnabledInAppProps = hasPropertyFunction.apply(DEBUG_ACTIONS_ENABLED_PROP_KEY) != false && Boolean.valueOf(propertyExtractionFunction.apply(DEBUG_ACTIONS_ENABLED_PROP_KEY)) != false;
        if (forceLogging || debugActionsEnabledInAppProps) {
            ArrayList<String> applicationPropertyNamesSorted = new ArrayList<String>(applicationPropertyNames);
            Collections.sort(applicationPropertyNamesSorted);
            logger.info("====== APP PROPERTIES ======");
            for (String propName : applicationPropertyNamesSorted) {
                String value = propertyExtractionFunction.apply(propName);
                logger.info(propName + ": " + value);
            }
            logger.info("====== END APP PROPERTIES ======");
        }
    }

    public static <T> T executeCallableWithLoggingReplayProtection(@NotNull Callable<T> callable, long delayInMillisIfExceptionOccurs) throws Exception {
        try {
            return callable.call();
        }
        catch (Throwable t) {
            MainClassUtils.outputExceptionalShutdownMessage("An exception occurred during startup (see exception stack trace following this message). Attempting to force SLF4J to finish initializing to make sure all the log messages are output and nothing is swallowed. See http://www.slf4j.org/codes.html#replay for info on why this can be necessary in some cases.", t, logger);
            try {
                LoggerFactory.getILoggerFactory();
                boolean shouldDelayCrash = "true".equals(System.getProperty(DELAY_CRASH_ON_STARTUP_SYSTEM_PROP_KEY, "false"));
                if (shouldDelayCrash) {
                    MainClassUtils.outputExceptionalShutdownMessage("Done with initialization call. Waiting " + delayInMillisIfExceptionOccurs + " milliseconds to give it time to finish before letting the app crash normally.", null, logger);
                    Thread.sleep(delayInMillisIfExceptionOccurs);
                    MainClassUtils.outputExceptionalShutdownMessage("Done waiting. The app will crash now.", null, logger);
                }
            }
            catch (Throwable lfEx) {
                MainClassUtils.outputExceptionalShutdownMessage("SLF4J exploded while trying to force initialization with the following error:", lfEx, logger);
            }
            throw t;
        }
    }

    public static <T> T executeCallableWithLoggingReplayProtection(@NotNull Callable<T> callable) throws Exception {
        return MainClassUtils.executeCallableWithLoggingReplayProtection(callable, 20000L);
    }

    private static void outputExceptionalShutdownMessage(@NotNull String message, @Nullable Throwable ex, @NotNull Logger logger) {
        System.err.println("STARTUP ERROR: " + message);
        if (ex != null) {
            ex.printStackTrace();
        }
        logger.error(message, ex);
    }
}

