/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.util;

import com.nike.riposte.server.http.RequestInfo;
import com.nike.riposte.util.MultiMatcher;
import com.nike.riposte.util.SingleMatcher;
import io.netty.handler.codec.http.HttpMethod;
import java.util.Collection;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public interface Matcher {
    @NotNull
    public Collection<HttpMethod> matchingMethods();

    @NotNull
    public Collection<String> matchingPathTemplates();

    @NotNull
    public Optional<String> matchesPath(@NotNull RequestInfo<?> var1);

    public boolean matchesMethod(@NotNull RequestInfo<?> var1);

    public boolean isMatchAllMethods();

    @NotNull
    public static Matcher match(@NotNull String matchingPathTemplate) {
        return SingleMatcher.match(matchingPathTemplate);
    }

    @NotNull
    public static Matcher match(@NotNull String matchingPathTemplate, HttpMethod ... matchingMethods) {
        return SingleMatcher.match(matchingPathTemplate, matchingMethods);
    }

    @NotNull
    public static Matcher match(@NotNull String matchingPathTemplate, @NotNull Collection<HttpMethod> matchingMethods) {
        return SingleMatcher.match(matchingPathTemplate, matchingMethods);
    }

    @NotNull
    public static Matcher multiMatch(@NotNull Collection<String> matchingPathTemplates) {
        return MultiMatcher.match(matchingPathTemplates);
    }

    @NotNull
    public static Matcher multiMatch(@NotNull Collection<String> matchingPathTemplates, HttpMethod ... matchingMethods) {
        return MultiMatcher.match(matchingPathTemplates, matchingMethods);
    }

    @NotNull
    public static Matcher multiMatch(@NotNull Collection<String> matchingPathTemplates, @NotNull Collection<HttpMethod> matchingMethods) {
        return MultiMatcher.match(matchingPathTemplates, matchingMethods);
    }
}

